/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.CaseBaseEvent;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class CasePlanEvent<I extends PlanItem<?>>
extends CaseBaseEvent {
    private transient I planItem;
    private final String planItemId;
    private final String type;

    protected CasePlanEvent(I i) {
        super(((CMMNElement)i).getCaseInstance());
        this.planItemId = ((PlanItem)i).getId();
        this.type = ((PlanItem)i).getType();
        this.planItem = i;
    }

    protected CasePlanEvent(Case case_, String string, String string2) {
        super(case_);
        this.planItemId = string;
        this.type = string2;
        this.planItem = null;
    }

    protected CasePlanEvent(ValueMap valueMap) {
        super(valueMap);
        this.planItemId = valueMap.readString(Fields.planItemId, new String[0]);
        this.type = valueMap.readString(Fields.type, new String[0]);
        this.planItem = null;
    }

    protected void setPlanItem(I i) {
        this.planItem = i;
    }

    protected I getPlanItem() {
        return this.planItem;
    }

    @Override
    public void updateState(Case case_) {
        if (this.planItem == null) {
            this.planItem = case_.getPlanItemById(this.getPlanItemId());
            if (this.planItem == null) {
                logger.error("MAJOR ERROR in " + this.getClass().getSimpleName() + ": Cannot recover event, because plan item with id " + this.planItemId + " cannot be found; Case instance " + this.getActorId() + " with definition name '" + case_.getDefinition().getName() + "'");
                return;
            }
        }
        this.updateState(this.planItem);
    }

    @Override
    public abstract void updateState(I var1);

    public void writeCasePlanEvent(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.planItemId, this.planItemId);
        this.writeField(jsonGenerator, Fields.type, this.type);
    }

    public String getType() {
        return this.type;
    }

    public String getPlanItemId() {
        return this.planItemId;
    }
}

