/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemEvent;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.util.Guid;

@Manifest
public class PlanItemCreated
extends PlanItemEvent {
    public final Instant createdOn;
    public final String createdBy;
    public final String planItemName;
    public final String stageId;
    public final String definitionId;

    public PlanItemCreated(Case case_) {
        this(case_, new Guid().toString(), case_.getDefinition().getCasePlanModel().getName(), null, case_.getDefinition().getCasePlanModel(), 0);
    }

    public PlanItemCreated(Stage<?> stage, ItemDefinition itemDefinition, String string, int n) {
        this(stage.getCaseInstance(), string, itemDefinition.getName(), stage, itemDefinition, n);
    }

    private PlanItemCreated(Case case_, String string, String string2, Stage<?> stage, ItemDefinition itemDefinition, int n) {
        super(case_, string, itemDefinition.getPlanItemDefinition().getType(), n, 0);
        this.createdOn = case_.getTransactionTimestamp();
        this.createdBy = case_.getCurrentUser().id();
        this.planItemName = string2;
        this.definitionId = itemDefinition.getId();
        this.stageId = stage == null ? "" : stage.getId();
    }

    public PlanItemCreated(ValueMap valueMap) {
        super(valueMap);
        this.createdOn = valueMap.readInstant(Fields.createdOn);
        this.createdBy = valueMap.readString(Fields.createdBy, new String[0]);
        this.planItemName = valueMap.readString(Fields.name, new String[0]);
        this.definitionId = valueMap.readString(Fields.definitionId, "");
        this.stageId = valueMap.readString(Fields.stageId, new String[0]);
    }

    @Override
    public String getDescription() {
        return "PlanItemCreated [" + this.getType() + "-" + this.getPlanItemName() + "." + this.getIndex() + "/" + this.getPlanItemId() + "]" + (String)(this.getStageId().isEmpty() ? "" : " in stage " + this.getStageId());
    }

    public String getPlanItemName() {
        return this.planItemName;
    }

    public String getStageId() {
        return this.stageId;
    }

    public PlanItem<?> getCreatedPlanItem() {
        return this.getPlanItem();
    }

    @Override
    public void updateState(Case case_) {
        PlanItem<?> planItem = case_.add(this);
        this.setPlanItem(planItem);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writePlanItemEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.name, this.planItemName);
        this.writeField(jsonGenerator, Fields.definitionId, this.definitionId);
        this.writeField(jsonGenerator, Fields.createdOn, this.createdOn);
        this.writeField(jsonGenerator, Fields.createdBy, this.createdBy);
        this.writeField(jsonGenerator, Fields.stageId, this.stageId);
    }

    @Override
    protected void updatePlanItemState(PlanItem<?> planItem) {
    }
}

