/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemEvent;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class RequiredRuleEvaluated
extends PlanItemEvent {
    private final boolean isRequired;

    public RequiredRuleEvaluated(PlanItem<?> planItem, boolean bl) {
        super(planItem);
        this.isRequired = bl;
    }

    public RequiredRuleEvaluated(ValueMap valueMap) {
        super(valueMap);
        this.isRequired = valueMap.readBoolean(Fields.isRequired, new Boolean[0]);
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "/" + this.getPlanItemId() + "]: REQUIRED = " + this.isRequired;
    }

    @Override
    protected void updatePlanItemState(PlanItem<?> planItem) {
        planItem.updateState(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writePlanItemEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.isRequired, this.isRequired);
    }
}

