/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.team.group;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamGroup;
import org.cafienne.cmmn.actorapi.command.team.GroupRoleMapping;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberChanged;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.cmmn.instance.team.Team;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class CaseTeamGroupChanged
extends CaseTeamMemberChanged<CaseTeamGroup> {
    public final Collection<GroupRoleMapping> removedMappings;

    private static Set<String> removedRoles(Set<GroupRoleMapping> set) {
        HashSet<String> hashSet = new HashSet<String>();
        set.forEach(groupRoleMapping -> hashSet.addAll(groupRoleMapping.getCaseRoles()));
        return hashSet;
    }

    public CaseTeamGroupChanged(Team team, CaseTeamGroup caseTeamGroup, Set<GroupRoleMapping> set) throws CaseTeamError {
        super(team, caseTeamGroup, CaseTeamGroupChanged.removedRoles(set));
        this.removedMappings = set;
    }

    public CaseTeamGroupChanged(ValueMap valueMap) {
        super(valueMap, CaseTeamGroup::deserialize);
        this.removedMappings = valueMap.readObjects(Fields.removedMappings, GroupRoleMapping::deserialize);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseTeamMemberEvent(jsonGenerator);
        this.writeListField(jsonGenerator, Fields.removedMappings, this.removedMappings);
    }

    @Override
    protected void updateState(Team team) {
        team.updateState((CaseTeamGroup)this.member);
    }
}

