/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.time.Duration;
import java.time.Instant;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.EventListenerDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.TimerEvent;
import org.cafienne.cmmn.instance.Transition;
import org.w3c.dom.Element;

public class TimerEventDefinition
extends EventListenerDefinition {
    private final ExpressionDefinition timerExpression = this.parse("timerExpression", ExpressionDefinition.class, true);

    public TimerEventDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
    }

    public ExpressionDefinition getTimerExpression() {
        return this.timerExpression;
    }

    @Override
    public String getContextDescription() {
        String string = ((XMLElementDefinition)this.getParentElement()).getType();
        String string2 = ((XMLElementDefinition)this.getParentElement()).getId();
        return "The expression in " + string + " '" + string2 + "'";
    }

    public Instant getMoment(TimerEvent timerEvent) {
        Duration duration = this.timerExpression.getEvaluator().evaluateTimerExpression(timerEvent, this);
        Instant instant = Instant.now().plus(duration);
        return instant;
    }

    public TimerEvent createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        return new TimerEvent(string, n, itemDefinition, this, stage);
    }

    @Override
    public Transition getEntryTransition() {
        return Transition.Occur;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameTimerEvent);
    }

    public boolean sameTimerEvent(TimerEventDefinition timerEventDefinition) {
        return this.samePlanItemDefinitionDefinition(timerEventDefinition) && this.same(this.timerExpression, timerEventDefinition.timerExpression);
    }
}

