/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.ConstraintDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.TimerEventDefinition;
import org.cafienne.cmmn.definition.parameter.ParameterDefinition;
import org.cafienne.cmmn.definition.sentry.IfPartDefinition;
import org.cafienne.cmmn.definition.task.AssignmentDefinition;
import org.cafienne.cmmn.definition.task.DueDateDefinition;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.TimerEvent;
import org.cafienne.cmmn.instance.parameter.TaskInputParameter;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.json.Value;
import org.cafienne.processtask.instance.ProcessTaskActor;

public interface CMMNExpressionEvaluator {
    public boolean evaluateItemControl(PlanItem<?> var1, ConstraintDefinition var2) throws InvalidExpressionException;

    public boolean evaluateIfPart(Criterion<?> var1, IfPartDefinition var2) throws InvalidExpressionException;

    public boolean evaluateApplicabilityRule(PlanItem<?> var1, DiscretionaryItemDefinition var2, ApplicabilityRuleDefinition var3) throws InvalidExpressionException;

    default public Duration evaluateTimerExpression(TimerEvent timerEvent, TimerEventDefinition timerEventDefinition) throws InvalidExpressionException {
        try {
            return Duration.parse(timerEventDefinition.getTimerExpression().getBody().trim());
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidExpressionException("The timer expression " + timerEventDefinition.getTimerExpression().getBody() + " in " + timerEventDefinition.getName() + " cannot be parsed into a Duration", dateTimeParseException);
        }
    }

    public Value<?> evaluateInputParameterTransformation(Case var1, TaskInputParameter var2, ParameterDefinition var3, Task<?> var4) throws InvalidExpressionException;

    public Value<?> evaluateOutputParameterTransformation(Case var1, Value<?> var2, ParameterDefinition var3, ParameterDefinition var4, Task<?> var5) throws InvalidExpressionException;

    default public Value<?> evaluateOutputParameterTransformation(ProcessTaskActor processTaskActor, Value<?> value, ParameterDefinition parameterDefinition, ParameterDefinition parameterDefinition2) {
        return Value.NULL;
    }

    default public String evaluateAssignee(HumanTask humanTask, AssignmentDefinition assignmentDefinition) throws InvalidExpressionException {
        return "";
    }

    default public Instant evaluateDueDate(HumanTask humanTask, DueDateDefinition dueDateDefinition) throws InvalidExpressionException {
        return null;
    }
}

