/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.command.platform.PlatformUpdate;
import org.cafienne.cmmn.actorapi.command.team.CurrentMember;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.CaseDefinitionApplied;
import org.cafienne.cmmn.actorapi.event.CaseEvent;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.DebugDisabled;
import org.cafienne.cmmn.actorapi.event.DebugEnabled;
import org.cafienne.cmmn.actorapi.event.migration.CaseDefinitionMigrated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.CasePlanDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.StageDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.definition.parameter.OutputParameterDefinition;
import org.cafienne.cmmn.instance.CasePlan;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.casefile.CaseFile;
import org.cafienne.cmmn.instance.parameter.CaseInputParameter;
import org.cafienne.cmmn.instance.parameter.CaseOutputParameter;
import org.cafienne.cmmn.instance.sentry.SentryNetwork;
import org.cafienne.cmmn.instance.team.Team;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.system.CaseSystem;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Case
extends ModelActor {
    private static final Logger logger = LoggerFactory.getLogger(Case.class);
    private Instant createdOn;
    private Collection<PlanItem<?>> planItems = new ArrayList();
    private CaseFile caseFile;
    private final SentryNetwork sentryNetwork;
    private CaseDefinition definition;
    private CasePlan casePlan;
    private String parentCaseId;
    private String rootCaseId;
    private Team caseTeam;

    public Case(CaseSystem caseSystem) {
        super(caseSystem);
        this.createdOn = this.getTransactionTimestamp();
        this.sentryNetwork = new SentryNetwork(this);
        logger.info("Recovering/creating case " + this.getId() + " with path " + this.self().path());
    }

    @Override
    public CaseUserIdentity getCurrentUser() {
        return super.getCurrentUser().asCaseUserIdentity();
    }

    @Override
    protected boolean supportsCommand(Object object) {
        return object instanceof CaseCommand;
    }

    @Override
    protected boolean supportsEvent(ModelEvent modelEvent) {
        return modelEvent instanceof CaseEvent;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public String getParentActorId() {
        return this.getParentCaseId();
    }

    @Override
    public String getRootActorId() {
        return this.getRootCaseId();
    }

    public CurrentMember getCurrentTeamMember() {
        return this.getCaseTeam().getTeamMember(this.getCurrentUser());
    }

    void registerPlanItem(PlanItem<?> planItem) {
        this.planItems.add(planItem);
    }

    public String stateToXMLString() {
        try {
            Document document;
            if (this.getDefinition() == null) {
                document = XMLHelper.loadXML("<Case id=\"" + this.getId() + "\"/>");
            } else {
                document = XMLHelper.loadXML("<Case name=\"" + this.getDefinition().getName() + "\" id=\"" + this.getId() + "\"/>");
                this.getCaseTeam().dumpMemoryStateToXML(document.getDocumentElement());
                this.getCaseFile().dumpMemoryStateToXML(document.getDocumentElement());
                this.getCasePlan().dumpMemoryStateToXML(document.getDocumentElement());
            }
            return XMLHelper.printXMLNode(document);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException("Cannot parse xml???", exception);
        }
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public CaseDefinition getDefinition() {
        return this.definition;
    }

    private void setDefinition(CaseDefinition caseDefinition) {
        this.definition = caseDefinition;
    }

    public <T extends PlanItem<?>> T getPlanItemById(String string) {
        return (T)((PlanItem)this.planItems.stream().filter(planItem -> planItem.getId().equals(string)).findFirst().orElse(null));
    }

    public PlanItem<?> getPlanItemByName(String string) {
        PlanItem<?> planItem = null;
        for (PlanItem<?> planItem2 : this.planItems) {
            if (!planItem2.getName().equals(string)) continue;
            planItem = planItem2;
        }
        return planItem;
    }

    public Collection<PlanItem<?>> getPlanItems() {
        return this.planItems;
    }

    public Collection<PlanItem<?>> getPlanItems(String string) {
        ArrayList arrayList = new ArrayList();
        for (PlanItem<?> planItem : this.getPlanItems()) {
            if (!planItem.getName().equals(string) && !planItem.getId().equals(string)) continue;
            arrayList.add(0, planItem);
        }
        return arrayList;
    }

    public SentryNetwork getSentryNetwork() {
        return this.sentryNetwork;
    }

    public CasePlan getCasePlan() {
        return this.casePlan;
    }

    public PlanItem<?> add(PlanItemCreated planItemCreated) {
        String string = planItemCreated.getStageId();
        if (string.isEmpty()) {
            CasePlanDefinition casePlanDefinition = this.getDefinition().getCasePlanModel();
            this.casePlan = casePlanDefinition.createInstance(planItemCreated.getPlanItemId(), 0, (ItemDefinition)casePlanDefinition, (Stage)null, this);
            return this.casePlan;
        }
        Stage stage = (Stage)this.getPlanItemById(string);
        if (stage == null) {
            logger.error("MAJOR ERROR: we cannot find the stage with id " + string + ", and therefore cannot recover plan item " + planItemCreated);
            return null;
        }
        CMMNElementDefinition cMMNElementDefinition = ((StageDefinition)stage.getDefinition()).getPlanItem(planItemCreated.planItemName);
        if (cMMNElementDefinition == null && (cMMNElementDefinition = ((StageDefinition)stage.getDefinition()).getDiscretionaryItem(planItemCreated.planItemName)) == null) {
            logger.error("MAJOR ERROR: we cannot find a plan item definition named '" + planItemCreated.planItemName + "' in stage " + planItemCreated.getStageId() + ", and therefore cannot recover plan item " + planItemCreated);
        }
        PlanItemDefinitionDefinition planItemDefinitionDefinition = cMMNElementDefinition.getPlanItemDefinition();
        return planItemDefinitionDefinition.createInstance(planItemCreated.getPlanItemId(), planItemCreated.getIndex(), (ItemDefinition)((Object)cMMNElementDefinition), stage, this);
    }

    public CaseFile getCaseFile() {
        if (this.caseFile == null) {
            this.caseFile = new CaseFile(this, this.getDefinition().getCaseFileModel());
        }
        return this.caseFile;
    }

    public Collection<DiscretionaryItem> getDiscretionaryItems() {
        this.addDebugInfo(() -> "Retrieving discretionary items of " + this, new Object[0]);
        ArrayList<DiscretionaryItem> arrayList = new ArrayList<DiscretionaryItem>();
        this.getCasePlan().retrieveDiscretionaryItems(arrayList);
        this.addDebugInfo(() -> "Discretionary items of " + this, new Object[0]);
        this.addDebugInfo(() -> {
            ValueList valueList = new ValueList(new Object[0]);
            arrayList.forEach(discretionaryItem -> valueList.add(discretionaryItem.asJson()));
            return valueList;
        }, new Object[0]);
        return arrayList;
    }

    public void applyCaseDefinition(CaseDefinition caseDefinition, String string, String string2) {
        this.setDefinition(caseDefinition);
        this.parentCaseId = string;
        this.rootCaseId = string2;
    }

    public void setInputParameters(ValueMap valueMap) {
        CaseDefinition caseDefinition = this.getDefinition();
        ((Map)valueMap.getValue()).forEach((string, value) -> {
            InputParameterDefinition inputParameterDefinition = caseDefinition.getInputParameters().get(string);
            new CaseInputParameter(inputParameterDefinition, this, (Value<?>)value);
        });
    }

    public void createCasePlan() {
        PlanItemCreated planItemCreated = new PlanItemCreated(this);
        this.addEvent(planItemCreated);
        planItemCreated.getCreatedPlanItem().makeTransition(Transition.Create);
    }

    public void releaseBootstrapCaseFileEvents() {
        this.addDebugInfo(() -> "Releasing potentially delayed Case File Events", new Object[0]);
        this.getCaseFile().releaseBootstrapEvents();
    }

    ValueMap getOutputParameters() {
        ValueMap valueMap = new ValueMap();
        this.getDefinition().getOutputParameters().forEach((string, outputParameterDefinition) -> {
            CaseOutputParameter caseOutputParameter = new CaseOutputParameter((OutputParameterDefinition)outputParameterDefinition, this);
            valueMap.put((String)string, caseOutputParameter.getValue());
        });
        return valueMap;
    }

    public boolean makePlanItemTransition(PlanItem<?> planItem, Transition transition) {
        return planItem.makeTransition(transition);
    }

    public String getParentCaseId() {
        return this.parentCaseId;
    }

    public String getRootCaseId() {
        return this.rootCaseId;
    }

    public Team getCaseTeam() {
        if (this.caseTeam == null) {
            this.caseTeam = new Team(this);
        }
        return this.caseTeam;
    }

    public void upsertDebugMode(boolean bl) {
        if (bl != this.debugMode()) {
            if (bl) {
                this.addEvent(new DebugEnabled(this));
            } else {
                this.addEvent(new DebugDisabled(this));
            }
        }
    }

    public void updatePlatformInformation(PlatformUpdate platformUpdate) {
        this.addEvent(new CaseAppliedPlatformUpdate(this, platformUpdate));
    }

    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
        this.getCaseTeam().updateState(caseAppliedPlatformUpdate);
        this.getCasePlan().updateState(caseAppliedPlatformUpdate);
    }

    public void migrate(CaseDefinition caseDefinition) {
        this.addEvent(new CaseDefinitionMigrated(this, caseDefinition));
    }

    public void migrateCaseDefinition(CaseDefinition caseDefinition) {
        this.addDebugInfo(() -> "====== Migrating Case[" + this.getId() + "] with name " + this.getDefinition().getName() + " to a new definition with name " + caseDefinition.getName() + "\n", new Object[0]);
        this.setDefinition(caseDefinition);
        this.getCaseTeam().migrateDefinition(caseDefinition.getCaseTeamModel());
        this.getCaseFile().migrateDefinition(caseDefinition.getCaseFileModel());
        this.getCasePlan().migrateDefinition(caseDefinition.getCasePlanModel());
    }

    public void removeDroppedPlanItem(PlanItem<?> planItem) {
        this.getSentryNetwork().disconnect(planItem);
        this.planItems.remove(planItem);
    }

    public void updateState(CaseDefinitionApplied caseDefinitionApplied) {
        this.createdOn = caseDefinitionApplied.createdOn;
        this.setEngineVersion(caseDefinitionApplied.engineVersion);
        this.applyCaseDefinition(caseDefinitionApplied.getDefinition(), caseDefinitionApplied.getParentCaseId(), caseDefinitionApplied.getRootCaseId());
    }

    @Override
    protected void completeTransaction(IncomingActorMessage incomingActorMessage) {
        int n = Long.valueOf(this.getPlanItems().stream().filter(planItem -> planItem.getState().isFailed()).count()).intValue();
        this.addEvent(new CaseModified(this, incomingActorMessage, n));
    }
}

