/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.sentry.CaseFileItemOnPartDefinition;
import org.cafienne.cmmn.definition.sentry.CriterionDefinition;
import org.cafienne.cmmn.definition.sentry.OnPartDefinition;
import org.cafienne.cmmn.definition.sentry.PlanItemOnPartDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.CasePlan;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.sentry.CaseFileItemOnPart;
import org.cafienne.cmmn.instance.sentry.CriteriaListener;
import org.cafienne.cmmn.instance.sentry.OnPart;
import org.cafienne.cmmn.instance.sentry.PlanItemOnPart;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;

public abstract class Criterion<D extends CriterionDefinition>
extends CMMNElement<D> {
    private final CriteriaListener listener;
    private final Collection<OnPart<?, ?, ?>> onParts = new ArrayList();
    private final Set<OnPart<?, ?, ?>> inactiveOnParts = new HashSet();
    private boolean isActive;

    protected Criterion(CriteriaListener criteriaListener, D d) {
        super(criteriaListener.item, d);
        this.listener = criteriaListener;
        for (OnPartDefinition onPartDefinition : ((CriterionDefinition)this.getDefinition()).getSentryDefinition().getOnParts()) {
            OnPart<?, ?, ?> onPart = onPartDefinition.createInstance(this);
            this.onParts.add(onPart);
            this.inactiveOnParts.add(onPart);
        }
        this.getCaseInstance().getSentryNetwork().add(this);
        this.onParts.forEach(OnPart::connectToCase);
    }

    public PlanItem<?> getTarget() {
        return this.listener.item;
    }

    public Stage<?> getStage() {
        return this.getTarget() instanceof CasePlan ? (CasePlan)this.getTarget() : this.getTarget().getStage();
    }

    private boolean evaluateIfPart() {
        this.addDebugInfo(() -> "Evaluating if part in " + this, new Object[0]);
        boolean bl = ((CriterionDefinition)this.getDefinition()).getSentryDefinition().getIfPart().evaluate(this);
        return bl;
    }

    void activate(OnPart<?, ?, ?> onPart) {
        this.inactiveOnParts.remove(onPart);
        if (this.inactiveOnParts.isEmpty()) {
            this.addDebugInfo(() -> this + " has become active", this.toJson());
        } else {
            this.addDebugInfo(() -> this + " has " + this.inactiveOnParts.size() + " remaining inactive on parts", this.toJson());
        }
        if (this.isSatisfied()) {
            this.isActive = true;
            this.listener.satisfy(this);
        }
    }

    void deactivate(OnPart<?, ?, ?> onPart) {
        this.isActive = false;
        this.inactiveOnParts.add(onPart);
        this.addDebugInfo(() -> this + " now has " + this.inactiveOnParts.size() + " inactive on parts", this.toJson());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSatisfied() {
        if (this.onParts.isEmpty()) {
            return this.evaluateIfPart();
        }
        return this.inactiveOnParts.isEmpty() && this.evaluateIfPart();
    }

    @Override
    public D getDefinition() {
        return (D)((CriterionDefinition)super.getDefinition());
    }

    public abstract boolean isEntryCriterion();

    @Override
    public String toString() {
        boolean bl = this.isActive();
        String string = this.onParts.stream().map(OnPart::toString).collect(Collectors.joining(","));
        return ((XMLElementDefinition)this.getDefinition()).getType() + " for " + this.getTarget() + " on [" + string + "] - " + (bl ? "active" : "inactive");
    }

    void establishPotentialConnection(PlanItem<?> planItem) {
        this.onParts.forEach(onPart -> onPart.establishPotentialConnection(planItem));
    }

    void removeConnection(PlanItem<?> planItem) {
        this.onParts.forEach(onPart -> onPart.removeConnection(planItem));
    }

    void establishPotentialConnection(CaseFileItem caseFileItem) {
        this.onParts.forEach(onPart -> onPart.establishPotentialConnection(caseFileItem));
    }

    void removeConnection(CaseFileItem caseFileItem) {
        this.onParts.forEach(onPart -> onPart.removeConnection(caseFileItem));
    }

    public Element dumpMemoryStateToXML(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("Sentry");
        element.appendChild(element2);
        element2.setAttribute("name", ((XMLElementDefinition)this.getDefinition()).getName());
        element2.setAttribute("id", ((XMLElementDefinition)this.getDefinition()).getId());
        element2.setAttribute("active", "" + this.inactiveOnParts.isEmpty());
        if (!bl) {
            element2.setAttribute("target", this.getTarget().getPath() + "." + ((CriterionDefinition)this.getDefinition()).getTransition());
        } else {
            element2.setAttribute("stage", this.getStage().getItemDefinition().getName());
        }
        this.onParts.forEach(onPart -> onPart.dumpMemoryStateToXML(element2, bl));
        return element2;
    }

    public ValueMap toJson() {
        ValueList valueList = new ValueList(new Object[0]);
        this.onParts.forEach(onPart -> valueList.add(onPart.toJson()));
        return new ValueMap("target", this.toString(), "active", this.inactiveOnParts.isEmpty(), "name", ((XMLElementDefinition)this.getDefinition()).getName(), "id", ((XMLElementDefinition)this.getDefinition()).getId(), "on-parts", valueList);
    }

    public void release() {
        this.getCaseInstance().getSentryNetwork().remove(this);
        this.onParts.forEach(OnPart::releaseFromCase);
    }

    @Override
    public void migrateDefinition(D d) {
        super.migrateDefinition(d);
        this.onParts.forEach(onPart -> {
            if (onPart instanceof CaseFileItemOnPart) {
                this.migrateCaseFileItemOnPart((CaseFileItemOnPart)onPart, d);
            } else if (onPart instanceof PlanItemOnPart) {
                this.migratePlanItemOnPart((PlanItemOnPart)onPart, d);
            }
        });
        this.addDebugInfo(() -> "Migrated " + this, new Object[0]);
    }

    private void migrateCaseFileItemOnPart(CaseFileItemOnPart caseFileItemOnPart, D d) {
        CaseFileItemOnPartDefinition caseFileItemOnPartDefinition = (CaseFileItemOnPartDefinition)caseFileItemOnPart.getDefinition();
        CaseFileItemOnPartDefinition caseFileItemOnPartDefinition2 = XMLElementDefinition.findDefinition(caseFileItemOnPartDefinition, ((CriterionDefinition)d).getSentryDefinition().getOnParts());
        if (caseFileItemOnPartDefinition2 != null) {
            caseFileItemOnPart.migrateDefinition(caseFileItemOnPartDefinition2);
        }
    }

    private void migratePlanItemOnPart(PlanItemOnPart planItemOnPart, D d) {
        PlanItemOnPartDefinition planItemOnPartDefinition = (PlanItemOnPartDefinition)planItemOnPart.getDefinition();
        PlanItemOnPartDefinition planItemOnPartDefinition2 = XMLElementDefinition.findDefinition(planItemOnPartDefinition, ((CriterionDefinition)d).getSentryDefinition().getOnParts());
        if (planItemOnPartDefinition2 != null) {
            planItemOnPart.migrateDefinition(planItemOnPartDefinition2);
        }
    }
}

