/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.task.process;

import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.actormodel.response.CommandResponseListener;
import org.cafienne.cmmn.definition.ProcessTaskDefinition;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.task.process.ProcessInformer;
import org.cafienne.cmmn.instance.task.process.ProcessTask;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.actorapi.command.ProcessCommand;
import org.cafienne.processtask.actorapi.command.ReactivateProcess;
import org.cafienne.processtask.actorapi.command.ResumeProcess;
import org.cafienne.processtask.actorapi.command.StartProcess;
import org.cafienne.processtask.actorapi.command.SuspendProcess;
import org.cafienne.processtask.actorapi.command.TerminateProcess;

class ProcessTaskActorInformer
extends ProcessInformer {
    public ProcessTaskActorInformer(ProcessTask processTask) {
        super(processTask);
    }

    @Override
    protected void startImplementation(ValueMap valueMap) {
        String string = this.task.getId();
        CaseUserIdentity caseUserIdentity = this.getCaseInstance().getCurrentUser();
        String string2 = this.getCaseInstance().getTenant();
        String string3 = this.task.getName();
        String string4 = this.task.getCaseInstance().getRootActorId();
        String string5 = this.task.getCaseInstance().getId();
        boolean bl = this.task.getCaseInstance().debugMode();
        this.getCaseInstance().askProcess(new StartProcess(caseUserIdentity, string2, string, string3, ((ProcessTaskDefinition)this.task.getDefinition()).getImplementationDefinition(), valueMap, string5, string4, bl), commandFailure -> this.task.goFault(new ValueMap("exception", commandFailure.toJson())), modelResponse -> {
            if (!((ProcessTaskDefinition)this.task.getDefinition()).isBlocking()) {
                this.task.goComplete(new ValueMap());
            }
        });
    }

    @Override
    protected void suspendInstance() {
        this.tell(new SuspendProcess(this.getCaseInstance().getCurrentUser(), this.task.getId()));
    }

    @Override
    protected void resumeInstance() {
        this.tell(new ResumeProcess(this.getCaseInstance().getCurrentUser(), this.task.getId()));
    }

    @Override
    protected void terminateInstance() {
        if (this.task.getHistoryState() == State.Available) {
            this.getCaseInstance().addDebugInfo(() -> "Terminating process task '" + this.task.getName() + "' without it being started; no need to inform the task actor", new Object[0]);
        } else {
            this.tell(new TerminateProcess(this.getCaseInstance().getCurrentUser(), this.task.getId()));
        }
    }

    @Override
    protected void reactivateImplementation(ValueMap valueMap) {
        this.tell(new ReactivateProcess(this.getCaseInstance().getCurrentUser(), this.task.getId(), valueMap));
    }

    private void tell(ProcessCommand processCommand) {
        if (!((ProcessTaskDefinition)this.task.getDefinition()).isBlocking()) {
            return;
        }
        this.getCaseInstance().askProcess(processCommand, commandFailure -> this.task.goFault(new ValueMap("exception", commandFailure.toJson())), new CommandResponseListener[0]);
    }
}

