/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamGroup;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamMember;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamTenantRole;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamUser;
import org.cafienne.cmmn.actorapi.command.team.CurrentMember;
import org.cafienne.cmmn.actorapi.command.team.GroupRoleMapping;
import org.cafienne.cmmn.actorapi.command.team.UpsertMemberData;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberRemoved;
import org.cafienne.cmmn.actorapi.event.team.deprecated.DeprecatedCaseTeamEvent;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupAdded;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupChanged;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupRemoved;
import org.cafienne.cmmn.actorapi.event.team.tenantrole.CaseTeamTenantRoleAdded;
import org.cafienne.cmmn.actorapi.event.team.tenantrole.CaseTeamTenantRoleChanged;
import org.cafienne.cmmn.actorapi.event.team.tenantrole.CaseTeamTenantRoleRemoved;
import org.cafienne.cmmn.actorapi.event.team.user.CaseTeamUserAdded;
import org.cafienne.cmmn.actorapi.event.team.user.CaseTeamUserChanged;
import org.cafienne.cmmn.actorapi.event.team.user.CaseTeamUserRemoved;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.definition.team.CaseTeamDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.Case;
import org.w3c.dom.Element;

public class Team
extends CMMNElement<CaseTeamDefinition> {
    private final Map<String, CaseTeamUser> users = new HashMap<String, CaseTeamUser>();
    private final Map<String, CaseTeamTenantRole> tenantRoles = new HashMap<String, CaseTeamTenantRole>();
    private final Map<String, CaseTeamGroup> groups = new HashMap<String, CaseTeamGroup>();

    public Team(Case case_) {
        super(case_, case_.getDefinition().getCaseTeamModel());
    }

    public void create(CaseTeam caseTeam) {
        this.replace(caseTeam);
    }

    public void replace(CaseTeam caseTeam) {
        this.users.keySet().stream().filter(caseTeam::notHasUser).collect(Collectors.toList()).forEach(this::removeUser);
        caseTeam.getUsers().forEach(this::setUser);
        this.groups.keySet().stream().filter(caseTeam::notHasGroup).collect(Collectors.toList()).forEach(this::removeGroup);
        caseTeam.getGroups().forEach(this::setGroup);
        this.tenantRoles.keySet().stream().filter(caseTeam::notHasTenantRole).collect(Collectors.toList()).forEach(this::removeTenantRole);
        caseTeam.getTenantRoles().forEach(this::setTenantRole);
    }

    public CaseTeamUser getUser(String string) {
        return this.users.get(string);
    }

    public CaseTeamTenantRole getTenantRole(String string) {
        return this.tenantRoles.get(string);
    }

    public CaseTeamGroup getGroup(String string) {
        return this.groups.get(string);
    }

    public void upsert(UpsertMemberData upsertMemberData) {
        if (upsertMemberData.isUser()) {
            CaseTeamUser caseTeamUser = this.users.get(upsertMemberData.id());
            this.setUser(upsertMemberData.asUser(caseTeamUser));
        } else {
            CaseTeamTenantRole caseTeamTenantRole = this.tenantRoles.get(upsertMemberData.id());
            this.setTenantRole(upsertMemberData.asTenantRole(caseTeamTenantRole));
        }
    }

    public void removeUser(String string) {
        CaseTeamUser caseTeamUser = this.users.get(string);
        if (caseTeamUser != null) {
            this.addEvent(new CaseTeamUserRemoved(this, caseTeamUser));
        }
    }

    public void removeGroup(String string) {
        CaseTeamGroup caseTeamGroup = this.groups.get(string);
        if (caseTeamGroup != null) {
            this.addEvent(new CaseTeamGroupRemoved(this, caseTeamGroup));
        }
    }

    public void removeTenantRole(String string) {
        CaseTeamTenantRole caseTeamTenantRole = this.tenantRoles.get(string);
        if (caseTeamTenantRole != null) {
            this.addEvent(new CaseTeamTenantRoleRemoved(this, caseTeamTenantRole));
        }
    }

    private Set<String> getRemovedRoles(CaseTeamMember caseTeamMember, CaseTeamMember caseTeamMember2) {
        return caseTeamMember2.getCaseRoles().stream().filter(string -> !caseTeamMember.getCaseRoles().contains(string)).collect(Collectors.toSet());
    }

    private boolean hasChangeInfo(CaseTeamMember caseTeamMember, CaseTeamMember caseTeamMember2) {
        boolean bl = caseTeamMember.isOwner() != caseTeamMember2.isOwner();
        Set set = caseTeamMember.getCaseRoles().stream().filter(string -> !caseTeamMember.getCaseRoles().contains(string)).collect(Collectors.toSet());
        return bl || !set.isEmpty();
    }

    public void setUser(CaseTeamUser caseTeamUser) {
        CaseTeamUser caseTeamUser2 = this.users.get(caseTeamUser.userId());
        if (caseTeamUser2 == null) {
            this.addEvent(new CaseTeamUserAdded(this, caseTeamUser));
        } else {
            Set<String> set = this.getRemovedRoles(caseTeamUser, caseTeamUser2);
            if (this.hasChangeInfo(caseTeamUser, caseTeamUser2) || !set.isEmpty()) {
                this.addEvent(new CaseTeamUserChanged(this, caseTeamUser, set));
            }
        }
    }

    public void setGroup(CaseTeamGroup caseTeamGroup) {
        CaseTeamGroup caseTeamGroup2 = this.groups.get(caseTeamGroup.groupId());
        if (caseTeamGroup2 == null) {
            this.addEvent(new CaseTeamGroupAdded(this, caseTeamGroup));
        } else if (caseTeamGroup2.differsFrom(caseTeamGroup)) {
            Set<GroupRoleMapping> set = caseTeamGroup2.getRemovedMappings(caseTeamGroup);
            this.addEvent(new CaseTeamGroupChanged(this, caseTeamGroup, set));
        }
    }

    public void setTenantRole(CaseTeamTenantRole caseTeamTenantRole) {
        CaseTeamTenantRole caseTeamTenantRole2 = this.tenantRoles.get(caseTeamTenantRole.tenantRoleName());
        if (caseTeamTenantRole2 == null) {
            this.addEvent(new CaseTeamTenantRoleAdded(this, caseTeamTenantRole));
        } else {
            Set<String> set = this.getRemovedRoles(caseTeamTenantRole, caseTeamTenantRole2);
            if (this.hasChangeInfo(caseTeamTenantRole, caseTeamTenantRole2) || !set.isEmpty()) {
                this.addEvent(new CaseTeamTenantRoleChanged(this, caseTeamTenantRole, set));
            }
        }
    }

    public Collection<CaseTeamMember> getMembers() {
        ArrayList<CaseTeamMember> arrayList = new ArrayList<CaseTeamMember>();
        arrayList.addAll(this.users.values());
        arrayList.addAll(this.tenantRoles.values());
        arrayList.addAll(this.groups.values());
        return arrayList;
    }

    public Collection<CaseTeamUser> getUsers() {
        return this.users.values();
    }

    public Collection<CaseTeamGroup> getGroups() {
        return this.groups.values();
    }

    public Collection<CaseTeamTenantRole> getTenantRoles() {
        return this.tenantRoles.values();
    }

    public Collection<CaseTeamMember> getOwners() {
        return this.getMembers().stream().filter(CaseTeamMember::isOwner).collect(Collectors.toList());
    }

    public void updateState(CaseTeamUser caseTeamUser) {
        this.users.put(caseTeamUser.userId(), caseTeamUser);
    }

    public void updateState(CaseTeamGroup caseTeamGroup) {
        this.groups.put(caseTeamGroup.groupId(), caseTeamGroup);
    }

    public void updateState(CaseTeamTenantRole caseTeamTenantRole) {
        this.tenantRoles.put(caseTeamTenantRole.tenantRoleName(), caseTeamTenantRole);
    }

    public void updateState(CaseTeamMemberRemoved<?> caseTeamMemberRemoved) {
        CaseTeamMember caseTeamMember = caseTeamMemberRemoved.member;
        String string = caseTeamMember.memberId();
        switch (caseTeamMember.memberType()) {
            case TenantRole: {
                this.tenantRoles.remove(string);
                break;
            }
            case User: {
                this.users.remove(string);
                break;
            }
            case Group: {
                this.groups.remove(string);
            }
        }
    }

    public void updateState(DeprecatedCaseTeamEvent deprecatedCaseTeamEvent) {
        if (deprecatedCaseTeamEvent.isUserEvent()) {
            CaseTeamUser.handleDeprecatedUserEvent(this.users, deprecatedCaseTeamEvent);
        } else {
            CaseTeamTenantRole.handleDeprecatedTenantRoleEvent(this.tenantRoles, deprecatedCaseTeamEvent);
        }
    }

    public void dumpMemoryStateToXML(Element element) {
        Element element2 = element.getOwnerDocument().createElement("CaseTeam");
        element.appendChild(element2);
    }

    public String getMemberWithRole(String string) {
        for (CaseTeamMember caseTeamMember : this.getMembers()) {
            Set<String> set = caseTeamMember.getCaseRoles();
            for (String string2 : set) {
                if (!string2.equals(string)) continue;
                return caseTeamMember.memberId();
            }
        }
        return null;
    }

    public CaseTeam createSubCaseTeam(CaseDefinition caseDefinition) {
        return CaseTeam.createSubTeam(this, caseDefinition.getCaseTeamModel());
    }

    public void validateMembership(CaseUserIdentity caseUserIdentity) {
        CurrentMember currentMember = new CurrentMember(this, caseUserIdentity);
        if (!currentMember.isValid()) {
            throw new AuthorizationException("User " + caseUserIdentity.id() + " is not part of the case team");
        }
    }

    public CurrentMember getTeamMember(CaseUserIdentity caseUserIdentity) {
        return new CurrentMember(this, caseUserIdentity);
    }

    public void upsertCaseTeamUser(CaseUserIdentity caseUserIdentity, CaseRoleDefinition caseRoleDefinition) {
        CaseTeamUser caseTeamUser = this.users.get(caseUserIdentity.id());
        if (caseTeamUser == null) {
            this.addDebugInfo(() -> "Adding unknown user '" + caseUserIdentity.id() + "' to case team because of dynamic task assignment", new Object[0]);
            this.setUser(CaseTeamUser.create(caseUserIdentity, caseRoleDefinition));
        } else if (!caseTeamUser.isOwner() && caseRoleDefinition != null && !caseTeamUser.getCaseRoles().contains(caseRoleDefinition.getName())) {
            this.addDebugInfo(() -> "Adding case role '" + caseRoleDefinition.getName() + "' to '" + caseUserIdentity.id() + "' because of task assignment", new Object[0]);
            this.setUser(caseTeamUser.extend(caseRoleDefinition.getName()));
        }
    }

    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
        caseAppliedPlatformUpdate.newUserInformation.info().foreach(newUserInformation -> {
            CaseTeamUser caseTeamUser = this.getUser(newUserInformation.existingUserId());
            if (caseTeamUser != null) {
                this.addDebugInfo(() -> "Replace case team member user id from " + newUserInformation.existingUserId() + " to " + newUserInformation.newUserId(), new Object[0]);
                CaseTeamUser caseTeamUser2 = caseTeamUser.cloneUser(newUserInformation.newUserId());
                this.users.remove(caseTeamUser.userId());
                this.users.put(caseTeamUser2.userId(), caseTeamUser2);
            }
            return newUserInformation;
        });
    }

    @Override
    public void migrateDefinition(CaseTeamDefinition caseTeamDefinition) {
        super.migrateDefinition(caseTeamDefinition);
        Map<String, CaseRoleDefinition> map = caseTeamDefinition.getCaseRoles().stream().collect(Collectors.toMap(XMLElementDefinition::getName, caseRoleDefinition -> caseRoleDefinition));
        Map<String, CaseRoleDefinition> map2 = caseTeamDefinition.getCaseRoles().stream().collect(Collectors.toMap(XMLElementDefinition::getId, caseRoleDefinition -> caseRoleDefinition));
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        this.addDebugInfo(() -> "\nMigrating Case Team", new Object[0]);
        ((CaseTeamDefinition)this.getPreviousDefinition()).getCaseRoles().forEach(caseRoleDefinition -> {
            String string = caseRoleDefinition.getName();
            String string2 = caseRoleDefinition.getId();
            CaseRoleDefinition caseRoleDefinition2 = (CaseRoleDefinition)map.get(string);
            CaseRoleDefinition caseRoleDefinition3 = (CaseRoleDefinition)map2.get(string2);
            if (caseRoleDefinition2 != null) {
                if (!string.isBlank()) {
                    this.addDebugInfo(() -> "- role '" + string + "' is not changed", new Object[0]);
                }
            } else if (caseRoleDefinition3 != null) {
                this.addDebugInfo(() -> "- role '" + string + "' is renamed to '" + caseRoleDefinition3.getName() + "'", new Object[0]);
                hashSet.add(caseRoleDefinition.getName());
                hashMap.put(caseRoleDefinition.getName(), caseRoleDefinition3.getName());
            } else {
                this.addDebugInfo(() -> "- role '" + string + "' is dropped", new Object[0]);
                hashSet.add(caseRoleDefinition.getName());
            }
        });
        this.getMembers().forEach(caseTeamMember -> {
            this.addDebugInfo(() -> "=== Migrating Case Team " + caseTeamMember.memberType() + " '" + caseTeamMember.memberId() + "'", new Object[0]);
            caseTeamMember.migrateRoles(this, hashMap, hashSet);
        });
        this.addDebugInfo(() -> "Completed Case Team migration\n", new Object[0]);
    }

    @Override
    public String toString() {
        return "Team{users=" + this.users + ", tenantRoles=" + this.tenantRoles + ", groups=" + this.groups + "}";
    }
}

