/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.command.StartCase;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamUser;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.InvalidDefinitionException;
import org.cafienne.cmmn.repository.MissingDefinitionException;
import org.cafienne.cmmn.test.CaseEventListener;
import org.cafienne.cmmn.test.CaseResponseValidator;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.CaseValidator;
import org.cafienne.cmmn.test.FailureValidator;
import org.cafienne.cmmn.test.ForceRecoveryCommand;
import org.cafienne.cmmn.test.ForceTermination;
import org.cafienne.cmmn.test.PingCommand;
import org.cafienne.cmmn.test.TestScriptCommand;
import org.cafienne.cmmn.test.TestUser;
import org.cafienne.cmmn.test.assertions.CaseAssertion;
import org.cafienne.cmmn.test.assertions.FailureAssertion;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.json.ValueMap;
import org.cafienne.system.CaseSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public class TestScript {
    private final String testName;
    private static final Logger logger = LoggerFactory.getLogger(TestScript.class);
    private final CaseSystem caseSystem;
    private boolean testCompleted;
    private final Deque<CaseTestCommand> commands = new ArrayDeque<CaseTestCommand>();
    private CaseTestCommand current;
    private int actionNumber = 0;
    private static final String defaultTenant = "hard-coded-test-tenant";
    private final CaseEventListener eventListener;
    private Throwable exceptionFromTest;

    public static DefinitionsDocument getDefinitions(String string) {
        try {
            return Cafienne.config().repository().DefinitionProvider().read(null, null, string);
        }
        catch (InvalidDefinitionException | MissingDefinitionException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static CaseDefinition getCaseDefinition(String string) throws MissingDefinitionException {
        return TestScript.getDefinitions(string).getFirstCase();
    }

    public static void getInvalidDefinition(String string) throws InvalidDefinitionException {
        try {
            Cafienne.config().repository().DefinitionProvider().read(null, null, string);
        }
        catch (MissingDefinitionException missingDefinitionException) {
            throw new AssertionError((Object)missingDefinitionException);
        }
    }

    public static TestUser getTestUser(String string, String ... stringArray) {
        return new TestUser(string, stringArray);
    }

    public static CaseTeam getCaseTeam(Object ... objectArray) {
        ArrayList<CaseTeamUser> arrayList = new ArrayList<CaseTeamUser>();
        for (Object object : objectArray) {
            if (object instanceof TestUser) {
                arrayList.add(TestScript.getMember((TestUser)object));
                continue;
            }
            if (object instanceof CaseTeamUser) {
                arrayList.add((CaseTeamUser)object);
                continue;
            }
            throw new IllegalArgumentException("Cannot accept users of type " + object.getClass().getName());
        }
        return CaseTeam.create(arrayList);
    }

    public static CaseTeamUser getOwner(TestUser testUser) {
        return testUser.asCaseOwner();
    }

    public static CaseTeamUser getMember(TestUser testUser) {
        return testUser.asCaseMember();
    }

    public TestScript(String string) {
        logger.info("\n\n\t\t============ Creating new test '" + string + "' ========================\n\n");
        this.testName = string;
        this.caseSystem = new CaseSystem("Case-Engine-Test-Script");
        this.eventListener = new CaseEventListener(this);
        logger.info("Ready to receive responses from the case system for test '" + string + "'");
    }

    public StartCase createCaseCommand(TestUser testUser, String string, CaseDefinition caseDefinition) {
        return this.createCaseCommand(testUser, string, caseDefinition, new ValueMap());
    }

    public StartCase createCaseCommand(TestUser testUser, String string, CaseDefinition caseDefinition, ValueMap valueMap) {
        return this.createCaseCommand(testUser, string, caseDefinition, valueMap, TestScript.getCaseTeam(TestScript.getOwner(testUser)));
    }

    public StartCase createCaseCommand(TestUser testUser, String string, CaseDefinition caseDefinition, CaseTeam caseTeam) {
        return this.createCaseCommand(testUser, string, caseDefinition, new ValueMap(), caseTeam);
    }

    public StartCase createCaseCommand(TestUser testUser, String string, CaseDefinition caseDefinition, ValueMap valueMap, CaseTeam caseTeam) {
        return this.createCaseCommand(defaultTenant, testUser, string, caseDefinition, valueMap, caseTeam);
    }

    public StartCase createCaseCommand(String string, TestUser testUser, String string2, CaseDefinition caseDefinition, ValueMap valueMap, CaseTeam caseTeam) {
        return new StartCase(string, testUser, string2, caseDefinition, valueMap, caseTeam, Cafienne.config().actor().debugEnabled());
    }

    public PingCommand createPingCommand(TestUser testUser, String string, long l) {
        return new PingCommand(defaultTenant, testUser, string, l);
    }

    public ForceRecoveryCommand createRecoveryCommand(TestUser testUser, String string) {
        return new ForceRecoveryCommand(defaultTenant, testUser, string);
    }

    public ForceTermination createTerminationCommand(TestUser testUser, String string) {
        return new ForceTermination(defaultTenant, testUser, string);
    }

    public CaseDefinition getDefinition(String string) throws MissingDefinitionException {
        return TestScript.getCaseDefinition(string);
    }

    public static void debugMessage(Object object) {
        logger.debug(String.valueOf(object));
    }

    private void addTestStep(CaseCommand caseCommand, CaseResponseValidator caseResponseValidator) {
        this.commands.addLast(new CaseTestCommand(this, caseCommand, caseResponseValidator));
    }

    private void insertTestStep(CaseCommand caseCommand, CaseResponseValidator caseResponseValidator) {
        this.commands.addFirst(new CaseTestCommand(this, caseCommand, caseResponseValidator));
    }

    public void assertStepFails(CaseCommand caseCommand, FailureValidator failureValidator) {
        this.addTestStep(caseCommand, caseTestCommand -> failureValidator.validate(new FailureAssertion(caseTestCommand)));
    }

    public void assertStepFails(CaseCommand caseCommand) {
        this.addTestStep(caseCommand, FailureAssertion::new);
    }

    public void insertStepFails(CaseCommand caseCommand, FailureValidator failureValidator) {
        this.insertTestStep(caseCommand, caseTestCommand -> failureValidator.validate(new FailureAssertion(caseTestCommand)));
    }

    public void addStep(CaseCommand caseCommand, CaseValidator caseValidator) {
        this.addTestStep(caseCommand, caseTestCommand -> caseValidator.validate(new CaseAssertion(caseTestCommand)));
    }

    public void addStep(CaseCommand caseCommand) {
        this.addTestStep(caseCommand, CaseAssertion::new);
    }

    public void insertStep(CaseCommand caseCommand, CaseValidator caseValidator) {
        this.insertTestStep(caseCommand, caseTestCommand -> caseValidator.validate(new CaseAssertion(caseTestCommand)));
    }

    public int getActionNumber() {
        return this.actionNumber;
    }

    private void continueTest() {
        if (this.commands.isEmpty()) {
            this.finish(null);
            return;
        }
        this.current = this.commands.removeFirst();
        ++this.actionNumber;
        if (this.current.isTestScriptCommand()) {
            TestScriptCommand testScriptCommand = (TestScriptCommand)this.current.getActualCommand();
            testScriptCommand.beforeSendCommand(this);
            if (testScriptCommand.isLocal()) {
                new Thread(() -> {
                    System.out.println(" OH YEAH " + Thread.currentThread().getName());
                    this.current.runValidation();
                    this.continueTest();
                }).start();
            } else {
                logger.debug("Sending test command " + this.current.getActionNumber() + ": [" + this.current + "] to case " + this.current.getActorId());
                this.eventListener.sendCommand(this.current);
            }
        } else {
            logger.debug("Sending test command " + this.current.getActionNumber() + ": [" + this.current + "] to case " + this.current.getActorId());
            this.eventListener.sendCommand(this.current);
        }
    }

    public void complete() {
    }

    public void abort(Throwable throwable) {
    }

    public void runTest() {
        this.runTest(20000L);
    }

    public void runTest(long l) {
        this.continueTest();
        this.awaitCompletion(l);
        if (this.testCompleted) {
            logger.info("\n\n\t\t============ Completed test '" + this.testName + "' ========================\n\n");
        } else {
            logger.info("\n\n\t\t============ Could not complete test '" + this.testName + "' ========================\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitCompletion(long l) {
        Object object = this;
        synchronized (object) {
            while (!this.testCompleted && l > 0L) {
                try {
                    this.wait(1000L);
                    l -= 1000L;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.testCompleted || l >= 10000L) continue;
                logger.warn("Waiting another " + l / 1000L + " seconds for completion of test '" + this.testName + "'");
            }
        }
        this.closeDown();
        if (!this.testCompleted) {
            throw new AssertionError((Object)("Test '" + this.testName + "' was not completed; got stuck at action " + this.actionNumber + " (command " + this.current + ")"));
        }
        if (this.exceptionFromTest != null) {
            try {
                object = new FileOutputStream(this.getNextErrorFile());
                this.exceptionFromTest.printStackTrace(new PrintStream((OutputStream)object));
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (this.exceptionFromTest instanceof RuntimeException) {
                throw (RuntimeException)this.exceptionFromTest;
            }
            if (this.exceptionFromTest instanceof Error) {
                throw (Error)this.exceptionFromTest;
            }
            throw new RuntimeException(this.exceptionFromTest);
        }
    }

    private File getNextErrorFile() {
        int n = 0;
        File file = new File("logs");
        if (!file.exists()) {
            file.mkdirs();
        }
        String string = this.testName + "_" + n + "_error.txt";
        File file2 = new File(file, string);
        while (file2.exists()) {
            string = this.testName + "_" + ++n + "_error.txt";
            file2 = new File(file, string);
            if (n <= 1000) continue;
            System.err.println("Clean up your error files");
            System.exit(-1);
        }
        return file2;
    }

    private synchronized void finish(Throwable throwable) {
        if (throwable != null) {
            this.abort(throwable);
        } else {
            this.complete();
        }
        this.testCompleted = true;
        this.exceptionFromTest = throwable;
        this.notifyAll();
    }

    private void closeDown() {
        logger.debug("Closing down actor system");
        try {
            Await.result((Awaitable)this.caseSystem.system().terminate(), (Duration)Duration.create((long)10L, (String)"seconds"));
        }
        catch (Exception exception) {
            logger.error("ISSUE terminating the actor system " + exception.getMessage());
        }
    }

    public CaseEventListener getEventListener() {
        return this.eventListener;
    }

    void handleResponse(Object object) {
        if (!(object instanceof ModelResponse)) {
            this.finish((Throwable)((Object)new AssertionError((Object)("Received an unexpected message while executing test script; message:\n:" + object))));
            return;
        }
        if (this.current == null) {
            this.finish((Throwable)((Object)new AssertionError((Object)("Received an unexpected message while executing test script; message:\n:" + object))));
            return;
        }
        try {
            if (object instanceof CommandFailure) {
                this.current.handleFailure((CommandFailure)object);
            } else {
                this.current.handleResponse((CaseResponse)object);
            }
        }
        catch (Throwable throwable) {
            this.finish(throwable);
            return;
        }
        this.continueTest();
    }

    public CaseSystem getCaseSystem() {
        return this.caseSystem;
    }
}

