/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.util.stream.Stream;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.TestScript;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;
import org.cafienne.cmmn.test.assertions.StageAssertion;
import org.cafienne.cmmn.test.assertions.file.CaseFileAssertion;
import org.cafienne.cmmn.test.assertions.file.CaseFileItemAssertion;
import org.cafienne.cmmn.test.filter.EventFilter;

public class CaseAssertion
extends StageAssertion {
    private final CaseFileAssertion caseFileAssertion;

    public CaseAssertion(CaseTestCommand caseTestCommand) {
        super(caseTestCommand, CaseAssertion.getCasePlan(caseTestCommand));
        this.caseFileAssertion = new CaseFileAssertion(caseTestCommand);
    }

    @Deprecated
    public CaseAssertion(CaseAssertion caseAssertion) {
        this(caseAssertion.getTestCommand());
    }

    private static PlanItemCreated getCasePlan(CaseTestCommand caseTestCommand) {
        PublishedEventsAssertion<PlanItemCreated> publishedEventsAssertion = caseTestCommand.getEventListener().getEvents().filter(PlanItemCreated.class);
        EventFilter<PlanItemCreated> eventFilter = planItemCreated -> planItemCreated.getType().equals("CasePlan");
        return publishedEventsAssertion.filter(eventFilter).getEvents().stream().findFirst().orElse(null);
    }

    public void print() {
        TestScript.debugMessage("Result of step " + this.testCommand.getActionNumber() + ": " + this.testCommand.caseInstanceString());
    }

    public String toString() {
        return this.testCommand.caseInstanceString();
    }

    public PublishedEventsAssertion<?> getEvents() {
        return this.getTestCommand().getEvents();
    }

    @Override
    protected Stream<PlanItemCreated> getPlanItems(String string) {
        PublishedEventsAssertion<PlanItemCreated> publishedEventsAssertion = this.testCommand.getEventListener().getEvents().filter(this.caseId).filter(PlanItemCreated.class);
        EventFilter<PlanItemCreated> eventFilter = planItemCreated -> planItemCreated.getPlanItemId().equals(string) || planItemCreated.getPlanItemName().equals(string);
        return publishedEventsAssertion.filter(eventFilter).getEvents().stream();
    }

    public CaseFileAssertion assertCaseFile() {
        return this.caseFileAssertion;
    }

    public CaseFileItemAssertion assertCaseFileItem(Path path) {
        return this.caseFileAssertion.assertCaseFileItem(path);
    }
}

