/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.time.Instant;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.assertions.CaseAssertion;
import org.cafienne.humantask.actorapi.event.HumanTaskAssigned;
import org.cafienne.humantask.actorapi.event.HumanTaskCompleted;
import org.cafienne.humantask.actorapi.event.HumanTaskDueDateFilled;
import org.cafienne.humantask.actorapi.event.HumanTaskOutputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOwnerChanged;
import org.cafienne.humantask.actorapi.event.HumanTaskTransitioned;
import org.cafienne.humantask.actorapi.response.HumanTaskValidationResponse;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.json.ValueMap;

public class HumanTaskAssertion
extends CaseAssertion {
    public HumanTaskAssertion(CaseAssertion caseAssertion) {
        this(caseAssertion.getTestCommand());
    }

    public HumanTaskAssertion(CaseTestCommand caseTestCommand) {
        super(caseTestCommand);
    }

    public HumanTaskValidationResponse getValidationResponse() {
        return (HumanTaskValidationResponse)this.testCommand.getActualResponse();
    }

    public HumanTaskAssertion assertTaskOutput(ValueMap valueMap) {
        this.getEvents().filter(HumanTaskOutputSaved.class).filter(humanTaskOutputSaved -> humanTaskOutputSaved.getTaskOutput().equals(valueMap));
        return this;
    }

    public HumanTaskAssertion assertTaskState(TaskState taskState) {
        this.getEvents().filter(HumanTaskTransitioned.class).filter(humanTaskTransitioned -> humanTaskTransitioned.getCurrentState().equals((Object)taskState));
        return this;
    }

    public HumanTaskAssertion assertAssignee(String string) {
        this.getEvents().filter(HumanTaskAssigned.class).filter(humanTaskAssigned -> humanTaskAssigned.assignee.equals(string));
        return this;
    }

    public HumanTaskAssertion assertOwner(String string) {
        this.getEvents().filter(HumanTaskOwnerChanged.class).filter(humanTaskOwnerChanged -> humanTaskOwnerChanged.owner.equals(string));
        return this;
    }

    public HumanTaskAssertion assertDueDate(Instant instant) {
        this.getEvents().filter(HumanTaskDueDateFilled.class).filter(humanTaskDueDateFilled -> humanTaskDueDateFilled.dueDate.equals(instant));
        return this;
    }

    public HumanTaskAssertion assertTaskCompleted() {
        this.getEvents().filter(HumanTaskCompleted.class).assertNotEmpty();
        return this;
    }
}

