/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.util.Collections;
import java.util.List;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.actorapi.event.plan.RepetitionRuleEvaluated;
import org.cafienne.cmmn.actorapi.event.plan.RequiredRuleEvaluated;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.assertions.ModelTestCommandAssertion;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;

public class PlanItemAssertion
extends ModelTestCommandAssertion {
    protected final String caseId;
    private final String id;
    private final String name;
    private final String type;
    private final String description;
    private final List<PlanItemEvent> events;

    PlanItemAssertion(CaseTestCommand caseTestCommand, PlanItemCreated planItemCreated) {
        super(caseTestCommand);
        this.caseId = caseTestCommand.getCaseInstanceId();
        this.id = planItemCreated.getPlanItemId();
        this.name = planItemCreated.getPlanItemName();
        this.type = planItemCreated.getType();
        this.description = this.type + " '" + this.name + "' with id " + this.id;
        PublishedEventsAssertion<PlanItemEvent> publishedEventsAssertion = caseTestCommand.getEventListener().getEvents().filter(PlanItemEvent.class);
        this.events = publishedEventsAssertion.filter(planItemEvent -> planItemEvent.getPlanItemId().equals(this.id)).getEvents();
        Collections.reverse(this.events);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected <T extends PlanItem<?>> PlanItemAssertion assertType(Class<T> ... classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!this.type.equals(classArray[i].getSimpleName())) continue;
            return this;
        }
        throw new AssertionError((Object)("Plan item " + this.name + " is of type " + this.type + ", but that is not as expected"));
    }

    public <T extends PlanItem<?>> PlanItemAssertion assertType(Class<T> clazz) {
        if (!this.type.equals(clazz.getSimpleName())) {
            throw new AssertionError((Object)("Plan item " + this.name + " is of type " + this.type + ", but is expected to be of type " + clazz.getSimpleName()));
        }
        return this;
    }

    public PlanItemAssertion assertState(State state) {
        if (state == State.Null) {
            if (this.events.size() == 1) {
                return this;
            }
            throw new AssertionError((Object)(this.description + "is not in state Null, but in state " + this.getState()));
        }
        if (this.getState() != state) {
            throw new AssertionError((Object)(this.description + " is not in state " + state + " but in state " + this.getState()));
        }
        return this;
    }

    private PlanItemTransitioned getLastTransition() {
        return this.getLast(PlanItemTransitioned.class);
    }

    public PlanItemAssertion assertLastTransition(Transition transition) {
        return this.assertLastTransition(transition, this.getState(), this.getHistoryState());
    }

    public State getState() {
        return this.getLastTransition().getCurrentState();
    }

    public State getHistoryState() {
        return this.getLastTransition().getHistoryState();
    }

    public Transition getTransition() {
        return this.getLastTransition().getTransition();
    }

    public PlanItemAssertion assertLastTransition(Transition transition, State state, State state2) {
        if (!this.getTransition().equals((Object)transition)) {
            throw new AssertionError((Object)(this.description + " did not make transition " + transition + " but " + this.getTransition()));
        }
        if (!this.getState().equals((Object)state)) {
            throw new AssertionError((Object)(this.description + " is not in state " + state + " but in state " + this.getState()));
        }
        if (!this.getHistoryState().equals((Object)state2)) {
            throw new AssertionError((Object)(this.description + " does not have history state " + state2 + " but " + this.getHistoryState()));
        }
        return this;
    }

    public PlanItemAssertion assertRepeats(boolean bl) {
        boolean bl2 = this.getLast(RepetitionRuleEvaluated.class).isRepeating();
        if (bl2 != bl) {
            if (bl2) {
                throw new AssertionError((Object)(this.description + " is not expected to repeat, but it repeats"));
            }
            throw new AssertionError((Object)(this.description + " is expected to repeat, but it doesn't"));
        }
        return this;
    }

    public PlanItemAssertion assertRepeats() {
        return this.assertRepeats(true);
    }

    public PlanItemAssertion assertNoRepetition() {
        return this.assertRepeats(false);
    }

    public PlanItemAssertion assertRequired(boolean bl) {
        boolean bl2 = this.getLast(RequiredRuleEvaluated.class).isRequired();
        if (bl2 != bl) {
            if (bl2) {
                throw new AssertionError((Object)(this.description + " is not expected to be required, but it is"));
            }
            throw new AssertionError((Object)(this.description + " is expected to be required, but it is not"));
        }
        return this;
    }

    <T extends PlanItemEvent> T getLast(Class<T> clazz) {
        List<T> list = new PublishedEventsAssertion<PlanItemEvent>(this.events).filter(clazz).getEvents();
        if (list.isEmpty()) {
            throw new AssertionError((Object)(this.description + " is not yet in a state (case: " + this.caseId));
        }
        return (T)((PlanItemEvent)list.get(0));
    }
}

