/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.consentgroup.actorapi.ConsentGroup;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.consentgroup.actorapi.command.ConsentGroupCommand;
import org.cafienne.consentgroup.actorapi.exception.ConsentGroupException;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;

abstract class CollectiveCommand
extends ConsentGroupCommand {
    protected final ConsentGroup newGroupInfo;

    protected CollectiveCommand(ConsentGroupUser consentGroupUser, ConsentGroup consentGroup) {
        super(consentGroupUser, consentGroup.id());
        this.newGroupInfo = consentGroup;
        this.validateMemberList();
    }

    protected CollectiveCommand(ValueMap valueMap) {
        super(valueMap);
        this.newGroupInfo = ConsentGroup.deserialize(valueMap.with(Fields.group));
    }

    protected void validateMemberList() {
        if (this.newGroupInfo.members().isEmpty()) {
            throw new ConsentGroupException("Consent group must have members");
        }
        if (((Iterable)this.newGroupInfo.members().filter(ConsentGroupMember::isOwner)).isEmpty()) {
            throw new ConsentGroupException("Consent group must have at least one owner");
        }
        if (((Iterable)this.newGroupInfo.members().map(ConsentGroupMember::userId)).toSet().size() < this.newGroupInfo.members().size()) {
            throw new ConsentGroupException("Consent group cannot have duplicate user ids");
        }
    }

    public Seq<ConsentGroupMember> getMembers() {
        return this.newGroupInfo.members();
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.group, this.newGroupInfo);
    }
}

