/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.command.ConsentGroupCommand;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupResponse;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class RemoveConsentGroupMember
extends ConsentGroupCommand {
    public final String userId;

    public RemoveConsentGroupMember(ConsentGroupUser consentGroupUser, String string) {
        super(consentGroupUser, consentGroupUser.groupId());
        this.userId = string;
    }

    public RemoveConsentGroupMember(ValueMap valueMap) {
        super(valueMap);
        this.userId = valueMap.readString(Fields.userId, new String[0]);
    }

    @Override
    public void validate(ConsentGroupActor consentGroupActor) throws InvalidCommandException {
        super.validate(consentGroupActor);
        this.validateNotLastMember(consentGroupActor, this.userId);
        this.validateNotLastOwner(consentGroupActor, this.userId);
    }

    public ConsentGroupResponse process(ConsentGroupActor consentGroupActor) {
        consentGroupActor.removeMember(this.userId);
        return new ConsentGroupResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.userId, this.userId);
    }
}

