/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupBaseEvent;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.infrastructure.CafienneVersion;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class ConsentGroupCreated
extends ConsentGroupBaseEvent
implements BootstrapMessage {
    public final CafienneVersion engineVersion;
    public final String tenant;

    public ConsentGroupCreated(ConsentGroupActor consentGroupActor, String string) {
        super(consentGroupActor);
        this.engineVersion = Cafienne.version();
        this.tenant = string;
    }

    public ConsentGroupCreated(ValueMap valueMap) {
        super(valueMap);
        this.tenant = valueMap.readString(Fields.tenant, new String[0]);
        this.engineVersion = valueMap.readObject(Fields.engineVersion, CafienneVersion::new);
    }

    @Override
    public void updateState(ConsentGroupActor consentGroupActor) {
        consentGroupActor.updateState(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeConsentGroupEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.tenant, this.tenant);
        this.writeField(jsonGenerator, Fields.engineVersion, this.engineVersion.json());
    }
}

