/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamUser;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.actorapi.command.WorkflowCommand;
import org.cafienne.humantask.actorapi.response.HumanTaskResponse;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.humantask.instance.WorkflowTask;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class AssignTask
extends WorkflowCommand {
    protected final CaseUserIdentity assignee;

    public AssignTask(CaseUserIdentity caseUserIdentity, String string, String string2, CaseUserIdentity caseUserIdentity2) {
        super(caseUserIdentity, string, string2);
        this.assignee = caseUserIdentity2;
    }

    public AssignTask(ValueMap valueMap) {
        super(valueMap);
        this.assignee = this.readUser(valueMap.with(Fields.assignee));
    }

    @Override
    public void validate(HumanTask humanTask) {
        super.validateCaseOwnership(humanTask);
        TaskState taskState = humanTask.getImplementation().getCurrentState();
        if (!taskState.isActive()) {
            this.raiseException("Cannot be done because the task is in " + taskState + " state, but must be in an active state (Unassigned or Assigned)");
        }
        this.validateCaseTeamMembership(humanTask, this.assignee);
    }

    protected void validateCaseTeamMembership(HumanTask humanTask, CaseUserIdentity caseUserIdentity) {
        if (humanTask.getCaseInstance().getCurrentTeamMember().isOwner()) {
            return;
        }
        CaseTeamUser caseTeamUser = humanTask.getCaseInstance().getCaseTeam().getUser(caseUserIdentity.id());
        if (caseTeamUser == null) {
            this.raiseException("There is no case team member with id '" + caseUserIdentity + "'");
        } else {
            CaseRoleDefinition caseRoleDefinition = humanTask.getPerformer();
            if (caseRoleDefinition != null && !caseTeamUser.isOwner() && !caseTeamUser.getCaseRoles().contains(caseRoleDefinition.getName())) {
                this.raiseAuthorizationException("The case team member with id '" + caseUserIdentity + "' does not have the case role " + caseRoleDefinition.getName());
            }
        }
    }

    @Override
    public HumanTaskResponse process(WorkflowTask workflowTask) {
        workflowTask.assign(this.assignee);
        return new HumanTaskResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.assignee, this.assignee);
    }
}

