/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.humantask.instance.WorkflowTask;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class WorkflowCommand
extends CaseCommand {
    private final String taskId;
    private HumanTask task;

    protected WorkflowCommand(CaseUserIdentity caseUserIdentity, String string, String string2) {
        super(caseUserIdentity, string);
        if (string2 == null || string2.trim().isEmpty()) {
            throw new NullPointerException("Task id should not be null or empty");
        }
        this.taskId = string2;
    }

    protected WorkflowCommand(ValueMap valueMap) {
        super(valueMap);
        this.taskId = valueMap.readString(Fields.taskId, new String[0]);
    }

    protected String getTaskId() {
        return this.taskId;
    }

    @Override
    public void validate(Case case_) throws InvalidCommandException {
        super.validate(case_);
        Object t = case_.getPlanItemById(this.taskId);
        if (t == null) {
            throw new InvalidCommandException(this.getClass().getSimpleName() + ": The task with id " + this.taskId + " could not be found in case " + case_.getId());
        }
        if (!(t instanceof HumanTask)) {
            throw new InvalidCommandException(this.getClass().getSimpleName() + ": The plan item with id " + ((PlanItem)t).getId() + " in case " + case_.getId() + " is not a HumanTask");
        }
        this.task = (HumanTask)t;
        State state = this.task.getState();
        if (state.isSemiTerminal() && state != State.Failed || state == State.Null || state == State.Available) {
            throw new InvalidCommandException(this.getClass().getSimpleName() + " cannot be done because task " + ((PlanItem)t).getName() + " (" + this.taskId + ") is in state " + state);
        }
        this.validate(this.task);
    }

    @Override
    public abstract void validate(HumanTask var1) throws InvalidCommandException;

    @Override
    public ModelResponse process(Case case_) {
        return this.process(this.task.getImplementation());
    }

    @Override
    public abstract ModelResponse process(WorkflowTask var1);

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.taskId, this.taskId);
    }

    protected void validateState(HumanTask humanTask, TaskState ... taskStateArray) {
        TaskState taskState = humanTask.getImplementation().getCurrentState();
        for (TaskState taskState2 : taskStateArray) {
            if (!taskState2.equals((Object)taskState)) continue;
            return;
        }
        this.raiseException("Cannot be done because the task is in " + taskState + " state, but should be in any of " + Arrays.asList(taskStateArray) + " state");
    }

    protected void mustBeActive(HumanTask humanTask) {
        this.validateProperCaseRole(humanTask);
        TaskState taskState = humanTask.getImplementation().getCurrentState();
        if (!taskState.isActive()) {
            this.raiseException("Cannot be done because the task is not Active but " + taskState);
        }
    }

    protected void validateCaseOwnership(HumanTask humanTask) {
        if (!humanTask.getCaseInstance().getCurrentTeamMember().isRoleManager(humanTask.getPerformer())) {
            this.raiseAuthorizationException("You must be case owner to perform this operation");
        }
    }

    protected void validateProperCaseRole(HumanTask humanTask) {
        if (!humanTask.currentUserIsAuthorized()) {
            this.raiseAuthorizationException("You do not have permission to perform this operation");
        }
    }

    protected void validateTaskOwnership(HumanTask humanTask) {
        if (humanTask.getCaseInstance().getCurrentTeamMember().isRoleManager(humanTask.getPerformer())) {
            return;
        }
        String string = humanTask.getImplementation().getAssignee();
        if (string == null || string.isEmpty()) {
            this.validateProperCaseRole(humanTask);
        } else {
            String string2 = ((CaseUserIdentity)this.getUser()).id();
            if (!string2.equals(string)) {
                this.raiseAuthorizationException("You do not have permission to perform this operation");
            }
        }
    }

    protected void raiseAuthorizationException(String string) {
        throw new AuthorizationException(this.getClass().getSimpleName() + "[" + this.getTaskId() + "]: " + string);
    }

    protected void raiseException(String string) {
        throw new InvalidCommandException(this.getClass().getSimpleName() + "[" + this.getTaskId() + "]: " + string);
    }
}

