/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.actorapi.event.HumanTaskTransitioned;
import org.cafienne.humantask.instance.TaskAction;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

@Manifest
public class HumanTaskActivated
extends HumanTaskTransitioned {
    private final Instant createdOn;
    private final String createdBy;
    private final String performer;
    private final Value<?> taskModel;

    public HumanTaskActivated(HumanTask humanTask, String string, Value<?> value) {
        super(humanTask, TaskState.Unassigned, TaskState.Null, TaskAction.Create);
        this.createdOn = humanTask.getCaseInstance().getTransactionTimestamp();
        this.createdBy = humanTask.getCaseInstance().getCurrentUser().id();
        this.performer = string;
        this.taskModel = value;
    }

    public HumanTaskActivated(ValueMap valueMap) {
        super(valueMap);
        this.createdOn = valueMap.readInstant(Fields.createdOn);
        this.createdBy = valueMap.readString(Fields.createdBy, new String[0]);
        this.performer = valueMap.readString(Fields.performer, new String[0]);
        this.taskModel = valueMap.get(Fields.taskModel);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeTransitionEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.createdOn, this.createdOn);
        this.writeField(jsonGenerator, Fields.createdBy, this.createdBy);
        this.writeField(jsonGenerator, Fields.performer, this.performer);
        this.writeField(jsonGenerator, Fields.taskModel, this.taskModel);
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getTaskModel() {
        return this.taskModel.toString();
    }

    @Override
    public String toString() {
        return "HumanTask[" + this.getTaskId() + "] is active";
    }
}

