/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.humantask.actorapi.event.HumanTaskEvent;
import org.cafienne.humantask.instance.TaskAction;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.humantask.instance.WorkflowTask;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class HumanTaskTransitioned
extends HumanTaskEvent {
    private final TaskState currentState;
    private final TaskState historyState;
    private final TaskAction transition;

    protected HumanTaskTransitioned(HumanTask humanTask, TaskState taskState, TaskState taskState2, TaskAction taskAction) {
        super(humanTask);
        this.currentState = taskState;
        this.historyState = taskState2;
        this.transition = taskAction;
    }

    protected HumanTaskTransitioned(HumanTask humanTask, TaskState taskState, TaskAction taskAction) {
        this(humanTask, taskState, humanTask.getImplementation().getCurrentState(), taskAction);
    }

    protected HumanTaskTransitioned(ValueMap valueMap) {
        super(valueMap);
        this.currentState = valueMap.readEnum(Fields.currentState, TaskState.class);
        this.historyState = valueMap.readEnum(Fields.historyState, TaskState.class);
        this.transition = valueMap.readEnum(Fields.transition, TaskAction.class);
    }

    public void writeTransitionEvent(JsonGenerator jsonGenerator) throws IOException {
        super.writeHumanTaskEvent(jsonGenerator);
        this.writeField(jsonGenerator, Fields.historyState, this.historyState);
        this.writeField(jsonGenerator, Fields.transition, this.transition);
        this.writeField(jsonGenerator, Fields.currentState, this.currentState);
    }

    @Override
    public String toString() {
        return "Task " + this.getTaskName() + "[" + this.getTaskId() + "]." + this.getTransition() + ", causing transition from " + this.getHistoryState() + " to " + this.getCurrentState();
    }

    @Override
    public void updateState(WorkflowTask workflowTask) {
        workflowTask.updateState(this);
    }

    public TaskState getCurrentState() {
        return this.currentState;
    }

    public TaskState getHistoryState() {
        return this.historyState;
    }

    public TaskAction getTransition() {
        return this.transition;
    }
}

