/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.akkahttp.authentication;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.actormodel.response.ActorLastModified;
import org.cafienne.cmmn.repository.file.SimpleLRUCache;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.akkahttp.authentication.IdentityProvider;
import org.cafienne.querydb.materializer.tenant.TenantReader$;
import org.cafienne.querydb.query.TenantQueriesImpl;
import org.cafienne.querydb.query.UserQueries;
import org.cafienne.querydb.record.TenantRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\b\u0011\u0001mA\u0001\u0002\r\u0001\u0003\u0006\u0004%\u0019!\r\u0005\tq\u0001\u0011\t\u0011)A\u0005e!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002%\u0001A\u0003%\u0001\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r!\u0004\u0001\u0015!\u0003L\u0011\u001dI\u0007A1A\u0005\n)DaA\u001d\u0001!\u0002\u0013Y\u0007\"B:\u0001\t\u0003\"\bbBA\u0003\u0001\u0011%\u0011q\u0001\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\u0007\u0001\t\u0003\niBA\u0007JI\u0016tG/\u001b;z\u0007\u0006\u001c\u0007.\u001a\u0006\u0003#I\ta\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002\u0014)\u0005A\u0011m[6bQR$\bO\u0003\u0002\u0016-\u0005q\u0011N\u001c4sCN$(/^2ukJ,'BA\f\u0019\u0003!\u0019\u0017MZ5f]:,'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001a\"E\n\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r\"S\"\u0001\t\n\u0005\u0015\u0002\"\u0001E%eK:$\u0018\u000e^=Qe>4\u0018\u000eZ3s!\t9c&D\u0001)\u0015\tI#&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002,Y\u0005AA/\u001f9fg\u00064WMC\u0001.\u0003\r\u0019w.\\\u0005\u0003_!\u00121\u0002T1{s2{wmZ5oO\u0006\u0011QmY\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011QGH\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u001c5\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\na\u0001P5oSRtD#A\u001e\u0015\u0005qj\u0004CA\u0012\u0001\u0011\u0015\u00014\u0001q\u00013\u0003-)8/\u001a:Rk\u0016\u0014\u0018.Z:\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u000bE,XM]=\u000b\u0005\u00153\u0012aB9vKJLHMY\u0005\u0003\u000f\n\u00131\"V:feF+XM]5fg\u0006aQo]3s#V,'/[3tA\u0005)1-Y2iKV\t1\n\u0005\u0003M'V\u0003W\"A'\u000b\u00059{\u0015\u0001\u00024jY\u0016T!\u0001U)\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002S-\u0005!1-\\7o\u0013\t!VJ\u0001\bTS6\u0004H.\u001a'S+\u000e\u000b7\r[3\u0011\u0005YkfBA,\\!\tAf$D\u0001Z\u0015\tQ&$\u0001\u0004=e>|GOP\u0005\u00039z\ta\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011AL\b\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f\u0001\"\u001b3f]RLG/\u001f\u0006\u0003KZ\t!\"Y2u_Jlw\u000eZ3m\u0013\t9'M\u0001\u0007QY\u0006$hm\u001c:n+N,'/\u0001\u0004dC\u000eDW\rI\u0001\fi\u0016t\u0017M\u001c;DC\u000eDW-F\u0001l!\u0011a5+\u00167\u0011\u00055\u0004X\"\u00018\u000b\u0005=$\u0015A\u0002:fG>\u0014H-\u0003\u0002r]\naA+\u001a8b]R\u0014VmY8sI\u0006aA/\u001a8b]R\u001c\u0015m\u00195fA\u0005yq-\u001a;QY\u0006$hm\u001c:n+N,'\u000fF\u0002vqv\u00042a\r<a\u0013\t9HG\u0001\u0004GkR,(/\u001a\u0005\u0006s*\u0001\rA_\u0001\u0005kN,'\u000f\u0005\u0002bw&\u0011AP\u0019\u0002\r+N,'/\u00133f]RLG/\u001f\u0005\u0006}*\u0001\ra`\u0001\u0004i2l\u0007\u0003B\u000f\u0002\u0002UK1!a\u0001\u001f\u0005\u0019y\u0005\u000f^5p]\u0006I1-Y2iKV\u001bXM\u001d\u000b\u0004A\u0006%\u0001\"B=\f\u0001\u0004\u0001\u0017\u0001E3yK\u000e,H/Z+tKJ\fV/\u001a:z)\r)\u0018q\u0002\u0005\u0006s2\u0001\rA_\u0001\nO\u0016$H+\u001a8b]R$B!!\u0006\u0002\u0018A\u00191G\u001e7\t\r\u0005eQ\u00021\u0001V\u0003!!XM\\1oi&#\u0017!B2mK\u0006\u0014H\u0003BA\u0010\u0003K\u00012!HA\u0011\u0013\r\t\u0019C\b\u0002\u0005+:LG\u000f\u0003\u0004\u0002(9\u0001\r!V\u0001\u0007kN,'/\u00133")
public class IdentityCache
implements IdentityProvider,
LazyLogging {
    private final ExecutionContext ec;
    private final UserQueries userQueries;
    private final SimpleLRUCache<String, PlatformUser> cache;
    private final SimpleLRUCache<String, TenantRecord> tenantCache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        IdentityCache identityCache = this;
        synchronized (identityCache) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public UserQueries userQueries() {
        return this.userQueries;
    }

    private SimpleLRUCache<String, PlatformUser> cache() {
        return this.cache;
    }

    private SimpleLRUCache<String, TenantRecord> tenantCache() {
        return this.tenantCache;
    }

    @Override
    public Future<PlatformUser> getPlatformUser(UserIdentity user, Option<String> tlm) {
        Future future;
        Option<String> option = tlm;
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            future = TenantReader$.MODULE$.lastModifiedRegistration().waitFor(new ActorLastModified(s)).future().flatMap((Function1 & Serializable)p -> this.executeUserQuery(user).map((Function1 & Serializable)u -> (PlatformUser)new Tuple2(p, u)._2(), this.ec()), this.ec());
        } else if (None$.MODULE$.equals(option)) {
            future = this.executeUserQuery(user);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private PlatformUser cacheUser(PlatformUser user) {
        this.cache().put(user.id(), user);
        return user;
    }

    private Future<PlatformUser> executeUserQuery(UserIdentity user2) {
        Future future;
        PlatformUser platformUser = (PlatformUser)this.cache().get(user2.id());
        if (platformUser != null) {
            PlatformUser platformUser2 = platformUser;
            future = Future$.MODULE$.apply((Function0 & Serializable)() -> platformUser2, this.ec());
        } else if (platformUser == null) {
            future = this.userQueries().getPlatformUser(user2.id()).map((Function1 & Serializable)user -> this.cacheUser((PlatformUser)user), this.ec());
        } else {
            throw new MatchError((Object)platformUser);
        }
        return future;
    }

    @Override
    public Future<TenantRecord> getTenant(String tenantId) {
        Future future;
        TenantRecord tenantRecord = (TenantRecord)this.tenantCache().get(tenantId);
        if (tenantRecord != null) {
            TenantRecord tenantRecord2 = tenantRecord;
            future = Future$.MODULE$.apply((Function0 & Serializable)() -> tenantRecord2, this.ec());
        } else if (tenantRecord == null) {
            future = this.userQueries().getTenant(tenantId).map((Function1 & Serializable)tenant -> {
                this.tenantCache().put(tenantId, (TenantRecord)tenant);
                return tenant;
            }, this.ec());
        } else {
            throw new MatchError((Object)tenantRecord);
        }
        return future;
    }

    @Override
    public void clear(String userId) {
        this.cache().remove(userId);
    }

    public IdentityCache(ExecutionContext ec) {
        this.ec = ec;
        IdentityProvider.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.userQueries = new TenantQueriesImpl();
        this.cache = new SimpleLRUCache(Cafienne$.MODULE$.config().api().security().identityCacheSize());
        this.tenantCache = new SimpleLRUCache(Cafienne$.MODULE$.config().api().security().identityCacheSize());
    }
}

