/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.akkahttp.route;

import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.util.ApplyConverter$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.EngineChokedFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.actormodel.response.SecurityFailure;
import org.cafienne.cmmn.actorapi.response.CaseNotModifiedResponse;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupCreatedResponse;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupResponse;
import org.cafienne.humantask.actorapi.response.HumanTaskResponse;
import org.cafienne.infrastructure.akkahttp.ResponseMarshallers$;
import org.cafienne.system.CaseSystem;
import org.cafienne.tenant.actorapi.response.TenantOwnersResponse;
import org.cafienne.tenant.actorapi.response.TenantResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class CommandRouteExecutor$
implements LazyLogging {
    public static final CommandRouteExecutor$ MODULE$ = new CommandRouteExecutor$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        CommandRouteExecutor$ commandRouteExecutor$ = this;
        synchronized (commandRouteExecutor$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public Function1<RequestContext, Future<RouteResult>> askModelActor(CaseSystem caseSystem, ModelCommand command) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.onComplete((Function0 & Serializable)() -> caseSystem.gateway().request(command)), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x0$1 -> {
            StandardRoute standardRoute;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                StandardRoute standardRoute2;
                Success success = (Success)try_;
                Object value = success.value();
                Object object = value;
                if (object instanceof SecurityFailure) {
                    SecurityFailure securityFailure = (SecurityFailure)object;
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.Unauthorized(), (Function0 & Serializable)() -> securityFailure.exception().getMessage(), Marshaller$.MODULE$.StringMarshaller());
                } else if (object instanceof EngineChokedFailure) {
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> "An error happened in the server; check the server logs for more information", Marshaller$.MODULE$.StringMarshaller());
                } else if (object instanceof CommandFailure) {
                    CommandFailure commandFailure = (CommandFailure)object;
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.BadRequest(), (Function0 & Serializable)() -> commandFailure.exception().getMessage(), Marshaller$.MODULE$.StringMarshaller());
                } else if (object instanceof HumanTaskResponse) {
                    HumanTaskResponse humanTaskResponse = (HumanTaskResponse)object;
                    standardRoute2 = MODULE$.completeWithLMH(StatusCodes$.MODULE$.Accepted(), humanTaskResponse, MODULE$.completeWithLMH$default$3());
                } else if (object instanceof CaseNotModifiedResponse) {
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.NotModified(), (Function0 & Serializable)() -> "Transition has no effect", Marshaller$.MODULE$.StringMarshaller());
                } else if (object instanceof CaseResponse) {
                    CaseResponse caseResponse = (CaseResponse)object;
                    standardRoute2 = MODULE$.completeWithLMH(StatusCodes$.MODULE$.OK(), caseResponse, MODULE$.completeWithLMH$default$3());
                } else if (object instanceof TenantOwnersResponse) {
                    TenantOwnersResponse tenantOwnersResponse = (TenantOwnersResponse)object;
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.OK(), (Function0 & Serializable)() -> tenantOwnersResponse, ResponseMarshallers$.MODULE$.modelResponseMarshaller());
                } else if (object instanceof TenantResponse) {
                    TenantResponse tenantResponse = (TenantResponse)object;
                    standardRoute2 = MODULE$.completeOnlyLMH(StatusCodes$.MODULE$.NoContent(), tenantResponse, "Tenant-Last-Modified");
                } else if (object instanceof ConsentGroupCreatedResponse) {
                    ConsentGroupCreatedResponse consentGroupCreatedResponse = (ConsentGroupCreatedResponse)object;
                    standardRoute2 = MODULE$.completeWithLMH(StatusCodes$.MODULE$.OK(), consentGroupCreatedResponse, "Consent-Group-Last-Modified");
                } else if (object instanceof ConsentGroupResponse) {
                    ConsentGroupResponse consentGroupResponse = (ConsentGroupResponse)object;
                    standardRoute2 = MODULE$.completeOnlyLMH(StatusCodes$.MODULE$.Accepted(), consentGroupResponse, "Consent-Group-Last-Modified");
                } else {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Received an unexpected response after asking CaseSystem a command of type {}. Response is of type {}", new Object[]{command.getCommandDescription(), object.getClass().getSimpleName()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.OK(), Marshaller$.MODULE$.fromStatusCode()));
                }
                standardRoute = standardRoute2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> e.getMessage(), Marshaller$.MODULE$.StringMarshaller());
            } else {
                throw new MatchError((Object)try_);
            }
            return standardRoute;
        });
    }

    private <R extends ModelResponse> Function1<RequestContext, Future<RouteResult>> completeWithLMH(StatusCodes.Success statusCode, R response, String header) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(this.writeLastModifiedHeader(response, header)).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((StatusCode)statusCode, (Function0 & Serializable)() -> response, ResponseMarshallers$.MODULE$.modelResponseMarshaller()));
    }

    private <R extends ModelResponse> String completeWithLMH$default$3() {
        return "Case-Last-Modified";
    }

    private <R extends ModelResponse> Function1<RequestContext, Future<RouteResult>> completeOnlyLMH(StatusCodes.Success statusCode, R response, String header) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(this.writeLastModifiedHeader(response, header)).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)statusCode, Marshaller$.MODULE$.fromStatusCode())));
    }

    public Directive<BoxedUnit> writeLastModifiedHeader(ModelResponse response, String headerName) {
        String lm = response.lastModifiedContent().toString();
        return lm != null ? Directives$.MODULE$.respondWithHeader((HttpHeader)new RawHeader(headerName, response.lastModifiedContent().toString())) : Directives$.MODULE$.respondWithHeaders((Seq)Nil$.MODULE$);
    }

    public String writeLastModifiedHeader$default$2() {
        return "Case-Last-Modified";
    }

    private CommandRouteExecutor$() {
    }
}

