/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.config.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SystemConfig$
implements LazyLogging {
    public static final SystemConfig$ MODULE$ = new SystemConfig$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        SystemConfig$ systemConfig$ = this;
        synchronized (systemConfig$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    /*
     * WARNING - void declaration
     */
    public Config load() {
        void var3_3;
        Config fallback = ConfigFactory.defaultReference();
        Config currentConfig = ConfigFactory.load().withFallback((ConfigMergeable)fallback);
        Config newConfig = this.migrateEventDatabaseProvider(this.dropTagging(this.migrateSerializer(currentConfig)));
        return var3_3;
    }

    public Config migrateSerializer(Config config) {
        String serializerPath = "akka.actor.serializers";
        String key = "cafienne_serializer";
        String deprecatedValue = "org.cafienne.akka.actor.serialization.CafienneSerializer";
        String newValue = "org.cafienne.infrastructure.serialization.CafienneSerializer";
        Config newConfig = this.migrateConfigurationValue(config, serializerPath, key, deprecatedValue, newValue, this.migrateConfigurationValue$default$6());
        String bindingPath = "akka.actor.serialization-bindings";
        String oldKey = "org.cafienne.akka.actor.serialization.CafienneSerializable";
        String newKey = "org.cafienne.infrastructure.serialization.CafienneSerializable";
        return this.migrateConfigurationProperty(newConfig, bindingPath, oldKey, newKey);
    }

    public Config dropTagging(Config config) {
        String akkaJournalPath = config.root().toConfig().getString("akka.persistence.journal.plugin");
        String taggingPath = akkaJournalPath + ".event-adapters";
        String key = "tagging";
        String deprecatedValue = "org.cafienne.akka.actor.tagging.CaseTaggingEventAdapter";
        String newValue = "org.cafienne.actormodel.tagging.CaseTaggingEventAdapter";
        Config newConfig = this.dropConfigurationValue(config, taggingPath, key, deprecatedValue, newValue);
        String bindingPath = akkaJournalPath + ".event-adapter-bindings";
        String newKey = "org.cafienne.actormodel.event.ModelEvent";
        return this.dropConfigurationProperty(newConfig, bindingPath, newKey);
    }

    public Config migrateEventDatabaseProvider(Config config) {
        String deprecatedValue = "org.cafienne.service.db.events.EventDatabaseProvider";
        String newValue = "org.cafienne.journal.jdbc.EventDatabaseProvider";
        return this.migrateConfigurationValue(config, "akka-persistence-jdbc", "database-provider-fqcn", deprecatedValue, newValue, false);
    }

    public void printWarning(String msg) {
        BoxedUnit boxedUnit;
        String extendedMessage = "\tWARNING - " + msg + "\t";
        int longestLine = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])extendedMessage.split("\n")), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.length()), (ClassTag)ClassTag$.MODULE$.Int())).max((Ordering)Ordering.Int$.MODULE$)) + 8;
        String manyHashes = package$.MODULE$.List().fill(longestLine, (Function0)(JFunction0.mcC.sp & Serializable)() -> '#').mkString();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("\n\n{}\n\n{}\n\n{}\n\n", new Object[]{manyHashes, extendedMessage, manyHashes});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private String getLocationDescription(ConfigValue value) {
        ConfigOrigin origin = value.origin();
        return origin.url() + ", line " + origin.lineNumber();
    }

    public String quoted(String path, String key) {
        return path + "." + key;
    }

    public String quotedKeyPath(String path, String key) {
        return this.quoted(path, "\"" + key + "\"");
    }

    public Config migrateConfigurationValue(Config config, String path, String key, Object oldValue, Object newValue, boolean showWarningOnDifferentValue) {
        block3: {
            String keyPath = this.quoted(path, key);
            if (!config.hasPath(keyPath)) break block3;
            ConfigValue configValue = config.getValue(keyPath);
            String location = this.getLocationDescription(configValue);
            Object value = configValue.unwrapped();
            if (!BoxesRunTime.equals((Object)value, (Object)newValue)) {
                if (BoxesRunTime.equals((Object)value, (Object)oldValue)) {
                    this.printWarning(location + "\n\tPlease change deprecated configuration property '" + keyPath + "' to\n\n\t\t" + key + " = \"" + newValue + "\" ");
                    return config.withValue(keyPath, ConfigValueFactory.fromAnyRef((Object)newValue));
                }
                if (showWarningOnDifferentValue) {
                    this.printWarning(location + "\n\tConfiguration property '" + keyPath + "' may have the wrong value; consider changing it to \n\n\t\t" + key + " = \"" + newValue + "\" ");
                }
            }
        }
        return config;
    }

    public boolean migrateConfigurationValue$default$6() {
        return true;
    }

    public Config dropConfigurationValue(Config config, String path, String key, Object oldValue, Object newValue) {
        block1: {
            String keyPath = this.quoted(path, key);
            if (!config.hasPath(keyPath)) break block1;
            ConfigValue configValue = config.getValue(keyPath);
            String location = this.getLocationDescription(configValue);
            Object value = configValue.unwrapped();
            if (BoxesRunTime.equals((Object)value, (Object)oldValue) || BoxesRunTime.equals((Object)value, (Object)newValue)) {
                this.printWarning(location + "\n\tFound deprecated configuration property, please drop the line.\n\n\t\t" + key + " = " + value);
            }
        }
        return config;
    }

    public Config migrateConfigurationProperty(Config config, String path, String oldKey, String newKey) {
        block1: {
            String oldPath = this.quotedKeyPath(path, oldKey);
            String newPath = this.quotedKeyPath(path, newKey);
            if (config.hasPath(newPath)) break block1;
            if (config.hasPath(oldPath)) {
                String location = this.getLocationDescription(config.getValue(oldPath));
                Object value = config.getAnyRef(oldPath);
                this.printWarning(location + "\n\tPlease change deprecated configuration property '" + oldKey + "' to\n\n\t\t" + newKey + " = " + value);
                return config.withoutPath(oldPath).withValue(newPath, ConfigValueFactory.fromAnyRef((Object)value));
            }
            this.printWarning("Configuration property '" + path + "' might be missing ");
        }
        return config;
    }

    public Config dropConfigurationProperty(Config config, String path, String key) {
        block0: {
            String propertyPath = this.quotedKeyPath(path, key);
            if (!config.hasPath(propertyPath)) break block0;
            ConfigValue value = config.getValue(propertyPath);
            String location = this.getLocationDescription(value);
            this.printWarning(location + "\n\tFound deprecated configuration property, please drop the line.\n\n\t\t" + key + " = " + value.unwrapped());
        }
        return config;
    }

    private SystemConfig$() {
    }
}

