/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.cqrs;

import akka.actor.ActorSystem;
import akka.persistence.query.PersistenceQuery;
import akka.persistence.query.PersistenceQuery$;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import com.typesafe.scalalogging.LazyLogging;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.system.CaseSystem;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u001d4q\u0001C\u0005\u0011\u0002\u0007\u0005!\u0003C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\r\u0011\u0006C\u00033\u0001\u0019\u00051\u0007\u0003\u0005:\u0001!\u0015\r\u0011\"\u0001;\u0011!1\u0005\u0001#b\u0001\n\u0003Q\u0004\"B$\u0001\t\u0003A\u0005\"B3\u0001\t\u00131'a\u0005*fC\u0012Tu.\u001e:oC2\u0004&o\u001c<jI\u0016\u0014(B\u0001\u0006\f\u0003\u0011\u0019\u0017O]:\u000b\u00051i\u0011AD5oMJ\f7\u000f\u001e:vGR,(/\u001a\u0006\u0003\u001d=\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ\u0012%D\u0001\u001c\u0015\taR$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001f?\u0005AA/\u001f9fg\u00064WMC\u0001!\u0003\r\u0019w.\\\u0005\u0003Em\u00111\u0002T1{s2{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012!\n\t\u0003)\u0019J!aJ\u000b\u0003\tUs\u0017\u000e^\u0001\u0007gf\u001cH/Z7\u0016\u0003)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003=\nA!Y6lC&\u0011\u0011\u0007\f\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0006dCN,7+_:uK6,\u0012\u0001\u000e\t\u0003k]j\u0011A\u000e\u0006\u0003Q5I!\u0001\u000f\u001c\u0003\u0015\r\u000b7/Z*zgR,W.A\td_:4\u0017nZ;sK\u0012Tu.\u001e:oC2,\u0012a\u000f\t\u0003y\rs!!P!\u0011\u0005y*R\"A \u000b\u0005\u0001\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002C+\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011U#\u0001\nsK\u0006$'j\\;s]\u0006d7+\u001a;uS:<\u0017a\u00026pkJt\u0017\r\u001c\u000b\u0002\u0013J9!\n\u0014,Z9~\u0013g\u0001B&\u0001\u0001%\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"!\u0014+\u000e\u00039S!a\u0014)\u0002\u0011M\u001c\u0017\r\\1eg2T!!\u0015*\u0002\u000bE,XM]=\u000b\u0005Ms\u0013a\u00039feNL7\u000f^3oG\u0016L!!\u0016(\u0003\u0017I+\u0017\r\u001a&pkJt\u0017\r\u001c\t\u0003\u001b^K!\u0001\u0017(\u00035\r+(O]3oiB+'o]5ti\u0016t7-Z%egF+XM]=\u0011\u00055S\u0016BA.O\u0005A)e/\u001a8ug\nKH+Y4Rk\u0016\u0014\u0018\u0010\u0005\u0002N;&\u0011aL\u0014\u0002\u0018\u0007V\u0014(/\u001a8u\u000bZ,g\u000e^:CsR\u000bw-U;fef\u0004\"!\u00141\n\u0005\u0005t%AG#wK:$8OQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ)vKJL\bCA'd\u0013\t!gJA\u0011DkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z!\u0016\u00148/[:uK:\u001cW-\u00133Rk\u0016\u0014\u00180\u0001\fgS:$'+Z1e\u0015>,(O\\1m'\u0016$H/\u001b8h)\u0005Y\u0004")
public interface ReadJournalProvider
extends LazyLogging {
    public static /* synthetic */ ActorSystem system$(ReadJournalProvider $this) {
        return $this.system();
    }

    default public ActorSystem system() {
        return this.caseSystem().system();
    }

    public CaseSystem caseSystem();

    public static /* synthetic */ String configuredJournal$(ReadJournalProvider $this) {
        return $this.configuredJournal();
    }

    default public String configuredJournal() {
        return this.system().settings().config().getString("akka.persistence.journal.plugin");
    }

    public static /* synthetic */ String readJournalSetting$(ReadJournalProvider $this) {
        return $this.readJournalSetting();
    }

    default public String readJournalSetting() {
        return this.findReadJournalSetting();
    }

    public static /* synthetic */ CurrentPersistenceIdsQuery journal$(ReadJournalProvider $this) {
        return $this.journal();
    }

    default public CurrentPersistenceIdsQuery journal() {
        return (CurrentPersistenceIdsQuery)((PersistenceQuery)PersistenceQuery$.MODULE$.apply(this.system())).readJournalFor(this.readJournalSetting());
    }

    private String findReadJournalSetting() {
        BoxedUnit boxedUnit;
        String explicitReadJournal = Cafienne$.MODULE$.config().readJournal();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(explicitReadJournal))) {
            return explicitReadJournal;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Missing conf 'cafienne.read-journal'. Trying to determine read journal settings by guessing based on the name of the journal plugin \"" + this.configuredJournal() + "\"");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.configuredJournal().contains("jdbc")) {
            return "jdbc-read-journal";
        }
        if (this.configuredJournal().contains("cassandra")) {
            return "cassandra-query-journal";
        }
        if (this.configuredJournal().contains("level")) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Found Level DB based configurations. This has proven to be unreliable. Do not use it in Production systems.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return "akka.persistence.query.journal.leveldb";
        }
        if (this.configuredJournal().contains("memory")) {
            return "inmemory-read-journal";
        }
        throw new RuntimeException("Cannot find read journal for " + this.configuredJournal() + ", please use Cassandra or JDBC read journal settings");
    }

    public static void $init$(ReadJournalProvider $this) {
    }
}

