/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.cqrs;

import akka.Done;
import akka.NotUsed;
import akka.actor.ClassicActorSystemProvider;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.EventEnvelope$;
import akka.persistence.query.Offset;
import akka.persistence.query.scaladsl.EventsByTagQuery;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.RestartSource$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import java.io.Serializable;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope$;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.infrastructure.serialization.DeserializationFailure;
import org.cafienne.infrastructure.serialization.UnrecognizedManifest;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005I4q!\u0003\u0006\u0011\u0002\u0007\u00051\u0003C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003.\u0001\u0019\u0005a\u0006C\u0004@\u0001\t\u0007i\u0011\u0001!\t\u000b1\u0003a\u0011A'\t\u000ba\u0003A\u0011A\u0015\t\u000be\u0003A\u0011\u0001.\t\u000bm\u0003A\u0011\u0002/\t\u000b!\u0004A\u0011B5\u0003'Q\u000bwmZ3e\u000bZ,g\u000e^\"p]N,X.\u001a:\u000b\u0005-a\u0011\u0001B2reNT!!\u0004\b\u0002\u001d%tgM]1tiJ,8\r^;sK*\u0011q\u0002E\u0001\tG\u00064\u0017.\u001a8oK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001)i!\u0003CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005a1oY1mC2|wmZ5oO*\u0011q\u0004I\u0001\tif\u0004Xm]1gK*\t\u0011%A\u0002d_6L!a\t\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\t\u0003K\u0019j\u0011AC\u0005\u0003O)\u00111CU3bI*{WO\u001d8bYB\u0013xN^5eKJ\fa\u0001J5oSR$C#\u0001\u0016\u0011\u0005UY\u0013B\u0001\u0017\u0017\u0005\u0011)f.\u001b;\u0002\u0013\u001d,Go\u00144gg\u0016$H#A\u0018\u0011\u0007A\u001aT'D\u00012\u0015\t\u0011d#\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001N\u0019\u0003\r\u0019+H/\u001e:f!\t1T(D\u00018\u0015\tA\u0014(A\u0003rk\u0016\u0014\u0018P\u0003\u0002;w\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\u0005a\u0014\u0001B1lW\u0006L!AP\u001c\u0003\r=3gm]3u\u0003\r!\u0018mZ\u000b\u0002\u0003B\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001\u0012\f\u000e\u0003\u0015S!A\u0012\n\u0002\rq\u0012xn\u001c;?\u0013\tAe#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u0017\u0003E\u0019wN\\:v[\u0016lu\u000eZ3m\u000bZ,g\u000e\u001e\u000b\u0003\u001dN\u00032\u0001M\u001aP!\t\u0001\u0016+D\u0001<\u0013\t\u00116H\u0001\u0003E_:,\u0007\"\u0002+\u0005\u0001\u0004)\u0016\u0001C3om\u0016dw\u000e]3\u0011\u0005\u00152\u0016BA,\u000b\u0005Iiu\u000eZ3m\u000bZ,g\u000e^#om\u0016dw\u000e]3\u0002\u000bM$\u0018M\u001d;\u0002\u0013I,hn\u0015;sK\u0006lG#\u0001(\u0002_I,7\u000f^1si\u0006\u0014G.\u001a+bO\u001e,G-\u0012<f]R\u001cv.\u001e:dK\u001a\u0013x.\u001c'bgR\\en\\<o\u001f\u001a47/\u001a;\u0016\u0003u\u0003BAX2VK6\tqL\u0003\u0002aC\u0006A1oY1mC\u0012\u001cHN\u0003\u0002cw\u000511\u000f\u001e:fC6L!\u0001Z0\u0003\rM{WO]2f!\t\u0001f-\u0003\u0002hw\t9aj\u001c;Vg\u0016$\u0017\u0001E7pI\u0016dWI^3oi\u001aKG\u000e^3s)\tQW\u000e\u0005\u0002\u0016W&\u0011AN\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015q\u0007\u00021\u0001p\u0003\u001d)G.Z7f]R\u0004\"A\u000e9\n\u0005E<$!D#wK:$XI\u001c<fY>\u0004X\r")
public interface TaggedEventConsumer
extends ReadJournalProvider {
    public Future<Offset> getOffset();

    public String tag();

    public Future<Done> consumeModelEvent(ModelEventEnvelope var1);

    public static /* synthetic */ void start$(TaggedEventConsumer $this) {
        $this.start();
    }

    default public void start() {
        this.runStream().onComplete((Function1 & Serializable)x0$1 -> {
            TaggedEventConsumer.$anonfun$start$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public static /* synthetic */ Future runStream$(TaggedEventConsumer $this) {
        return $this.runStream();
    }

    default public Future<Done> runStream() {
        return (Future)((Source)this.restartableTaggedEventSourceFromLastKnownOffset().mapAsync(1, (Function1 & Serializable)envelope -> this.consumeModelEvent((ModelEventEnvelope)envelope))).runWith((Graph)Sink$.MODULE$.ignore(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()));
    }

    private Source<ModelEventEnvelope, NotUsed> restartableTaggedEventSourceFromLastKnownOffset() {
        return RestartSource$.MODULE$.withBackoff(Cafienne$.MODULE$.config().queryDB().restartSettings(), (Function0 & Serializable)() -> Source$.MODULE$.futureSource(this.getOffset().map((Function1 & Serializable)offset -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Starting to read '" + this.tag() + "' events from offset " + offset);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (Source)((EventsByTagQuery)this.journal()).eventsByTag(this.tag(), offset).filter((Function1 & Serializable)element -> BoxesRunTime.boxToBoolean((boolean)this.modelEventFilter(element))).map((Function1)ModelEventEnvelope$.MODULE$);
        }, ExecutionContext.Implicits$.MODULE$.global())));
    }

    private boolean modelEventFilter(EventEnvelope element) {
        boolean bl;
        Option option;
        HealthMonitor$.MODULE$.readJournal().isOK();
        EventEnvelope eventEnvelope = element;
        if (eventEnvelope != null && !(option = EventEnvelope$.MODULE$.unapply(eventEnvelope)).isEmpty() && ((Tuple4)option.get())._4() instanceof ModelEvent) {
            bl = true;
        } else {
            Offset offset = element.offset();
            String persistenceId = element.persistenceId();
            long sequenceNr = element.sequenceNr();
            String eventDescriptor = "Encountered unexpected event with offset=" + offset + ", persistenceId=" + persistenceId + ", sequenceNumber=" + sequenceNr;
            Object object = element.event();
            if (object instanceof DeserializationFailure) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                DeserializationFailure deserializationFailure = (DeserializationFailure)object;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring event of type '" + deserializationFailure.manifest + ("' with invalid contents. It could not be deserialized. " + eventDescriptor), (Throwable)deserializationFailure.exception);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Event blob: " + new String(deserializationFailure.blob));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else if (object instanceof UnrecognizedManifest) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit4;
                UnrecognizedManifest unrecognizedManifest = (UnrecognizedManifest)object;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring unrecognized event of type '" + unrecognizedManifest.manifest + ("'. Event type is probably deprecated. " + eventDescriptor));
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Event contents: " + new String(unrecognizedManifest.blob));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Ignoring unknown event of type '" + object.getClass().getName() + ("'. Event type is perhaps created through some other product. " + eventDescriptor));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit6 = boxedUnit;
            }
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void $anonfun$start$1(TaggedEventConsumer $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error($this.getClass().getSimpleName() + " bumped into an issue that it cannot recover from. Stopping case engine.", ex);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HealthMonitor$.MODULE$.readJournal().hasFailed(ex);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static void $init$(TaggedEventConsumer $this) {
    }
}

