/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.infrastructure.serialization.CafienneSerializer;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CafienneSerializable {
    public static final Logger logger = LoggerFactory.getLogger(CafienneSerializer.class);

    default public byte[] toBytes() {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)byteArrayOutputStream);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.writeThisObject(jsonGenerator);
            jsonGenerator.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failure in serialization of an object with type " + this.getClass().getName() + "\n" + iOException.getMessage(), iOException);
        }
        catch (Throwable throwable) {
            logger.error("Failed to serialize an object of type " + this.getClass().getName(), throwable);
            throw throwable;
        }
        return byteArrayOutputStream.toByteArray();
    }

    default public String asString() {
        return new String(this.toBytes());
    }

    default public void writeThisObject(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        this.write(jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    public void write(JsonGenerator var1) throws IOException;

    default public void writeListField(JsonGenerator jsonGenerator, Fields fields, Collection<? extends CafienneJson> collection) throws IOException {
        jsonGenerator.writeArrayFieldStart(fields.toString());
        for (CafienneJson cafienneJson : collection) {
            if (cafienneJson == null) {
                jsonGenerator.writeNull();
                continue;
            }
            cafienneJson.toValue().print(jsonGenerator);
        }
        jsonGenerator.writeEndArray();
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, Collection<String> collection) throws IOException {
        jsonGenerator.writeArrayFieldStart(fields.toString());
        for (String string : collection) {
            if (string == null) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeEndArray();
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, boolean bl) throws IOException {
        jsonGenerator.writeBooleanField(fields.toString(), bl);
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, CMMNElementDefinition cMMNElementDefinition) throws IOException {
        if (cMMNElementDefinition == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeFieldName(fields.toString());
            cMMNElementDefinition.toJSON().print(jsonGenerator);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, Value<?> value) throws IOException {
        if (value == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeFieldName(fields.toString());
            value.print(jsonGenerator);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, String string) throws IOException {
        if (string == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeStringField(fields.toString(), string);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, Path path) throws IOException {
        if (path == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeStringField(fields.toString(), String.valueOf(path));
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, Instant instant) throws IOException {
        if (instant == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeStringField(fields.toString(), String.valueOf(instant));
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, Enum enum_) throws IOException {
        if (enum_ == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeStringField(fields.toString(), String.valueOf(enum_));
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, CafienneJson cafienneJson) throws IOException {
        if (cafienneJson == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeFieldName(fields.toString());
            cafienneJson.write(jsonGenerator);
        }
    }

    default public void writeField(JsonGenerator jsonGenerator, Fields fields, CafienneSerializable cafienneSerializable) throws IOException {
        if (cafienneSerializable == null) {
            jsonGenerator.writeNullField(fields.toString());
        } else {
            jsonGenerator.writeFieldName(fields.toString());
            cafienneSerializable.writeThisObject(jsonGenerator);
        }
    }
}

