/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.serialization;

import akka.actor.ExtendedActorSystem;
import akka.serialization.SerializerWithStringManifest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.cafienne.infrastructure.serialization.CafienneSerializable;
import org.cafienne.infrastructure.serialization.CommandSerializer;
import org.cafienne.infrastructure.serialization.DeserializationError;
import org.cafienne.infrastructure.serialization.DeserializationFailure;
import org.cafienne.infrastructure.serialization.EventSerializer;
import org.cafienne.infrastructure.serialization.ManifestWrapper;
import org.cafienne.infrastructure.serialization.ResponseSerializer;
import org.cafienne.infrastructure.serialization.SnapshotSerializer;
import org.cafienne.infrastructure.serialization.UnrecognizedManifest;
import org.cafienne.infrastructure.serialization.ValueMapDeserializer;
import org.cafienne.json.JSONParseFailure;
import org.cafienne.json.JSONReader;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CafienneSerializer
extends SerializerWithStringManifest {
    private static final Logger logger = LoggerFactory.getLogger(CafienneSerializer.class);
    public static final int IDENTIFIER = 52943;
    private static final Map<String, ManifestWrapper> manifests = new HashMap<String, ManifestWrapper>();
    private static final Map<Class<?>, ManifestWrapper> manifestsByClass = new HashMap();

    static ManifestWrapper getManifest(String string) {
        return manifests.get(string);
    }

    public static void addManifestWrapper(Class<?> clazz, ValueMapDeserializer<?> valueMapDeserializer) {
        ManifestWrapper manifestWrapper = new ManifestWrapper(clazz, valueMapDeserializer);
        manifestsByClass.put(manifestWrapper.eventClass, manifestWrapper);
        for (String string : manifestWrapper.manifestsByVersion) {
            manifests.put(string, manifestWrapper);
        }
    }

    public static String getManifestString(Object object) {
        if (object instanceof CafienneSerializable) {
            ManifestWrapper manifestWrapper = manifestsByClass.get(object.getClass());
            if (manifestWrapper != null) {
                return manifestWrapper.toString();
            }
            throw new RuntimeException("A manifest wrapper for class " + object.getClass().getName() + " has not been registered");
        }
        throw new RuntimeException("The Akka Case Object Serializer can only serialize objects implementing CafienneSerializable");
    }

    protected CafienneSerializer() {
    }

    protected CafienneSerializer(ExtendedActorSystem extendedActorSystem) {
    }

    private Object deserialize(String string, ValueMapProvider valueMapProvider, EventBlobProvider eventBlobProvider) {
        ManifestWrapper manifestWrapper = CafienneSerializer.getManifest(string);
        if (manifestWrapper == null) {
            logger.warn("Manifest " + string + " cannot be converted to one of the registered event types. Generating 'UnrecognizedManifest' object instead");
            return new UnrecognizedManifest(string, eventBlobProvider.giveMeTheBytes());
        }
        try {
            ValueMap valueMap = valueMapProvider.giveJson();
            valueMap = manifestWrapper.migrate(valueMap, string);
            ValueMapDeserializer<?> valueMapDeserializer = manifestWrapper.deserializer;
            return valueMapDeserializer.deserialize(valueMap);
        }
        catch (DeserializationError deserializationError) {
            return new DeserializationFailure(string, deserializationError, eventBlobProvider.giveMeTheBytes());
        }
        catch (Exception exception) {
            return new DeserializationFailure(string, exception, eventBlobProvider.giveMeTheBytes());
        }
    }

    public Object fromJson(ValueMap valueMap, String string) {
        return this.deserialize(string, () -> valueMap, () -> valueMap.toString().getBytes(StandardCharsets.UTF_8));
    }

    public Object fromBinary(byte[] byArray, String string) {
        return this.deserialize(string, () -> (ValueMap)JSONReader.parse(byArray), () -> byArray);
    }

    public int identifier() {
        return 52943;
    }

    public String manifest(Object object) {
        return CafienneSerializer.getManifestString(object);
    }

    public byte[] toBinary(Object object) {
        if (object instanceof CafienneSerializable) {
            CafienneSerializable cafienneSerializable = (CafienneSerializable)object;
            return cafienneSerializable.toBytes();
        }
        throw new RuntimeException("The Akka Case Object Serializer can only serialize objects implementing CafienneSerializable");
    }

    static {
        EventSerializer.register();
        CommandSerializer.register();
        ResponseSerializer.register();
        SnapshotSerializer.register();
    }

    @FunctionalInterface
    static interface EventBlobProvider {
        public byte[] giveMeTheBytes();
    }

    @FunctionalInterface
    static interface ValueMapProvider {
        public ValueMap giveJson() throws IOException, JSONParseFailure;
    }
}

