/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.infrastructure.serialization;

import org.cafienne.actormodel.response.ActorChokedFailure;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.EngineChokedFailure;
import org.cafienne.actormodel.response.SecurityFailure;
import org.cafienne.cmmn.actorapi.response.AddDiscretionaryItemResponse;
import org.cafienne.cmmn.actorapi.response.CaseNotModifiedResponse;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.actorapi.response.CaseStartedResponse;
import org.cafienne.cmmn.actorapi.response.GetDiscretionaryItemsResponse;
import org.cafienne.cmmn.actorapi.response.migration.MigrationStartedResponse;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupCreatedResponse;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupResponse;
import org.cafienne.humantask.actorapi.response.HumanTaskResponse;
import org.cafienne.humantask.actorapi.response.HumanTaskValidationResponse;
import org.cafienne.infrastructure.serialization.CafienneSerializer;
import org.cafienne.processtask.actorapi.response.ProcessResponse;
import org.cafienne.tenant.actorapi.response.TenantOwnersResponse;
import org.cafienne.tenant.actorapi.response.TenantResponse;

public class ResponseSerializer
extends CafienneSerializer {
    public static void register() {
        ResponseSerializer.addCaseResponses();
        ResponseSerializer.addHumanTaskResponses();
        ResponseSerializer.addProcessResponses();
        ResponseSerializer.addFailureResponses();
        ResponseSerializer.addTenantResponses();
        ResponseSerializer.addConsentGroupResponses();
    }

    private static void addCaseResponses() {
        ResponseSerializer.addManifestWrapper(AddDiscretionaryItemResponse.class, AddDiscretionaryItemResponse::new);
        ResponseSerializer.addManifestWrapper(GetDiscretionaryItemsResponse.class, GetDiscretionaryItemsResponse::new);
        ResponseSerializer.addManifestWrapper(CaseStartedResponse.class, CaseStartedResponse::new);
        ResponseSerializer.addManifestWrapper(MigrationStartedResponse.class, MigrationStartedResponse::new);
        ResponseSerializer.addManifestWrapper(CaseResponse.class, CaseResponse::new);
        ResponseSerializer.addManifestWrapper(CaseNotModifiedResponse.class, CaseNotModifiedResponse::new);
    }

    private static void addHumanTaskResponses() {
        ResponseSerializer.addManifestWrapper(HumanTaskResponse.class, HumanTaskResponse::new);
        ResponseSerializer.addManifestWrapper(HumanTaskValidationResponse.class, HumanTaskValidationResponse::new);
    }

    private static void addProcessResponses() {
        ResponseSerializer.addManifestWrapper(ProcessResponse.class, ProcessResponse::new);
    }

    private static void addFailureResponses() {
        ResponseSerializer.addManifestWrapper(CommandFailure.class, CommandFailure::new);
        ResponseSerializer.addManifestWrapper(SecurityFailure.class, SecurityFailure::new);
        ResponseSerializer.addManifestWrapper(ActorChokedFailure.class, ActorChokedFailure::new);
        ResponseSerializer.addManifestWrapper(EngineChokedFailure.class, EngineChokedFailure::new);
    }

    private static void addTenantResponses() {
        ResponseSerializer.addManifestWrapper(TenantOwnersResponse.class, TenantOwnersResponse::new);
        ResponseSerializer.addManifestWrapper(TenantResponse.class, TenantResponse::new);
    }

    private static void addConsentGroupResponses() {
        CafienneSerializer.addManifestWrapper(ConsentGroupCreatedResponse.class, ConsentGroupCreatedResponse::new);
        CafienneSerializer.addManifestWrapper(ConsentGroupResponse.class, ConsentGroupResponse::new);
    }
}

