/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.expression.spel.SpelReadable;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.ValueMapJacksonDeserializer;
import org.cafienne.infrastructure.serialization.ValueMapJacksonSerializer;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMapParser;

@JsonSerialize(using=ValueMapJacksonSerializer.class)
@JsonDeserialize(using=ValueMapJacksonDeserializer.class)
public class ValueMap
extends Value<Map<String, Value<?>>>
implements SpelReadable {
    public ValueMap() {
        super(new LinkedHashMap());
    }

    public ValueMap(Object ... objectArray) {
        this();
        this.plus(objectArray);
    }

    public ValueMap plus(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("Must provide sufficient input data to the ValueMap construction, of pattern String, Object, String, Object ...");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] == null) {
                throw new IllegalArgumentException("Field name cannot be null (argument nr " + i + ")");
            }
            String string = String.valueOf(objectArray[i]);
            if (string.length() > 50 && !(objectArray[i] instanceof String) && !(objectArray[i] instanceof Fields)) {
                throw new IllegalArgumentException("Field name at argument nr " + i + " is type " + objectArray[i].getClass().getName() + " generates a field name with too many characters (" + string.length() + "). Probably wrong argument order? Otherwise use put() method instead for this field.");
            }
            this.put(string, Value.convert(objectArray[i + 1]));
        }
        return this;
    }

    public Value<?> put(String string, Value<?> value) {
        return ((Map)this.value).put(string, value);
    }

    public Value<?> put(Fields fields, Value<?> value) {
        return this.put(fields.toString(), value);
    }

    @Override
    public void print(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            this.printField(jsonGenerator, (String)entry.getKey(), (Value)entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    private void printField(JsonGenerator jsonGenerator, String string, Value<?> value) throws IOException {
        jsonGenerator.writeFieldName(string);
        value.print(jsonGenerator);
    }

    @Override
    public boolean isSupersetOf(Value<?> value) {
        if (value == null || !value.isMap()) {
            return false;
        }
        Map map = (Map)this.value;
        Map map2 = (Map)value.asMap().value;
        if (map2.size() > map.size()) {
            return false;
        }
        for (String string : map2.keySet()) {
            Value value2 = (Value)map.get(string);
            Value value3 = (Value)map2.get(string);
            if (value2 != null && value2.isSupersetOf(value3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public void clearOwner() {
        super.clearOwner();
        ((Map)this.value).values().forEach(value -> value.clearOwner());
    }

    public Iterator<String> fieldNames() {
        return ((Map)this.value).keySet().iterator();
    }

    public Value<?> get(String string) {
        Value<?> value = (Value<?>)((Map)this.value).get(string);
        if (value == null) {
            value = Value.NULL;
        }
        return value;
    }

    public Value<?> get(Fields fields) {
        return this.get(fields.toString());
    }

    public boolean has(String string) {
        return ((Map)this.value).containsKey(string);
    }

    public boolean has(Fields fields) {
        return this.has(fields.toString());
    }

    public ValueMap with(String string) {
        Value value = (Value)((Map)this.value).get(string);
        if (!(value instanceof ValueMap)) {
            value = new ValueMap();
            ((Map)this.value).put(string, value);
        }
        return value.asMap();
    }

    public ValueMap with(Fields fields) {
        return this.with(fields.toString());
    }

    public ValueList withArray(String string) {
        Value value = (Value)((Map)this.value).get(string);
        if (!(value instanceof ValueList)) {
            value = new ValueList(new Object[0]);
            ((Map)this.value).put(string, value);
        }
        return value.asList();
    }

    public ValueList withArray(Fields fields) {
        return this.withArray(fields.toString());
    }

    public <T> T raw(String string) {
        Object t = this.get((String)string).value;
        return t;
    }

    public <T> T raw(Fields fields) {
        return this.raw(fields.toString());
    }

    public int rawInt(String string) {
        Value<?> value = this.get(string);
        return ((Long)value.value).intValue();
    }

    public int rawInt(Fields fields) {
        return this.rawInt(fields.toString());
    }

    public Instant rawInstant(String string) {
        Value<?> value = this.get(string);
        if (value == Value.NULL) {
            return null;
        }
        return Instant.parse(value.value.toString());
    }

    public Instant rawInstant(Fields fields) {
        return this.rawInstant(fields.toString());
    }

    private <T extends Enum<?>> T getEnum(Fields fields, Class<T> clazz) {
        return this.getEnum(fields.toString(), clazz);
    }

    private <T extends Enum<?>> T getEnum(String string, Class<T> clazz) {
        Value<?> value = this.get(string);
        if (value == null || value == Value.NULL) {
            return null;
        }
        String string2 = String.valueOf(value.value);
        if (string2 == null) {
            return null;
        }
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return (T)((Enum)method.invoke(clazz, string2));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.fillInStackTrace());
        }
    }

    @Override
    public boolean canRead(String string) {
        return true;
    }

    @Override
    public Value<?> read(String string) {
        return this.get(string);
    }

    public ValueMap cloneValueNode() {
        ValueMap valueMap = new ValueMap();
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            ((Map)valueMap.value).put((String)entry.getKey(), ((Value)entry.getValue()).cloneValueNode());
        }
        return valueMap;
    }

    @Override
    public <V extends Value<?>> V merge(V v) {
        if (!v.isMap()) {
            return v;
        }
        ((Map)v.asMap().value).forEach((string, value) -> {
            Value value2 = (Value)((Map)this.value).get(string);
            if (value2 != null) {
                value = value2.merge(value);
            }
            ((Map)this.value).put(string, value);
        });
        return (V)this;
    }

    @SafeVarargs
    public final <T> T readField(Fields fields, T ... TArray) {
        if (this.has(fields)) {
            return this.raw(fields);
        }
        if (TArray.length > 0) {
            return TArray[0];
        }
        return null;
    }

    public <T extends Enum<?>> T readEnum(Fields fields, Class<T> clazz) {
        return this.getEnum(fields, clazz);
    }

    public String readString(Fields fields, String ... stringArray) {
        return this.readField(fields, stringArray);
    }

    public Boolean readBoolean(Fields fields, Boolean ... booleanArray) {
        if (booleanArray.length > 0) {
            return this.readField(fields, booleanArray);
        }
        return this.readField(fields, false);
    }

    public Instant readInstant(Fields fields) {
        return this.rawInstant(fields);
    }

    public String[] readStringList(Fields fields) {
        List<String> list = this.withArray(fields).rawList();
        return list.toArray(new String[0]);
    }

    public ValueMap readMap(Fields fields) {
        return this.with(fields);
    }

    public <T> Set<T> readSet(Fields fields) {
        return new HashSet(this.withArray(fields).rawList());
    }

    public <T extends CMMNElementDefinition> T readDefinition(Fields fields, Class<T> clazz) {
        return CMMNElementDefinition.fromJSON(this.getClass().getName(), this.readMap(fields), clazz);
    }

    public Path readPath(Fields fields) {
        return new Path(this.readString(fields, new String[0]));
    }

    public <T> T readObject(Fields fields, ValueMapParser<T> valueMapParser) {
        ValueMap valueMap = this.with(fields);
        return valueMapParser.convert(valueMap);
    }

    public <T> List<T> readObjects(Fields fields, ValueMapParser<T> valueMapParser) {
        return this.withArray(fields).stream().map(value -> valueMapParser.convert(value.asMap())).collect(Collectors.toList());
    }
}

