/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.actorapi.command.ProcessCommand;
import org.cafienne.processtask.actorapi.event.ProcessStarted;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.instance.ProcessTaskActor;

@Manifest
public class StartProcess
extends ProcessCommand
implements BootstrapMessage {
    private final String parentActorId;
    private final String rootActorId;
    private final String tenant;
    private final String name;
    private final ValueMap inputParameters;
    private transient ProcessDefinition definition;
    private final boolean debugMode;

    public StartProcess(UserIdentity userIdentity, String string, String string2, String string3, ProcessDefinition processDefinition, ValueMap valueMap, String string4, String string5, boolean bl) {
        super(userIdentity, string2);
        this.name = string3;
        this.tenant = string;
        this.parentActorId = string4;
        this.rootActorId = string5;
        this.inputParameters = valueMap;
        this.definition = processDefinition;
        this.debugMode = bl;
    }

    public StartProcess(ValueMap valueMap) {
        super(valueMap);
        this.name = valueMap.readString(Fields.name, new String[0]);
        this.tenant = valueMap.readString(Fields.tenant, new String[0]);
        this.parentActorId = valueMap.readString(Fields.parentActorId, new String[0]);
        this.rootActorId = valueMap.readString(Fields.rootActorId, new String[0]);
        this.inputParameters = valueMap.readMap(Fields.inputParameters);
        this.definition = valueMap.readDefinition(Fields.processDefinition, ProcessDefinition.class);
        this.debugMode = valueMap.readBoolean(Fields.debugMode, new Boolean[0]);
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    public String getParentActorId() {
        return this.parentActorId;
    }

    public String getRootActorId() {
        return this.rootActorId;
    }

    public String getName() {
        return this.name;
    }

    public ValueMap getInputParameters() {
        return this.inputParameters;
    }

    public ProcessDefinition getDefinition() {
        return this.definition;
    }

    public boolean debugMode() {
        return this.debugMode;
    }

    @Override
    protected void process(ProcessTaskActor processTaskActor, SubProcess<?> subProcess) {
        processTaskActor.addEvent(new ProcessStarted(processTaskActor, this));
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelCommand(jsonGenerator);
        this.writeField(jsonGenerator, Fields.name, this.name);
        this.writeField(jsonGenerator, Fields.tenant, this.tenant);
        this.writeField(jsonGenerator, Fields.inputParameters, this.inputParameters);
        this.writeField(jsonGenerator, Fields.parentActorId, this.parentActorId);
        this.writeField(jsonGenerator, Fields.rootActorId, this.rootActorId);
        this.writeField(jsonGenerator, Fields.debugMode, this.debugMode);
        this.writeField(jsonGenerator, Fields.processDefinition, this.definition);
    }
}

