/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.infrastructure.CafienneVersion;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.actorapi.command.StartProcess;
import org.cafienne.processtask.actorapi.event.BaseProcessEvent;
import org.cafienne.processtask.definition.ProcessDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

@Manifest
public class ProcessStarted
extends BaseProcessEvent
implements BootstrapMessage {
    public final String parentActorId;
    public final String rootActorId;
    public final String name;
    public final ValueMap inputParameters;
    public transient ProcessDefinition definition;
    public final boolean debugMode;
    public final CafienneVersion engineVersion;

    public ProcessStarted(ProcessTaskActor processTaskActor, StartProcess startProcess) {
        super(processTaskActor);
        this.debugMode = startProcess.debugMode();
        this.definition = startProcess.getDefinition();
        this.name = startProcess.getName();
        this.parentActorId = startProcess.getParentActorId();
        this.rootActorId = startProcess.getRootActorId();
        this.inputParameters = startProcess.getInputParameters();
        this.engineVersion = Cafienne.version();
    }

    public ProcessStarted(ValueMap valueMap) {
        super(valueMap);
        this.engineVersion = valueMap.readObject(Fields.engineVersion, CafienneVersion::new);
        this.name = valueMap.readString(Fields.name, new String[0]);
        this.parentActorId = valueMap.readString(Fields.parentActorId, new String[0]);
        this.rootActorId = valueMap.readString(Fields.rootActorId, new String[0]);
        this.inputParameters = valueMap.readMap(Fields.input);
        this.definition = valueMap.readDefinition(Fields.processDefinition, ProcessDefinition.class);
        this.debugMode = valueMap.readBoolean(Fields.debugMode, new Boolean[0]);
    }

    @Override
    public void updateState(ProcessTaskActor processTaskActor) {
        processTaskActor.updateState(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, Fields.input, this.inputParameters);
        this.writeField(jsonGenerator, Fields.name, this.name);
        this.writeField(jsonGenerator, Fields.parentActorId, this.parentActorId);
        this.writeField(jsonGenerator, Fields.rootActorId, this.rootActorId);
        this.writeField(jsonGenerator, Fields.debugMode, this.debugMode);
        this.writeField(jsonGenerator, Fields.processDefinition, this.definition);
        this.writeField(jsonGenerator, Fields.engineVersion, this.engineVersion.json());
    }
}

