/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.parameter.OutputParameterDefinition;
import org.cafienne.processtask.definition.SubProcessMapping;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.w3c.dom.Element;

public abstract class SubProcessDefinition
extends CMMNElementDefinition {
    public static final String EXCEPTION_PARAMETER = "exception";
    private final Collection<SubProcessMapping> mappings = new ArrayList<SubProcessMapping>();
    private final Collection<SubProcessMapping> successMappings = new ArrayList<SubProcessMapping>();
    private final Collection<SubProcessMapping> failureMappings = new ArrayList<SubProcessMapping>();
    private final boolean isAsync = Boolean.parseBoolean(this.parseAttribute("async", false, "true"));

    protected SubProcessDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.parse("parameterMapping", SubProcessMapping.class, this.mappings);
        this.successMappings.addAll(this.mappings);
        this.failureMappings.addAll(this.mappings);
        this.parseGrandChildren("success", "parameterMapping", SubProcessMapping.class, this.successMappings);
        this.parseGrandChildren("failure", "parameterMapping", SubProcessMapping.class, this.failureMappings);
    }

    public boolean isInline() {
        return false;
    }

    public abstract SubProcess<?> createInstance(ProcessTaskActor var1);

    public Collection<SubProcessMapping> getSuccessMappings() {
        return this.successMappings;
    }

    public Collection<SubProcessMapping> getFailureMappings() {
        return this.failureMappings;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    protected abstract Set<String> getRawOutputParameterNames();

    protected Set<String> getExceptionParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(EXCEPTION_PARAMETER);
        return hashSet;
    }

    public Map<String, OutputParameterDefinition> getRawOutputParameters() {
        Set<String> set = this.getRawOutputParameterNames();
        HashMap<String, OutputParameterDefinition> hashMap = new HashMap<String, OutputParameterDefinition>();
        for (String string : set) {
            Element element = this.getElement().getOwnerDocument().createElement("parameter");
            element.setAttribute("name", string);
            element.setAttribute("id", string);
            OutputParameterDefinition outputParameterDefinition = new OutputParameterDefinition(element, null, this);
            hashMap.put(string, outputParameterDefinition);
        }
        return hashMap;
    }

    public boolean sameSubProcess(SubProcessDefinition subProcessDefinition) {
        return this.same((Object)this.isAsync, (Object)subProcessDefinition.isAsync) && this.same(this.mappings, subProcessDefinition.mappings) && this.same(this.successMappings, subProcessDefinition.successMappings) && this.same(this.failureMappings, subProcessDefinition.failureMappings);
    }
}

