/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation;

import java.util.Collection;
import java.util.Map;
import org.cafienne.cmmn.instance.debug.DebugInfoAppender;
import org.cafienne.cmmn.instance.task.process.ProcessTask;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.definition.InlineSubProcessDefinition;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.definition.SubProcessMapping;

public abstract class InlineSubProcess<T extends InlineSubProcessDefinition> {
    protected final ProcessTask task;
    protected final T definition;
    private final ValueMap rawOutputParameters = new ValueMap();
    private final ValueMap processOutputParameters = new ValueMap();

    protected InlineSubProcess(ProcessTask processTask, T t) {
        this.task = processTask;
        this.definition = t;
    }

    protected final void raiseComplete() {
        this.transformRawParametersToProcessOutputParameters(((SubProcessDefinition)this.definition).getSuccessMappings());
        this.task.goComplete(this.processOutputParameters);
    }

    protected final void raiseFault(String string) {
        this.transformRawParametersToProcessOutputParameters(((SubProcessDefinition)this.definition).getFailureMappings());
        this.task.goFault(this.processOutputParameters);
    }

    protected void raiseFault(String string, Throwable throwable) {
        this.setFault(Value.convert(throwable));
        this.raiseFault(string);
    }

    protected void setFault(Value<?> value) {
        String string = "exception";
        this.rawOutputParameters.put(string, value);
        this.processOutputParameters.put(string, value);
    }

    public void resetOutput() {
        ((Map)this.rawOutputParameters.getValue()).clear();
        ((Map)this.processOutputParameters.getValue()).clear();
    }

    protected void addDebugInfo(DebugInfoAppender debugInfoAppender) {
        this.task.getCaseInstance().addDebugInfo(debugInfoAppender, new Object[0]);
    }

    protected void transformRawParametersToProcessOutputParameters(Collection<SubProcessMapping> collection) {
        this.addDebugInfo(() -> "Found " + collection.size() + " output parameter mappings");
        ((Map)this.rawOutputParameters.getValue()).forEach((string, value) -> this.processOutputParameters.put((String)string, value.cloneValueNode()));
    }

    protected void setRawOutputParameter(String string, Value<?> value) {
        this.rawOutputParameters.put(string, value);
    }

    protected void setProcessOutputParameter(String string, Value<?> value) {
        this.processOutputParameters.put(string, value);
    }

    protected ValueMap getRawOutputParameters() {
        return this.rawOutputParameters;
    }

    protected ValueMap getProcessOutputParameters() {
        return this.processOutputParameters;
    }

    public abstract void start();

    public abstract void reactivate();

    public abstract void suspend();

    public abstract void terminate();

    public abstract void resume();
}

