/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.calculation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.instance.task.process.ProcessTask;
import org.cafienne.processtask.definition.InlineSubProcessDefinition;
import org.cafienne.processtask.implementation.calculation.Calculation;
import org.cafienne.processtask.implementation.calculation.definition.FilterStepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.MapStepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.StepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.InputParameterSourceDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.SourceDefinition;
import org.w3c.dom.Element;

public class CalculationDefinition
extends InlineSubProcessDefinition {
    private final Collection<StepDefinition> steps = new ArrayList<StepDefinition>();
    private final Map<String, SourceDefinition> sources = new HashMap<String, SourceDefinition>();

    public CalculationDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parse("step", StepDefinition.class, this.steps);
        this.parse("filter", FilterStepDefinition.class, this.steps);
        this.parse("map", MapStepDefinition.class, this.steps);
        this.getProcessDefinition().getInputParameters().forEach((string, inputParameterDefinition) -> this.sources.put((String)string, new InputParameterSourceDefinition((InputParameterDefinition)inputParameterDefinition)));
        this.steps.forEach(stepDefinition -> this.sources.put(stepDefinition.getIdentifier(), (SourceDefinition)stepDefinition));
        this.getProcessDefinition().getOutputParameters().forEach((string, outputParameterDefinition) -> {
            if (!this.sources.containsKey(string)) {
                modelDefinition.addDefinitionError("Calculation Task '" + modelDefinition.getName() + "' has an output parameter '" + string + "' but no mapping to fill it.");
            }
        });
    }

    public SourceDefinition getSource(String string) {
        return this.sources.get(string);
    }

    public SourceDefinition getTarget(String string) {
        return this.sources.get(string);
    }

    public Calculation createInstance(ProcessTask processTask) {
        return new Calculation(processTask, this);
    }

    @Override
    protected Set<String> getRawOutputParameterNames() {
        return super.getExceptionParameterNames();
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

