/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.implementation.http.HTTPCallDefinition;
import org.cafienne.processtask.implementation.http.Result;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCall
extends SubProcess<HTTPCallDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(HTTPCall.class);
    private Result result = new Result(this);
    private URL targetURL;
    private String requestPayload;
    private String requestMethod;

    public HTTPCall(ProcessTaskActor processTaskActor, HTTPCallDefinition hTTPCallDefinition) {
        super(processTaskActor, hTTPCallDefinition);
    }

    @Override
    public void reactivate() {
        this.start();
    }

    @Override
    public void start() {
        boolean bl = this.runCall();
        this.processTaskActor.addDebugInfo(() -> this.result.getDebugInfo(), new Object[0]);
        this.getRawOutputParameters().merge(this.result.toJSON());
        if (bl) {
            this.raiseComplete();
        } else {
            this.setFault(this.result.getException());
            this.raiseFault(this.result.getErrorDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runCall() {
        HttpURLConnection httpURLConnection;
        ValueMap valueMap = this.processTaskActor.getMappedInputParameters();
        this.targetURL = ((HTTPCallDefinition)this.definition).getURL().resolveParameters(valueMap).toURL();
        this.result.setTargetURL(this.targetURL);
        this.requestMethod = ((HTTPCallDefinition)this.definition).getMethod().resolveParameters(valueMap).toString();
        this.result.setRequestMethod(this.requestMethod);
        try {
            httpURLConnection = (HttpURLConnection)this.targetURL.openConnection();
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Could not create a connection with " + this.targetURL, iOException);
        }
        try {
            httpURLConnection.setRequestMethod(this.requestMethod);
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Cannot set http method " + this.requestMethod, iOException);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        ((HTTPCallDefinition)this.definition).getHeaders().forEach(header -> linkedHashMap.put(header.getName(valueMap), header.getValue(valueMap)));
        this.result.setRequestHeaders(linkedHashMap);
        linkedHashMap.forEach((string, string2) -> httpURLConnection.setRequestProperty((String)string, (String)string2));
        if (this.requestMethod.equalsIgnoreCase("POST") || this.requestMethod.equalsIgnoreCase("PUT")) {
            this.requestPayload = ((HTTPCallDefinition)this.definition).getContent().resolveParameters(valueMap).toString();
            this.result.setRequestPayload(this.requestPayload);
            if (this.requestPayload.trim().length() > 0) {
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    dataOutputStream.writeBytes(this.requestPayload);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    return this.result.handleFailure("Failed to write content to " + this.targetURL, iOException);
                }
            }
        }
        try {
            this.result.setResponseCode(httpURLConnection.getResponseCode());
            this.result.setResponseMessage(httpURLConnection.getResponseMessage());
            this.result.setResponseHeaders(httpURLConnection.getHeaderFields());
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Failed to read response", iOException);
        }
        if (this.result.isOutOf200Range()) {
            StringBuilder stringBuilder = new StringBuilder();
            InputStream inputStream = null;
            try {
                int n;
                inputStream = httpURLConnection.getErrorStream();
                while (inputStream != null && (n = inputStream.read()) != -1) {
                    stringBuilder.append((char)n);
                }
                this.result.setResponsePayload(stringBuilder.toString());
                boolean bl = this.result.handleFailure("Status code " + this.result.getCode() + " is interpreted as a failure");
                return bl;
            }
            catch (IOException iOException) {
                this.result.setResponsePayload(stringBuilder.toString());
                boolean bl = this.result.handleFailure("Failed to read response payload for status code " + this.result.getCode(), iOException);
                return bl;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close the error stream", (Throwable)iOException);
                }
            }
        }
        try {
            int n;
            InputStream inputStream = httpURLConnection.getInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = inputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            this.result.setResponsePayload(stringBuilder.toString());
            inputStream.close();
        }
        catch (IOException iOException) {
            return this.result.handleFailure("Technical failure while reading http response although http code was " + this.result.getCode(), iOException);
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return true;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void resume() {
    }
}

