/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.cmmn.instance.task.validation.TaskOutputValidator;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.implementation.http.HTTPCall;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.cafienne.util.StringTemplate;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Element;

public class HTTPCallDefinition
extends SubProcessDefinition {
    public static final String RESPONSE_PAYLOAD_PARAMETER = "responsePayload";
    public static final String RESPONSE_CODE_PARAMETER = "responseCode";
    public static final String RESPONSE_MESSAGE_PARAMETER = "responseMessage";
    public static final String RESPONSE_HEADERS_PARAMETER = "responseHeaders";
    private final String contentTemplate;
    private final String httpMethod;
    private final String sourceURL;
    private final List<Header> httpHeaders = new ArrayList<Header>();

    public HTTPCallDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.sourceURL = this.parseString("url", true, new String[0]);
        this.httpMethod = this.parseString("method", true, new String[0]);
        this.contentTemplate = this.parseString("post-content", false, new String[0]);
        Element element2 = XMLHelper.getElement(element, "http-headers");
        if (element2 != null) {
            List<Element> list = XMLHelper.getChildrenWithTagName(element2, "http-header");
            for (Element element3 : list) {
                String string = element3.getAttribute("name");
                String string2 = XMLHelper.getContent(element3, null, "");
                this.httpHeaders.add(new Header(string, string2));
            }
        }
    }

    @Override
    public Set<String> getRawOutputParameterNames() {
        Set<String> set = super.getExceptionParameterNames();
        set.add(RESPONSE_CODE_PARAMETER);
        set.add(RESPONSE_HEADERS_PARAMETER);
        set.add(RESPONSE_MESSAGE_PARAMETER);
        set.add(RESPONSE_PAYLOAD_PARAMETER);
        return set;
    }

    public List<Header> getHeaders() {
        return this.httpHeaders;
    }

    public StringTemplate getURL() {
        return new StringTemplate(this.sourceURL);
    }

    public StringTemplate getMethod() {
        return new StringTemplate(this.httpMethod);
    }

    public StringTemplate getContent() {
        return new StringTemplate(this.contentTemplate);
    }

    public HTTPCall createInstance(ProcessTaskActor processTaskActor) {
        return new HTTPCall(processTaskActor, this);
    }

    public TaskOutputValidator createValidator(HumanTask humanTask) {
        return new TaskOutputValidator(this, humanTask);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameHTTPCall);
    }

    public boolean sameHTTPCall(HTTPCallDefinition hTTPCallDefinition) {
        return super.sameSubProcess(hTTPCallDefinition) && this.same(this.contentTemplate, hTTPCallDefinition.contentTemplate) && this.same(this.httpMethod, hTTPCallDefinition.httpMethod) && this.same(this.sourceURL, hTTPCallDefinition.sourceURL) && this.sameCollection(this.httpHeaders, hTTPCallDefinition.httpHeaders);
    }

    private boolean sameCollection(Collection<?> collection, Collection<?> collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (Object obj : collection) {
            if (!collection2.stream().noneMatch(object2 -> this.same(obj, object2))) continue;
            return false;
        }
        return true;
    }

    public class Header {
        private final String sourceName;
        private final String sourceValue;

        Header(String string, String string2) {
            this.sourceName = string;
            this.sourceValue = string2;
        }

        public String getName(ValueMap valueMap) {
            StringTemplate stringTemplate = new StringTemplate(this.sourceName);
            stringTemplate.resolveParameters(valueMap);
            return stringTemplate.toString();
        }

        public String getValue(ValueMap valueMap) {
            StringTemplate stringTemplate = new StringTemplate(this.sourceValue);
            stringTemplate.resolveParameters(valueMap);
            return stringTemplate.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Header)) {
                return false;
            }
            Header header = (Header)object;
            return Objects.equals(this.sourceName, header.sourceName) && Objects.equals(this.sourceValue, header.sourceValue);
        }

        public int hashCode() {
            return Objects.hash(this.sourceName, this.sourceValue);
        }
    }
}

