/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.http;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cafienne.json.JSONParseFailure;
import org.cafienne.json.JSONReader;
import org.cafienne.json.LongValue;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.http.HTTPCall;

class Result {
    private URL targetURL;
    private String requestMethod;
    private Map<String, String> requestHeaders;
    private String requestPayload;
    private int responseCode = -1;
    private String responseMessage = "";
    private Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
    private String responsePayload = "";
    private final HTTPCall call;
    String errorDescription = "";
    Throwable cause;

    Result(HTTPCall hTTPCall) {
        this.call = hTTPCall;
    }

    void setTargetURL(URL uRL) {
        this.targetURL = uRL;
    }

    void setRequestMethod(String string) {
        this.requestMethod = string;
    }

    void setRequestHeaders(Map<String, String> map) {
        this.requestHeaders = map;
    }

    void setRequestPayload(String string) {
        this.requestPayload = string;
    }

    void setResponseCode(int n) {
        this.responseCode = n;
    }

    void setResponseMessage(String string) {
        this.responseMessage = string;
    }

    void setResponseHeaders(Map<String, List<String>> map) {
        this.responseHeaders = map;
    }

    void setResponsePayload(String string) {
        this.responsePayload = string;
    }

    boolean handleFailure(String string, Throwable throwable) {
        this.cause = throwable;
        return this.handleFailure(string);
    }

    boolean handleFailure(String string) {
        this.errorDescription = string;
        return false;
    }

    boolean isOutOf200Range() {
        return this.responseCode == -1 || this.responseCode > 299;
    }

    int getCode() {
        return this.responseCode;
    }

    String getErrorDescription() {
        return this.errorDescription;
    }

    Value<?> getException() {
        if (this.cause != null) {
            return Value.convert(this.cause);
        }
        return new ValueMap("description", this.getErrorDescription(), "response", this.getResponseDebugInfo());
    }

    ValueMap toJSON() {
        ValueMap valueMap = new ValueMap();
        valueMap.put("responseHeaders", this.convertHeadersToJSON());
        valueMap.put("responseCode", new LongValue(this.responseCode));
        valueMap.put("responseMessage", new StringValue(this.responseMessage));
        valueMap.put("responsePayload", this.convertPayloadToJSON(this.responsePayload));
        return valueMap;
    }

    Value<?> getDebugInfo() {
        return new ValueMap("Request", this.getRequestDebugInfo(), "Response", this.getResponseDebugInfo());
    }

    ValueMap getRequestDebugInfo() {
        ValueMap valueMap = new ValueMap();
        valueMap.put("url", new StringValue(this.requestMethod + " " + this.targetURL.toString()));
        if (!this.requestHeaders.isEmpty()) {
            valueMap.put("headers", Value.convert(this.requestHeaders));
        }
        if (this.requestPayload != null) {
            valueMap.put("payload", this.convertPayloadToJSON(this.requestPayload));
        }
        return valueMap;
    }

    ValueMap getResponseDebugInfo() {
        ValueMap valueMap = new ValueMap();
        this.responseHeaders.forEach((string, list) -> valueMap.plus(string == null ? "" : string, String.join((CharSequence)" ", list)));
        ValueMap valueMap2 = new ValueMap("code", this.responseCode, "message", new StringValue(this.responseMessage), "headers", valueMap, "content", this.convertPayloadToJSON(this.responsePayload));
        if (this.responseCode == -1 && !this.errorDescription.isEmpty()) {
            valueMap2.put("error", new StringValue(this.errorDescription));
        }
        return valueMap2;
    }

    private Value<?> convertPayloadToJSON(String string) {
        try {
            return JSONReader.parse(string);
        }
        catch (IOException | JSONParseFailure exception) {
            return new StringValue(string);
        }
    }

    private ValueMap convertHeadersToJSON() {
        ValueMap valueMap = new ValueMap();
        this.responseHeaders.forEach((string, list) -> valueMap.plus(string == null ? "" : string, list));
        return valueMap;
    }
}

