/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import java.net.SocketException;
import java.net.URI;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.RandomUidGenerator;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.mail.InvalidMailAddressException;
import org.cafienne.processtask.implementation.mail.InvalidMailException;

public class CalendarInvite {
    public final String invite;

    CalendarInvite(ValueMap valueMap) {
        Calendar calendar;
        Instant instant = valueMap.rawInstant("start");
        Instant instant2 = valueMap.rawInstant("end");
        String string = valueMap.has("timeZone") ? (String)valueMap.raw("timeZone") : ZoneId.systemDefault().toString();
        String string2 = (String)valueMap.raw("meetingName");
        String string3 = valueMap.has("description") ? (String)valueMap.raw("description") : "";
        String string4 = valueMap.has("location") ? (String)valueMap.raw("location") : "";
        String string5 = valueMap.has("uid") ? (String)valueMap.raw("uid") : new RandomUidGenerator().generateUid().toString();
        try {
            ZoneId.of(string);
        }
        catch (DateTimeException dateTimeException) {
            // empty catch block
        }
        instant.atZone(ZoneId.of(string));
        instant2.atZone(ZoneId.of(string));
        String string6 = string2;
        DateTime dateTime = new DateTime(Date.from((Instant)instant));
        DateTime dateTime2 = new DateTime(Date.from((Instant)instant2));
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, string6);
        vEvent.getProperties().add((Property)new Description(string3));
        vEvent.getProperties().add((Property)new Location(string4));
        TzId tzId = new TzId(string);
        vEvent.getProperties().add((Property)tzId);
        vEvent.getProperties().add((Property)new Uid(string5));
        Calendar calendar2 = calendar = this.getAttendees(valueMap.get("required"));
        int n = ((Attendee[])calendar2).length;
        for (int i = 0; i < n; ++i) {
            Attendee attendee = calendar2[i];
            attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
            vEvent.getProperties().add((Property)attendee);
        }
        for (Attendee attendee : calendar2 = this.getAttendees(valueMap.get("optional"))) {
            attendee.getParameters().add((Parameter)Role.OPT_PARTICIPANT);
            vEvent.getProperties().add((Property)attendee);
        }
        Calendar calendar3 = new Calendar();
        calendar3.getProperties().add((Property)new ProdId("-//Events Calendar//iCal4j 1.0//EN"));
        calendar3.getProperties().add((Property)CalScale.GREGORIAN);
        calendar3.getComponents().add((Object)vEvent);
        this.invite = calendar3.toString();
    }

    private Attendee[] getAttendees(Value<?> value2) {
        ArrayList<Attendee> arrayList = new ArrayList<Attendee>();
        if (value2.isMap() && !((Map)value2.asMap().getValue()).isEmpty()) {
            arrayList.add(this.getAttendee(value2));
        } else if (value2.isList()) {
            value2.asList().forEach(value -> arrayList.add(this.getAttendee((Value<?>)value)));
        } else if (value2.getValue() != null && value2.getValue() instanceof String) {
            arrayList.add(this.getAttendee(value2));
        }
        return arrayList.toArray(new Attendee[arrayList.size()]);
    }

    private Attendee getAttendee(Value<?> value) throws InvalidMailException {
        String string = "";
        String string2 = "";
        if (value.isMap()) {
            string = (String)value.asMap().raw("email");
            string2 = (String)value.asMap().raw("name");
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
        } else if (value.isPrimitive() && value instanceof StringValue) {
            string = (String)((StringValue)value).getValue();
        } else {
            throw new InvalidMailAddressException("Cannot extract an email address from an object of type " + value.getClass().getSimpleName());
        }
        if (string == null || string.isBlank()) {
            throw new InvalidMailAddressException("Missing email address in object of type " + value.getClass().getSimpleName());
        }
        Attendee attendee = new Attendee(URI.create("mailto:" + string));
        if (!string2.isBlank()) {
            attendee.getParameters().add((Parameter)new Cn(string2));
        }
        return attendee;
    }

    public static void main(String[] stringArray) throws SocketException {
        new CalendarInvite(new ValueMap());
    }
}

