/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.implementation.SubProcess;
import org.cafienne.processtask.implementation.mail.CalendarInvite;
import org.cafienne.processtask.implementation.mail.InvalidMailAddressException;
import org.cafienne.processtask.implementation.mail.InvalidMailException;
import org.cafienne.processtask.implementation.mail.MailDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mail<D extends MailDefinition>
extends SubProcess<D> {
    private static final Logger logger = LoggerFactory.getLogger(Mail.class);
    private Session mailSession;
    private Transport transport;

    public Mail(ProcessTaskActor processTaskActor, D d) {
        super(processTaskActor, d);
    }

    @Override
    public void reactivate() {
        this.start();
    }

    private void connectMailServer() throws MessagingException {
        this.processTaskActor.addDebugInfo(() -> "Connecting to mail server", new Object[0]);
        long l = System.currentTimeMillis();
        Properties properties = ((MailDefinition)this.definition).getMailProperties();
        final String string = properties.get("authentication.user").toString();
        final String string2 = properties.get("authentication.password").toString();
        this.mailSession = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string, string2);
            }
        });
        this.transport = this.mailSession.getTransport();
        this.transport.connect();
        long l2 = System.currentTimeMillis();
        this.processTaskActor.addDebugInfo(() -> "Connect to mail server took " + (l2 - l) + " milliseconds", new Object[0]);
    }

    private void disconnectMailServer() throws MessagingException {
        long l = System.currentTimeMillis();
        this.transport.close();
        long l2 = System.currentTimeMillis();
        this.processTaskActor.addDebugInfo(() -> "Disconnecting from mail server took " + (l2 - l) + " milliseconds", new Object[0]);
    }

    private ValueMap getParameters() {
        ValueMap valueMap = this.processTaskActor.getMappedInputParameters();
        return ((MailDefinition)this.definition).convert(valueMap);
    }

    @Override
    public void start() {
        ValueMap valueMap = this.getParameters();
        try {
            Object object;
            this.connectMailServer();
            MimeMessage mimeMessage = new MimeMessage(this.mailSession);
            try {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])this.getAddresses(valueMap.get("to"), "To"));
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])this.getAddresses(valueMap.get("cc"), "Cc"));
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.getAddresses(valueMap.get("bcc"), "Bcc"));
            }
            catch (InvalidMailException invalidMailException) {
                this.raiseFault("Failed to set recipients for mail message", invalidMailException.getCause());
                return;
            }
            if (mimeMessage.getAllRecipients() == null || mimeMessage.getAllRecipients().length == 0) {
                this.raiseFault("Mail message has no recipients", new IllegalArgumentException("Mail message has no recipients"));
                return;
            }
            String string = (String)valueMap.raw("subject");
            mimeMessage.setSubject(string);
            this.processTaskActor.addDebugInfo(() -> "Subject: " + string, new Object[0]);
            mimeMessage.addFrom((Address[])this.getAddresses(valueMap.get("from"), "From"));
            InternetAddress[] internetAddressArray = this.getAddresses(valueMap.get("replyTo"), "Reply-To");
            mimeMessage.setReplyTo((Address[])internetAddressArray);
            MimeMultipart mimeMultipart = new MimeMultipart();
            String string2 = (String)valueMap.raw("body");
            this.processTaskActor.addDebugInfo(() -> "Body: " + string2, new Object[0]);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)string2, "text/html");
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            ValueList valueList = valueMap.withArray("attachments");
            this.processTaskActor.addDebugInfo(() -> "Adding " + valueList.size() + " attachments", new Object[0]);
            valueList.forEach(arg_0 -> this.lambda$start$9((Multipart)mimeMultipart, arg_0));
            ValueMap valueMap2 = valueMap.with("invite");
            if (!((Map)valueMap2.getValue()).isEmpty()) {
                MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                try {
                    if (!valueMap2.has("required") && !valueMap2.has("optional")) {
                        valueMap2.put("required", valueMap.get("to"));
                        valueMap2.put("optional", valueMap.get("cc"));
                    }
                    if (!valueMap2.has("meetingName")) {
                        valueMap2.plus("meetingName", string);
                    }
                    String string3 = new CalendarInvite((ValueMap)valueMap2).invite;
                    object = "invite.ics";
                    String string4 = "text/calendar";
                    ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(string3.getBytes(StandardCharsets.UTF_8), string4);
                    mimeBodyPart2.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                    mimeBodyPart2.setFileName((String)object);
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
                    this.processTaskActor.addDebugInfo(() -> "Added calendar invite", new Object[0]);
                }
                catch (MessagingException messagingException) {
                    throw new InvalidMailException("Cannot add the invite attachment", messagingException);
                }
            }
            mimeMessage.setContent((Multipart)mimeMultipart);
            this.processTaskActor.addDebugInfo(() -> "Sending message to mail server", new Object[0]);
            long l = System.currentTimeMillis();
            object = mimeMessage.getAllRecipients();
            this.transport.sendMessage((Message)mimeMessage, object);
            long l2 = System.currentTimeMillis();
            this.processTaskActor.addDebugInfo(() -> "Completed sending email in " + (l2 - l) + " milliseconds", new Object[0]);
            this.disconnectMailServer();
        }
        catch (AddressException addressException) {
            this.raiseFault("Invalid email address in from and/or replyTo", addressException);
            return;
        }
        catch (MessagingException messagingException) {
            this.raiseFault("Failed to generate email message", messagingException);
            return;
        }
        this.raiseComplete();
    }

    @Override
    public void suspend() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void resume() {
    }

    private InternetAddress[] getAddresses(Value<?> value2, String string) {
        ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
        if (value2.isMap()) {
            arrayList.add(this.getAddress(value2));
        } else if (value2.isList()) {
            value2.asList().forEach(value -> arrayList.add(this.getAddress((Value<?>)value)));
        } else if (value2.getValue() != null && value2.getValue() instanceof String) {
            arrayList.add(this.getAddress(value2));
        }
        this.processTaskActor.addDebugInfo(() -> "Field " + string + ": '" + arrayList.stream().map(InternetAddress::toString).collect(Collectors.joining("; ")) + "'", new Object[0]);
        return arrayList.toArray(new InternetAddress[arrayList.size()]);
    }

    private InternetAddress getAddress(Value<?> value) throws InvalidMailException {
        String string = "";
        String string2 = "";
        if (value.isMap()) {
            string = (String)value.asMap().raw("email");
            string2 = (String)value.asMap().raw("name");
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
        } else if (value.isPrimitive() && value instanceof StringValue) {
            string = (String)((StringValue)value).getValue();
        } else {
            throw new InvalidMailAddressException("Cannot extract an email address from an object of type " + value.getClass().getSimpleName());
        }
        if (string == null || string.isBlank()) {
            throw new InvalidMailAddressException("Missing email address in object of type " + value.getClass().getSimpleName());
        }
        try {
            InternetAddress internetAddress = new InternetAddress(string, string2);
            return internetAddress;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidMailAddressException("Invalid email address " + string + " " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private /* synthetic */ void lambda$start$9(Multipart multipart, Value value) {
        if (!value.isMap()) {
            this.processTaskActor.addDebugInfo(() -> "Attachment must be a json object with 'content' (base64 coded) and optional 'fileName' and 'mimeType'; found json content of type  " + value.getClass().getSimpleName(), new Object[0]);
            return;
        }
        String string = (String)value.asMap().raw("fileName");
        String string2 = (String)value.asMap().raw("content");
        String string3 = (String)value.asMap().raw("mimeType");
        if (string3 == null || string3.isBlank()) {
            string3 = "application/octet-stream";
        }
        if (string == null || string.isBlank()) {
            string = "";
        }
        if (string2 == null || string2.isBlank()) {
            this.processTaskActor.addDebugInfo(() -> "Attachment must be a json object with 'content' (base64 coded) and optional 'fileName' and 'mimeType'; skipping attachment, because 'content' is missing.", new Object[0]);
            return;
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(Base64.getDecoder().decode(string2), string3);
        try {
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
            mimeBodyPart.setFileName(string);
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            String string4 = string;
            this.processTaskActor.addDebugInfo(() -> "Added attachment '" + string4 + "' of length " + string2.length() + " bytes", new Object[0]);
        }
        catch (MessagingException messagingException) {
            throw new InvalidMailException("Cannot add attachment with file name '" + string + "'", messagingException);
        }
    }
}

