/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.json.StringValue;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.implementation.mail.AddressTemplate;
import org.cafienne.processtask.implementation.mail.AttachmentTemplate;
import org.cafienne.processtask.implementation.mail.BodyTemplate;
import org.cafienne.processtask.implementation.mail.Mail;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.cafienne.util.StringTemplate;
import org.w3c.dom.Element;

public class MailDefinition
extends SubProcessDefinition {
    private final StringTemplate subject;
    private final BodyTemplate body;
    private final List<AddressTemplate> toList = new ArrayList<AddressTemplate>();
    private final List<AddressTemplate> ccList = new ArrayList<AddressTemplate>();
    private final List<AddressTemplate> bccList = new ArrayList<AddressTemplate>();
    private final AddressTemplate from;
    private final AddressTemplate replyTo;
    private final List<AttachmentTemplate> attachmentList = new ArrayList<AttachmentTemplate>();

    public MailDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.subject = this.parseTemplate("subject", false);
        this.body = this.parse("mail-body", BodyTemplate.class, false);
        this.parseGrandChildren("to", "address", AddressTemplate.class, this.toList);
        this.parseGrandChildren("cc", "address", AddressTemplate.class, this.ccList);
        this.parseGrandChildren("bcc", "address", AddressTemplate.class, this.bccList);
        this.from = this.parse("from", AddressTemplate.class, false);
        this.replyTo = this.parse("reply-to", AddressTemplate.class, false);
        this.parseGrandChildren("attachments", "attachment", AttachmentTemplate.class, this.attachmentList);
    }

    @Override
    public Set<String> getRawOutputParameterNames() {
        return super.getExceptionParameterNames();
    }

    public Properties getMailProperties() {
        Properties properties = Cafienne.config().engine().mailService().asProperties();
        return properties;
    }

    public Mail createInstance(ProcessTaskActor processTaskActor) {
        return new Mail<MailDefinition>(processTaskActor, this);
    }

    public ValueMap convert(ValueMap valueMap) {
        ValueMap valueMap2 = valueMap.cloneValueNode();
        this.convertList(this.toList, valueMap, valueMap2, "to");
        this.convertList(this.ccList, valueMap, valueMap2, "cc");
        this.convertList(this.bccList, valueMap, valueMap2, "bcc");
        this.convertTemplate(this.from, valueMap, valueMap2, "from");
        this.convertTemplate(this.replyTo, valueMap, valueMap2, "replyTo");
        this.convertString(this.subject, valueMap, valueMap2, "subject");
        if (this.body != null) {
            valueMap2.put("body", this.body.resolve(valueMap));
        }
        if (!this.attachmentList.isEmpty()) {
            this.attachmentList.forEach(attachmentTemplate -> valueMap2.withArray("attachments").add(attachmentTemplate.resolve(valueMap)));
        }
        return valueMap2;
    }

    private void convertString(StringTemplate stringTemplate, ValueMap valueMap, ValueMap valueMap2, String string) {
        if (stringTemplate == null) {
            return;
        }
        valueMap2.put(string, new StringValue(stringTemplate.resolveParameters(valueMap).toString()));
    }

    private void convertList(List<AddressTemplate> list, ValueMap valueMap, ValueMap valueMap2, String string) {
        if (list.isEmpty()) {
            return;
        }
        ValueList valueList = valueMap2.withArray(string);
        this.toList.forEach(addressTemplate -> valueList.add(this.resolveAddress((AddressTemplate)addressTemplate, valueMap)));
    }

    private void convertTemplate(AddressTemplate addressTemplate, ValueMap valueMap, ValueMap valueMap2, String string) {
        if (addressTemplate == null) {
            return;
        }
        valueMap2.put(string, this.resolveAddress(addressTemplate, valueMap));
    }

    private ValueMap resolveAddress(AddressTemplate addressTemplate, ValueMap valueMap) {
        return new ValueMap("name", addressTemplate.getName(valueMap), "email", addressTemplate.getEmail(valueMap));
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

