/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import org.cafienne.cmmn.actorapi.event.CaseDefinitionApplied;
import org.cafienne.cmmn.actorapi.event.CaseEvent;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.definition.CaseDefinitionEvent;
import org.cafienne.cmmn.actorapi.event.migration.CaseDefinitionMigrated;
import org.cafienne.cmmn.instance.State;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.materializer.cases.file.CaseFileProjection;
import org.cafienne.querydb.record.CaseDefinitionRecord;
import org.cafienne.querydb.record.CaseRecord;
import org.cafienne.querydb.record.CaseRecord$;
import org.cafienne.querydb.record.CaseRoleRecord;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\n\u0015\u0001}A\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001BC\u0002\u0013\rQ\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001di\u0005\u00011A\u0005\n9Cq\u0001\u0017\u0001A\u0002\u0013%\u0011\f\u0003\u0004`\u0001\u0001\u0006Ka\u0014\u0005\bA\u0002\u0001\r\u0011\"\u0003b\u0011\u001d1\u0007\u00011A\u0005\n\u001dDa!\u001b\u0001!B\u0013\u0011\u0007\"\u00026\u0001\t\u0003Y\u0007bBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\tq1)Y:f!J|'.Z2uS>t'BA\u000b\u0017\u0003\u0015\u0019\u0017m]3t\u0015\t9\u0002$\u0001\u0007nCR,'/[1mSj,'O\u0003\u0002\u001a5\u00059\u0011/^3ss\u0012\u0014'BA\u000e\u001d\u0003!\u0019\u0017MZ5f]:,'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\nAb]2bY\u0006dwnZ4j]\u001eT!a\u000b\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011!L\u0001\u0004G>l\u0017BA\u0018)\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0017A,'o]5ti\u0016t7-\u001a\t\u0003eMj\u0011AF\u0005\u0003iY\u0011!CU3d_J$7\u000fU3sg&\u001cH/\u001a8dK\u0006\u00112-Y:f\r&dW\r\u0015:pU\u0016\u001cG/[8o!\t9$(D\u00019\u0015\tID#\u0001\u0003gS2,\u0017BA\u001e9\u0005I\u0019\u0015m]3GS2,\u0007K]8kK\u000e$\u0018n\u001c8\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u0013\u0013AC2p]\u000e,(O]3oi&\u00111\t\u0011\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q\u0019qi\u0013'\u0015\u0005!S\u0005CA%\u0001\u001b\u0005!\u0002\"\u0002\u001f\u0006\u0001\bq\u0004\"\u0002\u0019\u0006\u0001\u0004\t\u0004\"B\u001b\u0006\u0001\u00041\u0014\u0001D2bg\u0016Len\u001d;b]\u000e,W#A(\u0011\u0007\u0005\u0002&+\u0003\u0002RE\t1q\n\u001d;j_:\u0004\"a\u0015,\u000e\u0003QS!!\u0016\r\u0002\rI,7m\u001c:e\u0013\t9FK\u0001\u0006DCN,'+Z2pe\u0012\f\u0001cY1tK&s7\u000f^1oG\u0016|F%Z9\u0015\u0005ik\u0006CA\u0011\\\u0013\ta&E\u0001\u0003V]&$\bb\u00020\b\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0014!D2bg\u0016Len\u001d;b]\u000e,\u0007%\u0001\bdCN,G)\u001a4j]&$\u0018n\u001c8\u0016\u0003\t\u00042!\t)d!\t\u0019F-\u0003\u0002f)\n!2)Y:f\t\u00164\u0017N\\5uS>t'+Z2pe\u0012\f!cY1tK\u0012+g-\u001b8ji&|gn\u0018\u0013fcR\u0011!\f\u001b\u0005\b=*\t\t\u00111\u0001c\u0003=\u0019\u0017m]3EK\u001aLg.\u001b;j_:\u0004\u0013a\u00045b]\u0012dWmQ1tK\u00163XM\u001c;\u0015\u00051,\bcA n_&\u0011a\u000e\u0011\u0002\u0007\rV$XO]3\u0011\u0005A\u001cX\"A9\u000b\u0003I\fA!Y6lC&\u0011A/\u001d\u0002\u0005\t>tW\rC\u0003w\u0019\u0001\u0007q/A\u0003fm\u0016tG\u000f\u0005\u0002y}6\t\u0011P\u0003\u0002wu*\u00111\u0010`\u0001\tC\u000e$xN]1qS*\u0011QPG\u0001\u0005G6lg.\u0003\u0002\u0000s\nI1)Y:f\u000bZ,g\u000e^\u0001\u0013GJ,\u0017\r^3DCN,\u0017J\\:uC:\u001cW\rF\u0002m\u0003\u000bAaA^\u0007A\u0002\u0005\u001d\u0001c\u0001=\u0002\n%\u0019\u00111B=\u0003+\r\u000b7/\u001a#fM&t\u0017\u000e^5p]\u0006\u0003\b\u000f\\5fI\u0006YR\u000f]:feR\u001c\u0015m]3EK\u001aLg.\u001b;j_:\u0014VmY8sIN$2AWA\t\u0011\u00191h\u00021\u0001\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001ae\f!\u0002Z3gS:LG/[8o\u0013\u0011\ti\"a\u0006\u0003'\r\u000b7/\u001a#fM&t\u0017\u000e^5p]\u00163XM\u001c;\u0002+5LwM]1uK\u000e\u000b7/\u001a#fM&t\u0017\u000e^5p]R\u0019A.a\t\t\rY|\u0001\u0019AA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016s\u0006IQ.[4sCRLwN\\\u0005\u0005\u0003_\tIC\u0001\fDCN,G)\u001a4j]&$\u0018n\u001c8NS\u001e\u0014\u0018\r^3e\u0003I)\b\u000fZ1uK\u000e\u000b7/Z'pI&4\u0017.\u001a3\u0015\u00071\f)\u0004C\u0004\u00028A\u0001\r!!\u000f\u0002\u0007\u00154H\u000fE\u0002y\u0003wI1!!\u0010z\u00051\u0019\u0015m]3N_\u0012Lg-[3e\u0003A\u0019\u0007.\u00198hK\u000e\u000b7/\u001a*fG>\u0014H\rF\u0003m\u0003\u0007\n)\u0005C\u0003w#\u0001\u0007q\u000fC\u0004\u0002HE\u0001\r!!\u0013\u0002\u000f\rD\u0017M\\4feB)\u0011%a\u0013S%&\u0019\u0011Q\n\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!\u00049sKB\f'/Z\"p[6LG\u000fF\u0001[\u0001")
public class CaseProjection
implements LazyLogging {
    private final RecordsPersistence persistence;
    private final CaseFileProjection caseFileProjection;
    private final ExecutionContext executionContext;
    private Option<CaseRecord> caseInstance;
    private Option<CaseDefinitionRecord> caseDefinition;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseProjection caseProjection = this;
        synchronized (caseProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private Option<CaseRecord> caseInstance() {
        return this.caseInstance;
    }

    private void caseInstance_$eq(Option<CaseRecord> x$1) {
        this.caseInstance = x$1;
    }

    private Option<CaseDefinitionRecord> caseDefinition() {
        return this.caseDefinition;
    }

    private void caseDefinition_$eq(Option<CaseDefinitionRecord> x$1) {
        this.caseDefinition = x$1;
    }

    public Future<Done> handleCaseEvent(CaseEvent event) {
        Future<Done> future;
        CaseEvent caseEvent = event;
        if (caseEvent instanceof CaseDefinitionApplied) {
            CaseDefinitionApplied caseDefinitionApplied = (CaseDefinitionApplied)caseEvent;
            future = this.createCaseInstance(caseDefinitionApplied);
        } else if (caseEvent instanceof CaseDefinitionMigrated) {
            CaseDefinitionMigrated caseDefinitionMigrated = (CaseDefinitionMigrated)caseEvent;
            future = this.migrateCaseDefinition(caseDefinitionMigrated);
        } else if (caseEvent instanceof CaseModified) {
            CaseModified caseModified = (CaseModified)caseEvent;
            future = this.updateCaseModified(caseModified);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> createCaseInstance(CaseDefinitionApplied event) {
        this.upsertCaseDefinitionRecords(event);
        String x$1 = event.getCaseInstanceId();
        String x$2 = event.tenant;
        String x$3 = event.getRootCaseId();
        String x$4 = event.getParentCaseId();
        String x$5 = event.getCaseName();
        String x$6 = State.Active.toString();
        boolean x$7 = false;
        Instant x$8 = event.createdOn;
        String x$9 = event.createdBy;
        String x$10 = event.createdBy;
        Instant x$11 = event.createdOn;
        String x$12 = CaseRecord$.MODULE$.apply$default$12();
        String x$13 = CaseRecord$.MODULE$.apply$default$13();
        this.caseInstance_$eq((Option<CaseRecord>)new Some((Object)new CaseRecord(x$1, x$2, x$5, x$6, 0, x$4, x$3, x$8, x$9, x$11, x$10, x$12, x$13)));
        this.caseFileProjection.handleCaseCreation();
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private void upsertCaseDefinitionRecords(CaseDefinitionEvent event) {
        this.caseDefinition_$eq((Option<CaseDefinitionRecord>)new Some((Object)new CaseDefinitionRecord(event.getActorId(), event.getCaseName(), event.getDefinition().documentation.text, event.getDefinition().getId(), event.getDefinition().getDefinitionsDocument().getSource(), event.tenant, event.getTimestamp(), event.getUser().id())));
        Seq roles = CollectionConverters$.MODULE$.CollectionHasAsScala(event.getDefinition().getCaseTeamModel().getCaseRoles()).asScala().toSeq();
        roles.foreach((Function1 & Serializable)role -> {
            this.persistence.upsert(new CaseRoleRecord(event.getCaseInstanceId(), event.tenant, role.getName(), false));
            return BoxedUnit.UNIT;
        });
    }

    private Future<Done> migrateCaseDefinition(CaseDefinitionMigrated event) {
        this.persistence.removeCaseRoles(event.getCaseInstanceId());
        this.upsertCaseDefinitionRecords(event);
        return this.changeCaseRecord(event, (Function1<CaseRecord, CaseRecord>)(Function1 & Serializable)instance -> {
            String x$1 = event.getDefinition().getName();
            String x$2 = instance.copy$default$1();
            String x$3 = instance.copy$default$2();
            String x$4 = instance.copy$default$4();
            int x$5 = instance.copy$default$5();
            String x$6 = instance.copy$default$6();
            String x$7 = instance.copy$default$7();
            Instant x$8 = instance.copy$default$8();
            String x$9 = instance.copy$default$9();
            Instant x$10 = instance.copy$default$10();
            String x$11 = instance.copy$default$11();
            String x$12 = instance.copy$default$12();
            String x$13 = instance.copy$default$13();
            return instance.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        });
    }

    private Future<Done> updateCaseModified(CaseModified evt) {
        this.caseDefinition().foreach((Function1 & Serializable)definition -> {
            CaseProjection.$anonfun$updateCaseModified$1(this, evt, definition);
            return BoxedUnit.UNIT;
        });
        return this.changeCaseRecord(evt, (Function1<CaseRecord, CaseRecord>)(Function1 & Serializable)instance -> {
            Instant x$9 = evt$1.lastModified;
            String x$10 = evt.getUser().id();
            int x$11 = evt.getNumFailures();
            String x$12 = evt.getState().toString();
            String x$13 = instance.copy$default$1();
            String x$14 = instance.copy$default$2();
            String x$15 = instance.copy$default$3();
            String x$16 = instance.copy$default$6();
            String x$17 = instance.copy$default$7();
            Instant x$18 = instance.copy$default$10();
            String x$19 = instance.copy$default$11();
            String x$20 = instance.copy$default$12();
            String x$21 = instance.copy$default$13();
            return instance.copy(x$13, x$14, x$15, x$12, x$11, x$16, x$17, x$9, x$10, x$18, x$19, x$20, x$21);
        });
    }

    private Future<Done> changeCaseRecord(CaseEvent event, Function1<CaseRecord, CaseRecord> changer) {
        Future future;
        String caseInstanceId = event.getCaseInstanceId();
        Option<CaseRecord> option = this.caseInstance();
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving Case[{}] from database", (Object)caseInstanceId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getCaseInstance(caseInstanceId).map((Function1 & Serializable)x0$1 -> {
                Done$ done$;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CaseRecord instance = (CaseRecord)some.value();
                    this.caseInstance_$eq((Option<CaseRecord>)new Some(changer.apply((Object)instance)));
                    done$ = Done$.MODULE$;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Cannot find Case[" + caseInstanceId + "] in database to handle " + event.getClass().getName() + ":\n\n" + event.toString() + "\n\n");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    done$ = Done$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                return done$;
            }, this.executionContext());
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            CaseRecord instance = (CaseRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Found Case[{}] in current transaction cache", (Object)caseInstanceId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.caseInstance_$eq((Option<CaseRecord>)new Some(changer.apply((Object)instance)));
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    public void prepareCommit() {
        this.caseInstance().foreach((Function1 & Serializable)instance -> {
            this.persistence.upsert(instance);
            return BoxedUnit.UNIT;
        });
        this.caseDefinition().foreach((Function1 & Serializable)instance -> {
            this.persistence.upsert(instance);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateCaseModified$1(CaseProjection $this, CaseModified evt$1, CaseDefinitionRecord definition) {
        Instant x$1 = evt$1.lastModified;
        String x$2 = definition.copy$default$1();
        String x$3 = definition.copy$default$2();
        String x$4 = definition.copy$default$3();
        String x$5 = definition.copy$default$4();
        String x$6 = definition.copy$default$5();
        String x$7 = definition.copy$default$6();
        String x$8 = definition.copy$default$8();
        $this.caseDefinition_$eq((Option<CaseDefinitionRecord>)new Some((Object)definition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8)));
    }

    public CaseProjection(RecordsPersistence persistence, CaseFileProjection caseFileProjection, ExecutionContext executionContext) {
        this.persistence = persistence;
        this.caseFileProjection = caseFileProjection;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.caseInstance = None$.MODULE$;
        this.caseDefinition = None$.MODULE$;
    }
}

