/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.CaseEvent;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.file.CaseFileEvent;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamEvent;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.OffsetRecord;
import org.cafienne.infrastructure.cqrs.OffsetRecord$;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.materializer.cases.CaseEventSink$;
import org.cafienne.querydb.materializer.cases.CaseProjection;
import org.cafienne.querydb.materializer.cases.CaseReader$;
import org.cafienne.querydb.materializer.cases.file.CaseFileProjection;
import org.cafienne.querydb.materializer.cases.plan.CasePlanProjection;
import org.cafienne.querydb.materializer.cases.team.CaseTeamProjection;
import org.cafienne.querydb.materializer.slick.SlickTransaction;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\n\u0014\u0001yA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005m!A!\t\u0001B\u0001B\u0003%1\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0004O\u0001\t\u0007I\u0011B(\t\rY\u0003\u0001\u0015!\u0003Q\u0011\u001d9\u0006A1A\u0005\naCaa\u0018\u0001!\u0002\u0013I\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011\u00022\t\u000f%\u0004!\u0019!C\u0005U\"1a\u000e\u0001Q\u0001\n-DQa\u001c\u0001\u0005\u0002ADq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011\u0011\r\u0001\u0005\n\u0005\r$aD\"bg\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005Q)\u0012!B2bg\u0016\u001c(B\u0001\f\u0018\u00031i\u0017\r^3sS\u0006d\u0017N_3s\u0015\tA\u0012$A\u0004rk\u0016\u0014\u0018\u0010\u001a2\u000b\u0005iY\u0012\u0001C2bM&,gN\\3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0010&WA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\u000b\u0002\u000bMd\u0017nY6\n\u0005):#\u0001E*mS\u000e\\GK]1og\u0006\u001cG/[8o!\ta3'D\u0001.\u0015\tqs&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00021c\u0005AA/\u001f9fg\u00064WMC\u00013\u0003\r\u0019w.\\\u0005\u0003i5\u00121\u0002T1{s2{wmZ5oO\u0006q1-Y:f\u0013:\u001cH/\u00198dK&#\u0007CA\u001c?\u001d\tAD\b\u0005\u0002:C5\t!H\u0003\u0002<;\u00051AH]8pizJ!!P\u0011\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{\u0005\na\u0001^3oC:$\u0018a\u00039feNL7\u000f^3oG\u0016\u0004\"\u0001R#\u000e\u0003UI!AR\u000b\u0003%I+7m\u001c:egB+'o]5ti\u0016t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%[E*\u0014\t\u0003\u0015\u0002i\u0011a\u0005\u0005\u0006k\u0011\u0001\rA\u000e\u0005\u0006\u0003\u0012\u0001\rA\u000e\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0013G\u0006\u001cX\rV3b[B\u0013xN[3di&|g.F\u0001Q!\t\tF+D\u0001S\u0015\t\u00196#\u0001\u0003uK\u0006l\u0017BA+S\u0005I\u0019\u0015m]3UK\u0006l\u0007K]8kK\u000e$\u0018n\u001c8\u0002'\r\f7/\u001a+fC6\u0004&o\u001c6fGRLwN\u001c\u0011\u0002%\r\f7/\u001a$jY\u0016\u0004&o\u001c6fGRLwN\\\u000b\u00023B\u0011!,X\u0007\u00027*\u0011AlE\u0001\u0005M&dW-\u0003\u0002_7\n\u00112)Y:f\r&dW\r\u0015:pU\u0016\u001cG/[8o\u0003M\u0019\u0017m]3GS2,\u0007K]8kK\u000e$\u0018n\u001c8!\u0003I\u0019\u0017m]3QY\u0006t\u0007K]8kK\u000e$\u0018n\u001c8\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!Z\n\u0002\tAd\u0017M\\\u0005\u0003O\u0012\u0014!cQ1tKBc\u0017M\u001c)s_*,7\r^5p]\u0006\u00192-Y:f!2\fg\u000e\u0015:pU\u0016\u001cG/[8oA\u0005q1-Y:f!J|'.Z2uS>tW#A6\u0011\u0005)c\u0017BA7\u0014\u00059\u0019\u0015m]3Qe>TWm\u0019;j_:\fqbY1tKB\u0013xN[3di&|g\u000eI\u0001\u0013GJ,\u0017\r^3PM\u001a\u001cX\r\u001e*fG>\u0014H\r\u0006\u0002rsB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005GF\u00148O\u0003\u0002w3\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017B\u0001=t\u00051yeMZ:fiJ+7m\u001c:e\u0011\u0015QX\u00021\u0001|\u0003\u0019ygMZ:fiB\u0019A0!\u0002\u000e\u0003uT!A`@\u0002\u000bE,XM]=\u000b\u0007\t\u000b\tA\u0003\u0002\u0002\u0004\u0005!\u0011m[6b\u0013\r\t9! \u0002\u0007\u001f\u001a47/\u001a;\u0002\u0017!\fg\u000e\u001a7f\u000bZ,g\u000e\u001e\u000b\u0005\u0003\u001b\t\t\u0003\u0005\u0004\u0002\u0010\u0005U\u0011\u0011D\u0007\u0003\u0003#Q1!a\u0005\"\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003/\t\tB\u0001\u0004GkR,(/\u001a\t\u0005\u00037\ti\"\u0004\u0002\u0002\u0002%!\u0011qDA\u0001\u0005\u0011!uN\\3\t\u000f\u0005\rb\u00021\u0001\u0002&\u0005AQM\u001c<fY>\u0004X\rE\u0002s\u0003OI1!!\u000bt\u0005Iiu\u000eZ3m\u000bZ,g\u000e^#om\u0016dw\u000e]3\u0002\r\r|W.\\5u)\u0019\ti!a\f\u00022!9\u00111E\bA\u0002\u0005\u0015\u0002bBA\u001a\u001f\u0001\u0007\u0011QG\u0001\u0011iJ\fgn]1di&|g.\u0012<f]R\u0004B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0003fm\u0016tGOC\u0002\u0002@e\t!\"Y2u_Jlw\u000eZ3m\u0013\u0011\t\u0019%!\u000f\u0003\u0017\r{W.\\5u\u000bZ,g\u000e^\u0001\u0012G>lW.\u001b;DCN,'+Z2pe\u0012\u001cHCBA\u0007\u0003\u0013\nY\u0005C\u0004\u0002$A\u0001\r!!\n\t\u000f\u00055\u0003\u00031\u0001\u0002P\u0005a1-Y:f\u001b>$\u0017NZ5fIB!\u0011\u0011KA/\u001b\t\t\u0019F\u0003\u0003\u0002<\u0005U#\u0002BA,\u00033\n\u0001\"Y2u_J\f\u0007/\u001b\u0006\u0004\u00037J\u0012\u0001B2n[:LA!a\u0018\u0002T\ta1)Y:f\u001b>$\u0017NZ5fI\u0006iQ\u000f\u001d3bi\u0016,6/\u001a:JIN$b!!\u0004\u0002f\u00055\u0004bBA\u001e#\u0001\u0007\u0011q\r\t\u0005\u0003#\nI'\u0003\u0003\u0002l\u0005M#!G\"bg\u0016\f\u0005\u000f\u001d7jK\u0012\u0004F.\u0019;g_JlW\u000b\u001d3bi\u0016Dq!a\t\u0012\u0001\u0004\t)\u0003")
public class CaseTransaction
implements SlickTransaction {
    private final String caseInstanceId;
    private final RecordsPersistence persistence;
    private final CaseTeamProjection caseTeamProjection;
    private final CaseFileProjection caseFileProjection;
    private final CasePlanProjection casePlanProjection;
    private final CaseProjection caseProjection;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseTransaction caseTransaction = this;
        synchronized (caseTransaction) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private CaseTeamProjection caseTeamProjection() {
        return this.caseTeamProjection;
    }

    private CaseFileProjection caseFileProjection() {
        return this.caseFileProjection;
    }

    private CasePlanProjection casePlanProjection() {
        return this.casePlanProjection;
    }

    private CaseProjection caseProjection() {
        return this.caseProjection;
    }

    public OffsetRecord createOffsetRecord(Offset offset) {
        return OffsetRecord$.MODULE$.apply(CaseEventSink$.MODULE$.offsetName(), offset);
    }

    @Override
    public Future<Done> handleEvent(ModelEventEnvelope envelope) {
        Future<Done> future;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Handling event of type " + envelope.event().getClass().getSimpleName() + " in case " + this.caseInstanceId);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ModelEvent modelEvent = envelope.event();
        if (modelEvent instanceof CasePlanEvent) {
            CasePlanEvent casePlanEvent = (CasePlanEvent)modelEvent;
            future = this.casePlanProjection().handleCasePlanEvent(casePlanEvent);
        } else if (modelEvent instanceof CaseFileEvent) {
            CaseFileEvent caseFileEvent = (CaseFileEvent)modelEvent;
            future = this.caseFileProjection().handleCaseFileEvent(caseFileEvent);
        } else if (modelEvent instanceof CaseTeamEvent) {
            CaseTeamEvent caseTeamEvent = (CaseTeamEvent)modelEvent;
            future = this.caseTeamProjection().handleCaseTeamEvent(caseTeamEvent);
        } else if (modelEvent instanceof CaseEvent) {
            CaseEvent caseEvent = (CaseEvent)modelEvent;
            future = this.caseProjection().handleCaseEvent(caseEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    @Override
    public Future<Done> commit(ModelEventEnvelope envelope, CommitEvent transactionEvent) {
        Future future;
        CommitEvent commitEvent = transactionEvent;
        if (commitEvent instanceof CaseModified) {
            CaseModified caseModified = (CaseModified)commitEvent;
            future = this.commitCaseRecords(envelope, caseModified);
        } else if (commitEvent instanceof CaseAppliedPlatformUpdate) {
            CaseAppliedPlatformUpdate caseAppliedPlatformUpdate = (CaseAppliedPlatformUpdate)commitEvent;
            future = this.updateUserIds(caseAppliedPlatformUpdate, envelope);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("CaseTransaction unexpectedly receives a commit event of type {}. This event is ignored.", (Object)transactionEvent.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> commitCaseRecords(ModelEventEnvelope envelope, CaseModified caseModified) {
        this.caseProjection().prepareCommit();
        this.caseTeamProjection().prepareCommit();
        this.caseFileProjection().prepareCommit();
        this.casePlanProjection().prepareCommit(caseModified);
        this.persistence.upsert(this.createOffsetRecord(envelope.offset()));
        return this.persistence.commit().andThen((PartialFunction)new Serializable(null, caseModified){
            private static final long serialVersionUID = 0L;
            private final CaseModified caseModified$1;

            public final <A1 extends Try<Done>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                A1 A1 = x$1;
                CaseReader$.MODULE$.lastModifiedRegistration().handle(this.caseModified$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Try<Done> x$1) {
                Try<Done> try_ = x$1;
                boolean bl = true;
                return bl;
            }
            {
                this.caseModified$1 = caseModified$1;
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Done> updateUserIds(CaseAppliedPlatformUpdate event, ModelEventEnvelope envelope) {
        return this.persistence.updateCaseUserInformation(event.getCaseInstanceId(), event.newUserInformation.info(), this.createOffsetRecord(envelope.offset()));
    }

    public CaseTransaction(String caseInstanceId, String tenant, RecordsPersistence persistence) {
        this.caseInstanceId = caseInstanceId;
        this.persistence = persistence;
        LazyLogging.$init$((LazyLogging)this);
        this.caseTeamProjection = new CaseTeamProjection(persistence, ExecutionContext.Implicits$.MODULE$.global());
        this.caseFileProjection = new CaseFileProjection(persistence, caseInstanceId, tenant, ExecutionContext.Implicits$.MODULE$.global());
        this.casePlanProjection = new CasePlanProjection(persistence, ExecutionContext.Implicits$.MODULE$.global());
        this.caseProjection = new CaseProjection(persistence, this.caseFileProjection(), ExecutionContext.Implicits$.MODULE$.global());
    }
}

