/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.file;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierCleared;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierEvent;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierSet;
import org.cafienne.cmmn.actorapi.event.file.CaseFileEvent;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.actorapi.event.migration.CaseFileItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.CaseFileItemMigrated;
import org.cafienne.json.JSONReader;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.materializer.cases.file.CaseFileEventBuffer;
import org.cafienne.querydb.materializer.cases.file.CaseFileMerger$;
import org.cafienne.querydb.materializer.cases.file.CaseIdentifierMerger$;
import org.cafienne.querydb.record.CaseBusinessIdentifierRecord;
import org.cafienne.querydb.record.CaseFileRecord;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\f\u0019\u0001\u0015B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\t\u0001B\u0001B\u0003%A\b\u0003\u0005I\u0001\t\u0015\r\u0011b\u0001J\u0011!\u0001\u0006A!A!\u0002\u0013Q\u0005\"B)\u0001\t\u0003\u0011\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007U\u0002\u0001\u000b\u0011\u0002/\t\u000f-\u0004!\u0019!C\u0005Y\"1\u0001\u000f\u0001Q\u0001\n5Dq!\u001d\u0001A\u0002\u0013%!\u000fC\u0004}\u0001\u0001\u0007I\u0011B?\t\u000f\u0005\u001d\u0001\u0001)Q\u0005g\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003w\u0001A\u0011BA\u001f\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005-\u0001bBA>\u0001\u0011%\u0011Q\u0010\u0002\u0013\u0007\u0006\u001cXMR5mKB\u0013xN[3di&|gN\u0003\u0002\u001a5\u0005!a-\u001b7f\u0015\tYB$A\u0003dCN,7O\u0003\u0002\u001e=\u0005aQ.\u0019;fe&\fG.\u001b>fe*\u0011q\u0004I\u0001\bcV,'/\u001f3c\u0015\t\t#%\u0001\u0005dC\u001aLWM\u001c8f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011c\u0001\u0001'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005E\u0012\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003M\n1aY8n\u0013\t)dFA\u0006MCjLHj\\4hS:<\u0017a\u00039feNL7\u000f^3oG\u0016\u0004\"\u0001O\u001d\u000e\u0003qI!A\u000f\u000f\u0003%I+7m\u001c:egB+'o]5ti\u0016t7-Z\u0001\u000fG\u0006\u001cX-\u00138ti\u0006t7-Z%e!\tiDI\u0004\u0002?\u0005B\u0011q\bK\u0007\u0002\u0001*\u0011\u0011\tJ\u0001\u0007yI|w\u000e\u001e \n\u0005\rC\u0013A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\u0015\u0002\rQ,g.\u00198u\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001K!\tYe*D\u0001M\u0015\ti\u0005&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0014'\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u00051A(\u001b8jiz\"BaU,Y3R\u0011AK\u0016\t\u0003+\u0002i\u0011\u0001\u0007\u0005\u0006\u0011\u001a\u0001\u001dA\u0013\u0005\u0006m\u0019\u0001\ra\u000e\u0005\u0006w\u0019\u0001\r\u0001\u0010\u0005\u0006\u000f\u001a\u0001\r\u0001P\u0001\u0014EV\u001c\u0018N\\3tg&#WM\u001c;jM&,'o]\u000b\u00029B\u0019QL\u00193\u000e\u0003yS!a\u00181\u0002\u000f5,H/\u00192mK*\u0011\u0011\rK\u0001\u000bG>dG.Z2uS>t\u0017BA2_\u0005\r\u0019V\r\u001e\t\u0003K\"l\u0011A\u001a\u0006\u0003Oz\taA]3d_J$\u0017BA5g\u0005q\u0019\u0015m]3CkNLg.Z:t\u0013\u0012,g\u000e^5gS\u0016\u0014(+Z2pe\u0012\fACY;tS:,7o]%eK:$\u0018NZ5feN\u0004\u0013A\u00062vM\u001a,'/\u001a3DCN,g)\u001b7f\u000bZ,g\u000e^:\u0016\u00035\u0004\"!\u00168\n\u0005=D\"aE\"bg\u00164\u0015\u000e\\3Fm\u0016tGOQ;gM\u0016\u0014\u0018a\u00062vM\u001a,'/\u001a3DCN,g)\u001b7f\u000bZ,g\u000e^:!\u0003!\u0019\u0017m]3GS2,W#A:\u0011\u0007\u001d\"h/\u0003\u0002vQ\t1q\n\u001d;j_:\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0011\u0002\t)\u001cxN\\\u0005\u0003wb\u0014\u0001BV1mk\u0016l\u0015\r]\u0001\rG\u0006\u001cXMR5mK~#S-\u001d\u000b\u0004}\u0006\r\u0001CA\u0014\u0000\u0013\r\t\t\u0001\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u00061\t\t\u00111\u0001t\u0003\rAH%M\u0001\nG\u0006\u001cXMR5mK\u0002\n!\u0003[1oI2,7)Y:f\u0007J,\u0017\r^5p]R\ta0A\niC:$G.Z\"bg\u00164\u0015\u000e\\3Fm\u0016tG\u000f\u0006\u0003\u0002\u0012\u0005\r\u0002#B&\u0002\u0014\u0005]\u0011bAA\u000b\u0019\n1a)\u001e;ve\u0016\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0003\u0003;\tA!Y6lC&!\u0011\u0011EA\u000e\u0005\u0011!uN\\3\t\u000f\u0005\u0015r\u00021\u0001\u0002(\u0005)QM^3oiB!\u0011\u0011FA\u001c\u001b\t\tYCC\u0002\u001a\u0003[QA!!\n\u00020)!\u0011\u0011GA\u001a\u0003!\t7\r^8sCBL'bAA\u001bA\u0005!1-\\7o\u0013\u0011\tI$a\u000b\u0003\u001b\r\u000b7/\u001a$jY\u0016,e/\u001a8u\u0003uA\u0017M\u001c3mK\n+8/\u001b8fgNLE-\u001a8uS\u001aLWM]#wK:$H\u0003BA\t\u0003\u007fAq!!\n\u0011\u0001\u0004\t\t\u0005\u0005\u0003\u0002*\u0005\r\u0013\u0002BA#\u0003W\u0011qCQ;tS:,7o]%eK:$\u0018NZ5fe\u00163XM\u001c;\u0002/!\fg\u000e\u001a7f\u0007\u0006\u001cXMR5mK&#X-\\#wK:$H\u0003BA\t\u0003\u0017Bq!!\n\u0012\u0001\u0004\ti\u0005\u0005\u0003\u0002*\u0005=\u0013\u0002BA)\u0003W\u0011\u0001dQ1tK\u001aKG.Z%uK6$&/\u00198tSRLwN\\3e\u0003]A\u0017M\u001c3mK\u000e\u000b7/\u001a$jY\u0016l\u0015n\u001a:bi&|g\u000e\u0006\u0003\u0002\u0012\u0005]\u0003bBA\u0013%\u0001\u0007\u0011\u0011\f\t\u0005\u00037\n\t'\u0004\u0002\u0002^)!\u0011qLA\u0017\u0003%i\u0017n\u001a:bi&|g.\u0003\u0003\u0002d\u0005u#\u0001F\"bg\u00164\u0015\u000e\\3Ji\u0016lW*[4sCR,G-A\u000biC:$G.Z\"bg\u00164\u0015\u000e\\3Ee>\u0004\b/\u001a3\u0015\t\u0005E\u0011\u0011\u000e\u0005\b\u0003K\u0019\u0002\u0019AA6!\u0011\tY&!\u001c\n\t\u0005=\u0014Q\f\u0002\u0014\u0007\u0006\u001cXMR5mK&#X-\u001c#s_B\u0004X\rZ\u0001\fO\u0016$8)Y:f\r&dW\r\u0006\u0003\u0002v\u0005]\u0004\u0003B&\u0002\u0014YDQa\u000f\u000bA\u0002q\nQ\u0002\u001d:fa\u0006\u0014XmQ8n[&$\u0018AE4fiV\u0003H-\u0019;fI\u000e\u000b7/\u001a$jY\u0016$B!a \u0002\u0006B\u0019Q-!!\n\u0007\u0005\reM\u0001\bDCN,g)\u001b7f%\u0016\u001cwN\u001d3\t\r\u0005\u001de\u00031\u0001w\u0003I\u0019\u0017m]3GS2,\u0017J\u001c)s_\u001e\u0014Xm]:")
public class CaseFileProjection
implements LazyLogging {
    private final RecordsPersistence persistence;
    private final String caseInstanceId;
    private final String tenant;
    private final ExecutionContext executionContext;
    private final Set<CaseBusinessIdentifierRecord> businessIdentifiers;
    private final CaseFileEventBuffer bufferedCaseFileEvents;
    private Option<ValueMap> caseFile;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseFileProjection caseFileProjection = this;
        synchronized (caseFileProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private Set<CaseBusinessIdentifierRecord> businessIdentifiers() {
        return this.businessIdentifiers;
    }

    private CaseFileEventBuffer bufferedCaseFileEvents() {
        return this.bufferedCaseFileEvents;
    }

    private Option<ValueMap> caseFile() {
        return this.caseFile;
    }

    private void caseFile_$eq(Option<ValueMap> x$1) {
        this.caseFile = x$1;
    }

    public void handleCaseCreation() {
        this.caseFile_$eq((Option<ValueMap>)new Some((Object)new ValueMap()));
    }

    public Future<Done> handleCaseFileEvent(CaseFileEvent event) {
        Future<Done> future;
        CaseFileEvent caseFileEvent = event;
        if (caseFileEvent instanceof CaseFileItemTransitioned) {
            CaseFileItemTransitioned caseFileItemTransitioned = (CaseFileItemTransitioned)caseFileEvent;
            future = this.handleCaseFileItemEvent(caseFileItemTransitioned);
        } else if (caseFileEvent instanceof BusinessIdentifierEvent) {
            BusinessIdentifierEvent businessIdentifierEvent = (BusinessIdentifierEvent)caseFileEvent;
            future = this.handleBusinessIdentifierEvent(businessIdentifierEvent);
        } else if (caseFileEvent instanceof CaseFileItemMigrated) {
            CaseFileItemMigrated caseFileItemMigrated = (CaseFileItemMigrated)caseFileEvent;
            future = this.handleCaseFileMigration(caseFileItemMigrated);
        } else if (caseFileEvent instanceof CaseFileItemDropped) {
            CaseFileItemDropped caseFileItemDropped = (CaseFileItemDropped)caseFileEvent;
            future = this.handleCaseFileDropped(caseFileItemDropped);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> handleBusinessIdentifierEvent(BusinessIdentifierEvent event) {
        Object object;
        BusinessIdentifierEvent businessIdentifierEvent = event;
        if (businessIdentifierEvent instanceof BusinessIdentifierSet) {
            BusinessIdentifierSet businessIdentifierSet = (BusinessIdentifierSet)businessIdentifierEvent;
            object = BoxesRunTime.boxToBoolean((boolean)this.businessIdentifiers().add((Object)CaseIdentifierMerger$.MODULE$.merge(businessIdentifierSet)));
        } else if (businessIdentifierEvent instanceof BusinessIdentifierCleared) {
            BusinessIdentifierCleared businessIdentifierCleared = (BusinessIdentifierCleared)businessIdentifierEvent;
            object = BoxesRunTime.boxToBoolean((boolean)this.businessIdentifiers().add((Object)CaseIdentifierMerger$.MODULE$.merge(businessIdentifierCleared)));
        } else {
            object = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleCaseFileItemEvent(CaseFileItemTransitioned event) {
        this.bufferedCaseFileEvents().addEvent(event);
        return this.getCaseFile(this.caseInstanceId).map((Function1 & Serializable)x$1 -> Done$.MODULE$, this.executionContext());
    }

    private Future<Done> handleCaseFileMigration(CaseFileItemMigrated event) {
        this.getCaseFile(this.caseInstanceId).map((Function1 & Serializable)json -> {
            ValueMap parent = event$1.formerPath.resolveParent((ValueMap)json);
            parent.put(event$1.path.name, parent.get(event$1.formerPath.name));
            return (Value)((Map)parent.getValue()).remove(event$1.formerPath.name);
        }, this.executionContext());
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleCaseFileDropped(CaseFileItemDropped event) {
        this.getCaseFile(this.caseInstanceId).map((Function1 & Serializable)json -> {
            ValueMap parent = event$2.path.resolveParent((ValueMap)json);
            return (Value)((Map)parent.getValue()).remove(event$2.path.name);
        }, this.executionContext());
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<ValueMap> getCaseFile(String caseInstanceId) {
        Future future;
        if (this.caseFile().isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving casefile caseInstanceId={} from database", (Object)caseInstanceId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getCaseFile(caseInstanceId).map((Function1 & Serializable)x0$1 -> {
                ValueMap valueMap;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CaseFileRecord record = (CaseFileRecord)some.value();
                    valueMap = (ValueMap)JSONReader.parse(record.data());
                } else if (None$.MODULE$.equals(option)) {
                    valueMap = new ValueMap();
                } else {
                    throw new MatchError((Object)option);
                }
                return valueMap;
            }, this.executionContext()).map((Function1 & Serializable)data -> {
                this.caseFile_$eq((Option<ValueMap>)new Some(data));
                return data;
            }, this.executionContext());
        } else {
            future = Future$.MODULE$.successful(this.caseFile().get());
        }
        return future;
    }

    public void prepareCommit() {
        this.caseFile().map((Function1 & Serializable)caseFileInProgress -> this.getUpdatedCaseFile((ValueMap)caseFileInProgress)).foreach((Function1 & Serializable)caseFile -> {
            this.persistence.upsert(caseFile);
            return BoxedUnit.UNIT;
        });
        this.businessIdentifiers().toSeq().foreach((Function1 & Serializable)item -> {
            this.persistence.upsert(item);
            return BoxedUnit.UNIT;
        });
    }

    private CaseFileRecord getUpdatedCaseFile(ValueMap caseFileInProgress) {
        this.bufferedCaseFileEvents().events().forEach(event -> CaseFileMerger$.MODULE$.merge((CaseFileItemTransitioned)event, caseFileInProgress));
        return new CaseFileRecord(this.caseInstanceId, this.tenant, caseFileInProgress.toString());
    }

    public CaseFileProjection(RecordsPersistence persistence, String caseInstanceId, String tenant, ExecutionContext executionContext) {
        this.persistence = persistence;
        this.caseInstanceId = caseInstanceId;
        this.tenant = tenant;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.businessIdentifiers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.bufferedCaseFileEvents = new CaseFileEventBuffer();
        this.caseFile = None$.MODULE$;
    }
}

