/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.plan;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemMigrated;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.actorapi.event.plan.RepetitionRuleEvaluated;
import org.cafienne.cmmn.actorapi.event.plan.RequiredRuleEvaluated;
import org.cafienne.humantask.actorapi.event.HumanTaskActivated;
import org.cafienne.humantask.actorapi.event.HumanTaskAssigned;
import org.cafienne.humantask.actorapi.event.HumanTaskCompleted;
import org.cafienne.humantask.actorapi.event.HumanTaskCreated;
import org.cafienne.humantask.actorapi.event.HumanTaskDueDateFilled;
import org.cafienne.humantask.actorapi.event.HumanTaskEvent;
import org.cafienne.humantask.actorapi.event.HumanTaskInputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOutputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOwnerChanged;
import org.cafienne.humantask.actorapi.event.HumanTaskTerminated;
import org.cafienne.humantask.actorapi.event.HumanTaskTransitioned;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskDropped;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskMigrated;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.materializer.cases.plan.PlanItemHistoryMerger$;
import org.cafienne.querydb.materializer.cases.plan.PlanItemMerger$;
import org.cafienne.querydb.materializer.cases.plan.TaskMerger$;
import org.cafienne.querydb.record.PlanItemHistoryRecord;
import org.cafienne.querydb.record.PlanItemRecord;
import org.cafienne.querydb.record.TaskRecord;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\n\u0015\u0001\u0005B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011)\u0019!C\u0002q!Aq\b\u0001B\u0001B\u0003%\u0011\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0004H\u0001\t\u0007I\u0011\u0002%\t\r\t\u0004\u0001\u0015!\u0003J\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007e\u0002\u0001\u000b\u0011\u00028\t\u000bM\u0004A\u0011\u0001;\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002\u0006\u0002!\t!a\"\u0003%\r\u000b7/\u001a)mC:\u0004&o\u001c6fGRLwN\u001c\u0006\u0003+Y\tA\u0001\u001d7b]*\u0011q\u0003G\u0001\u0006G\u0006\u001cXm\u001d\u0006\u00033i\tA\"\\1uKJL\u0017\r\\5{KJT!a\u0007\u000f\u0002\u000fE,XM]=eE*\u0011QDH\u0001\tG\u00064\u0017.\u001a8oK*\tq$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u00151\u001b\u0005Q#BA\u0016-\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tic&\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0013aA2p[&\u0011\u0011G\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001\u001b6\u001b\u0005A\u0012B\u0001\u001c\u0019\u0005I\u0011VmY8sIN\u0004VM]:jgR,gnY3\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q\"\u0013AC2p]\u000e,(O]3oi&\u0011ah\u000f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q\u0011!I\u0012\u000b\u0003\u0007\u0016\u0003\"\u0001\u0012\u0001\u000e\u0003QAQa\u000e\u0003A\u0004eBQA\r\u0003A\u0002M\n\u0011\u0002\u001d7b]&#X-\\:\u0016\u0003%\u0003BAS(R96\t1J\u0003\u0002M\u001b\u00069Q.\u001e;bE2,'B\u0001(%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003!.\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002S3:\u00111k\u0016\t\u0003)\u0012j\u0011!\u0016\u0006\u0003-\u0002\na\u0001\u0010:p_Rt\u0014B\u0001-%\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a#\u0003CA/a\u001b\u0005q&BA0\u001b\u0003\u0019\u0011XmY8sI&\u0011\u0011M\u0018\u0002\u000f!2\fg.\u0013;f[J+7m\u001c:e\u0003)\u0001H.\u00198Ji\u0016l7\u000fI\u0001\u0011a2\fg.\u0013;f[ND\u0015n\u001d;pef,\u0012!\u001a\t\u0004\u0015\u001aD\u0017BA4L\u0005\u0019\u0011UO\u001a4feB\u0011Q,[\u0005\u0003Uz\u0013Q\u0003\u00157b]&#X-\u001c%jgR|'/\u001f*fG>\u0014H-A\tqY\u0006t\u0017\n^3ng\"K7\u000f^8ss\u0002\nQ\u0001^1tWN,\u0012A\u001c\t\u0005\u0015>\u000bv\u000e\u0005\u0002^a&\u0011\u0011O\u0018\u0002\u000b)\u0006\u001c8NU3d_J$\u0017A\u0002;bg.\u001c\b%A\niC:$G.Z\"bg\u0016\u0004F.\u00198Fm\u0016tG\u000f\u0006\u0002v}B\u0019!H\u001e=\n\u0005]\\$A\u0002$viV\u0014X\r\u0005\u0002zy6\t!PC\u0001|\u0003\u0011\t7n[1\n\u0005uT(\u0001\u0002#p]\u0016Daa`\u0006A\u0002\u0005\u0005\u0011!B3wK:$\b\u0007BA\u0002\u00037\u0001b!!\u0002\u0002\u0014\u0005]QBAA\u0004\u0015\r)\u0012\u0011\u0002\u0006\u0004\u007f\u0006-!\u0002BA\u0007\u0003\u001f\t\u0001\"Y2u_J\f\u0007/\u001b\u0006\u0004\u0003#a\u0012\u0001B2n[:LA!!\u0006\u0002\b\ti1)Y:f!2\fg.\u0012<f]R\u0004B!!\u0007\u0002\u001c1\u0001AaCA\u000f}\u0006\u0005\t\u0011!B\u0001\u0003?\u00111a\u0018\u00132#\u0011\t\t#a\n\u0011\u0007\r\n\u0019#C\u0002\u0002&\u0011\u0012qAT8uQ&tw\rE\u0002$\u0003SI1!a\u000b%\u0005\r\te._\u0001\u0014Q\u0006tG\r\\3QY\u0006t\u0017\n^3n\u000bZ,g\u000e\u001e\u000b\u0004k\u0006E\u0002BB@\r\u0001\u0004\t\u0019\u0004\u0005\u0003\u0002\u0006\u0005U\u0012\u0002BA\u001c\u0003\u000f\u0011Q\u0002\u00157b]&#X-\\#wK:$\u0018aC4fiBc\u0017M\\%uK6$B!!\u0010\u0002FA!!H^A !\u0011\u0019\u0013\u0011\t/\n\u0007\u0005\rCE\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u000fj\u0001\u0019A)\u0002\u0015Ad\u0017M\\%uK6LE-\u0001\u0006de\u0016\fG/\u001a+bg.$2!^A'\u0011\u001d\tyE\u0004a\u0001\u0003#\n1!\u001a<u!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#bA@\u0002X)!\u0011QBA-\u0015\r\tY\u0006H\u0001\nQVl\u0017M\u001c;bg.LA!a\u0018\u0002V\t\u0011\u0002*^7b]R\u000b7o[!di&4\u0018\r^3e\u0003Q!W\r\u001d:fG\u0006$X\rZ\"sK\u0006$X\rV1tWR\u0019Q/!\u001a\t\u000f\u0005=s\u00021\u0001\u0002hA!\u00111KA5\u0013\u0011\tY'!\u0016\u0003!!+X.\u00198UCN\\7I]3bi\u0016$\u0017\u0001\u00065b]\u0012dW\rS;nC:$\u0016m]6Fm\u0016tG\u000fF\u0002v\u0003cBaa \tA\u0002\u0005M\u0004\u0003BA*\u0003kJA!a\u001e\u0002V\tq\u0001*^7b]R\u000b7o[#wK:$\u0018!\u00034fi\u000eDG+Y:l)\u0011\ti(!!\u0011\ti2\u0018q\u0010\t\u0005G\u0005\u0005s\u000e\u0003\u0004\u0002\u0004F\u0001\r!U\u0001\u0007i\u0006\u001c8.\u00133\u0002\u001bA\u0014X\r]1sK\u000e{W.\\5u)\u0011\tI)a$\u0011\u0007\r\nY)C\u0002\u0002\u000e\u0012\u0012A!\u00168ji\"9\u0011\u0011\u0013\nA\u0002\u0005M\u0015\u0001D2bg\u0016lu\u000eZ5gS\u0016$\u0007\u0003BAK\u0003/k!!!\u0003\n\t\u0005e\u0015\u0011\u0002\u0002\r\u0007\u0006\u001cX-T8eS\u001aLW\r\u001a")
public class CasePlanProjection
implements LazyLogging {
    private final RecordsPersistence persistence;
    private final ExecutionContext executionContext;
    private final HashMap<String, PlanItemRecord> planItems;
    private final Buffer<PlanItemHistoryRecord> planItemsHistory;
    private final HashMap<String, TaskRecord> tasks;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private HashMap<String, PlanItemRecord> planItems() {
        return this.planItems;
    }

    private Buffer<PlanItemHistoryRecord> planItemsHistory() {
        return this.planItemsHistory;
    }

    private HashMap<String, TaskRecord> tasks() {
        return this.tasks;
    }

    public Future<Done> handleCasePlanEvent(CasePlanEvent<?> event) {
        Future<Done> future;
        CasePlanEvent<?> casePlanEvent = event;
        if (casePlanEvent instanceof PlanItemEvent) {
            PlanItemEvent planItemEvent = (PlanItemEvent)casePlanEvent;
            future = this.handlePlanItemEvent(planItemEvent);
        } else if (casePlanEvent instanceof HumanTaskCreated) {
            HumanTaskCreated humanTaskCreated = (HumanTaskCreated)casePlanEvent;
            future = this.deprecatedCreateTask(humanTaskCreated);
        } else if (casePlanEvent instanceof HumanTaskActivated) {
            HumanTaskActivated humanTaskActivated = (HumanTaskActivated)casePlanEvent;
            future = this.createTask(humanTaskActivated);
        } else if (casePlanEvent instanceof HumanTaskEvent) {
            HumanTaskEvent humanTaskEvent = (HumanTaskEvent)casePlanEvent;
            future = this.handleHumanTaskEvent(humanTaskEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> handlePlanItemEvent(PlanItemEvent event) {
        Future future;
        PlanItemEvent planItemEvent = event;
        if (planItemEvent instanceof PlanItemDropped) {
            PlanItemDropped planItemDropped = (PlanItemDropped)planItemEvent;
            this.persistence.deletePlanItemRecordAndHistory(planItemDropped.getPlanItemId());
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        } else {
            Future future2;
            PlanItemHistoryMerger$.MODULE$.mapEventToHistory(event).foreach((Function1 & Serializable)item -> (Buffer)this.planItemsHistory().$plus$eq(item));
            PlanItemEvent planItemEvent2 = event;
            if (planItemEvent2 instanceof PlanItemCreated) {
                PlanItemCreated planItemCreated = (PlanItemCreated)planItemEvent2;
                PlanItemRecord planItem = PlanItemMerger$.MODULE$.merge(planItemCreated);
                this.planItems().put((Object)planItem.id(), (Object)planItem);
                future2 = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else if (planItemEvent2 != null) {
                PlanItemEvent planItemEvent3 = planItemEvent2;
                future2 = this.getPlanItem(event.getPlanItemId()).map((Function1 & Serializable)x0$1 -> {
                    Done$ done$;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Option option2;
                        Some some = (Some)option;
                        PlanItemRecord planItem = (PlanItemRecord)some.value();
                        PlanItemEvent planItemEvent = planItemEvent3;
                        if (planItemEvent instanceof PlanItemTransitioned) {
                            PlanItemTransitioned planItemTransitioned = (PlanItemTransitioned)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemTransitioned, planItem));
                        } else if (planItemEvent instanceof RepetitionRuleEvaluated) {
                            RepetitionRuleEvaluated repetitionRuleEvaluated = (RepetitionRuleEvaluated)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(repetitionRuleEvaluated, planItem));
                        } else if (planItemEvent instanceof RequiredRuleEvaluated) {
                            RequiredRuleEvaluated requiredRuleEvaluated = (RequiredRuleEvaluated)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(requiredRuleEvaluated, planItem));
                        } else if (planItemEvent instanceof PlanItemMigrated) {
                            PlanItemMigrated planItemMigrated = (PlanItemMigrated)planItemEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemMigrated, planItem));
                        } else {
                            option2 = BoxedUnit.UNIT;
                        }
                        done$ = Done$.MODULE$;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Expected PlanItem " + event.getPlanItemId() + " in " + event.getCaseInstanceId() + ", but not found in the database on event type " + event.getClass().getSimpleName());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        done$ = Done$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return done$;
                }, this.executionContext());
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Apparently we have a new type of PlanItemEvent that is not being handled by this Projection. The type is " + planItemEvent2.getClass().getName());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future2 = Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            future = future2;
        }
        return future;
    }

    private Future<Option<PlanItemRecord>> getPlanItem(String planItemId) {
        Future future;
        Option option = this.planItems().get((Object)planItemId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            PlanItemRecord item = (PlanItemRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Found plan item {} in current transaction cache", (Object)planItemId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)new Some((Object)item));
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving plan item {} from database", (Object)planItemId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getPlanItem(planItemId);
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<Done> createTask(HumanTaskActivated evt) {
        TaskRecord taskRecord;
        Option option = this.tasks().get((Object)evt.taskId);
        if (None$.MODULE$.equals(option)) {
            taskRecord = TaskMerger$.MODULE$.create(evt);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            taskRecord = TaskMerger$.MODULE$.apply(evt, task);
        } else {
            throw new MatchError((Object)option);
        }
        TaskRecord updatedTask = taskRecord;
        this.tasks().put((Object)evt.taskId, (Object)updatedTask);
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> deprecatedCreateTask(HumanTaskCreated evt) {
        this.tasks().put((Object)evt.taskId, (Object)TaskMerger$.MODULE$.create(evt));
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleHumanTaskEvent(HumanTaskEvent event) {
        Future future;
        HumanTaskEvent humanTaskEvent = event;
        if (humanTaskEvent instanceof HumanTaskDropped) {
            HumanTaskDropped humanTaskDropped = (HumanTaskDropped)humanTaskEvent;
            this.persistence.deleteTaskRecord(humanTaskDropped.taskId);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        HumanTaskEvent humanTaskEvent2 = event;
        if (humanTaskEvent2 instanceof HumanTaskInputSaved) {
            HumanTaskInputSaved humanTaskInputSaved = (HumanTaskInputSaved)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskInputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskOutputSaved) {
            HumanTaskOutputSaved humanTaskOutputSaved = (HumanTaskOutputSaved)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOutputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskOwnerChanged) {
            HumanTaskOwnerChanged humanTaskOwnerChanged = (HumanTaskOwnerChanged)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOwnerChanged, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskDueDateFilled) {
            HumanTaskDueDateFilled humanTaskDueDateFilled = (HumanTaskDueDateFilled)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskDueDateFilled, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskTransitioned) {
            HumanTaskTransitioned humanTaskTransitioned = (HumanTaskTransitioned)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)task -> task.map((Function1 & Serializable)t -> {
                TaskRecord taskRecord;
                TaskRecord copy = TaskMerger$.MODULE$.apply(humanTaskTransitioned, (TaskRecord)t);
                HumanTaskTransitioned humanTaskTransitioned = humanTaskTransitioned;
                if (humanTaskTransitioned instanceof HumanTaskAssigned) {
                    HumanTaskAssigned humanTaskAssigned = (HumanTaskAssigned)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskAssigned, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskActivated) {
                    HumanTaskActivated humanTaskActivated = (HumanTaskActivated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskActivated, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskCompleted) {
                    HumanTaskCompleted humanTaskCompleted = (HumanTaskCompleted)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskCompleted, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskTerminated) {
                    HumanTaskTerminated humanTaskTerminated = (HumanTaskTerminated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskTerminated, copy);
                } else {
                    taskRecord = copy;
                }
                return taskRecord;
            }), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskMigrated) {
            HumanTaskMigrated humanTaskMigrated = (HumanTaskMigrated)humanTaskEvent2;
            future = this.fetchTask(event.taskId).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskMigrated, (TaskRecord)task)), this.executionContext());
        } else {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        Future fTask = future;
        return fTask.map((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskRecord task = (TaskRecord)some.value();
                boxedUnit = this.tasks().put((Object)task.id(), (Object)task);
            } else {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Could not find task '{}' with id {} in the current database. This may lead to problems. Ignoring event of type {}", new Object[]{event.getTaskName(), event$2.taskId, event.getClass().getName()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            }
            return boxedUnit;
        }, this.executionContext()).flatMap((Function1 & Serializable)x$1 -> Future$.MODULE$.successful((Object)Done$.MODULE$), this.executionContext());
    }

    private Future<Option<TaskRecord>> fetchTask(String taskId) {
        Future future;
        Option option = this.tasks().get((Object)taskId);
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving task " + taskId + " from database");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getTask(taskId);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            future = Future$.MODULE$.successful((Object)new Some((Object)task));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public void prepareCommit(CaseModified caseModified) {
        ((IterableOnceOps)this.planItems().values().map((Function1 & Serializable)item -> PlanItemMerger$.MODULE$.merge(caseModified, (PlanItemRecord)item))).foreach((Function1 & Serializable)item -> {
            this.persistence.upsert(item);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.planItemsHistory().map((Function1 & Serializable)item -> PlanItemHistoryMerger$.MODULE$.merge(caseModified, (PlanItemHistoryRecord)item))).foreach((Function1 & Serializable)item -> {
            this.persistence.upsert(item);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.tasks().values().map((Function1 & Serializable)current -> TaskMerger$.MODULE$.apply(caseModified, (TaskRecord)current))).foreach((Function1 & Serializable)item -> {
            this.persistence.upsert(item);
            return BoxedUnit.UNIT;
        });
    }

    public CasePlanProjection(RecordsPersistence persistence, ExecutionContext executionContext) {
        this.persistence = persistence;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.planItems = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.planItemsHistory = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tasks = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

