/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.team;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamGroup;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamUser;
import org.cafienne.cmmn.actorapi.command.team.GroupRoleMapping;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberEvent;
import org.cafienne.cmmn.actorapi.event.team.CaseTeamMemberRemoved;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupAdded;
import org.cafienne.cmmn.actorapi.event.team.group.CaseTeamGroupChanged;
import org.cafienne.cmmn.instance.team.MemberType;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.materializer.cases.team.CaseTeamMemberKey;
import org.cafienne.querydb.record.CaseTeamGroupRecord;
import org.cafienne.querydb.record.CaseTeamTenantRoleRecord;
import org.cafienne.querydb.record.CaseTeamUserRecord;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011)\u0019!C\u0002w!A!\t\u0001B\u0001B\u0003%A\bC\u0003D\u0001\u0011\u0005A\tC\u0004K\u0001\t\u0007I\u0011B&\t\ri\u0003\u0001\u0015!\u0003M\u0011\u001dY\u0006A1A\u0005\n-Ca\u0001\u0018\u0001!\u0002\u0013a\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B0\t\u000f\u0011\u0004!\u0019!C\u0005=\"1Q\r\u0001Q\u0001\n}CqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004m\u0001\u0001\u0006I\u0001\u001b\u0005\b[\u0002\u0011\r\u0011\"\u0003h\u0011\u0019q\u0007\u0001)A\u0005Q\"9q\u000e\u0001b\u0001\n\u0013\u0001\bBB<\u0001A\u0003%\u0011\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\tA2)Y:f)\u0016\fW.T3nE\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8\u000b\u0005aI\u0012\u0001\u0002;fC6T!AG\u000e\u0002\u000b\r\f7/Z:\u000b\u0005qi\u0012\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0010 \u0003\u001d\tX/\u001a:zI\nT!\u0001I\u0011\u0002\u0011\r\fg-[3o]\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-g5\tQF\u0003\u0002/_\u0005a1oY1mC2|wmZ5oO*\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001N\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\fa\u0016\u00148/[:uK:\u001cW\r\u0005\u00028q5\t1$\u0003\u0002:7\t\u0011\"+Z2pe\u0012\u001c\b+\u001a:tSN$XM\\2f\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001=!\ti\u0004)D\u0001?\u0015\tyt%\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0011 \u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u00051A(\u001b8jiz\"\"!R%\u0015\u0005\u0019C\u0005CA$\u0001\u001b\u00059\u0002\"\u0002\u001e\u0005\u0001\ba\u0004\"B\u001b\u0005\u0001\u00041\u0014\u0001\u00068fo\u000e\u000b7/\u001a+fC6,6/\u001a:S_2,7/F\u0001M!\ri%\u000bV\u0007\u0002\u001d*\u0011q\nU\u0001\b[V$\u0018M\u00197f\u0015\t\tv%\u0001\u0006d_2dWm\u0019;j_:L!a\u0015(\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0002V16\taK\u0003\u0002X;\u00051!/Z2pe\u0012L!!\u0017,\u0003%\r\u000b7/\u001a+fC6,6/\u001a:SK\u000e|'\u000fZ\u0001\u0016]\u0016<8)Y:f)\u0016\fW.V:feJ{G.Z:!\u0003a\u0011X-\\8wK\u0012\u001c\u0015m]3UK\u0006lWk]3s%>dWm]\u0001\u001ae\u0016lwN^3e\u0007\u0006\u001cX\rV3b[V\u001bXM\u001d*pY\u0016\u001c\b%\u0001\u000eoK^\u001c\u0015m]3UK\u0006lG+\u001a8b]R\u0014v\u000e\\3S_2,7/F\u0001`!\ri%\u000b\u0019\t\u0003+\u0006L!A\u0019,\u00031\r\u000b7/\u001a+fC6$VM\\1oiJ{G.\u001a*fG>\u0014H-A\u000eoK^\u001c\u0015m]3UK\u0006lG+\u001a8b]R\u0014v\u000e\\3S_2,7\u000fI\u0001\u001fe\u0016lwN^3e\u0007\u0006\u001cX\rV3b[R+g.\u00198u%>dWMU8mKN\fqD]3n_Z,GmQ1tKR+\u0017-\u001c+f]\u0006tGOU8mKJ{G.Z:!\u0003aqWm^\"bg\u0016$V-Y7He>,\b/T1qa&twm]\u000b\u0002QB\u0019QJU5\u0011\u0005US\u0017BA6W\u0005M\u0019\u0015m]3UK\u0006lwI]8vaJ+7m\u001c:e\u0003eqWm^\"bg\u0016$V-Y7He>,\b/T1qa&twm\u001d\u0011\u0002)I,Wn\u001c<fI\u001e\u0013x.\u001e9NCB\u0004\u0018N\\4t\u0003U\u0011X-\\8wK\u0012<%o\\;q\u001b\u0006\u0004\b/\u001b8hg\u0002\na\u0002Z3mKR,G-T3nE\u0016\u00148/F\u0001r!\ri%\u000f^\u0005\u0003g:\u00131aU3u!\t9U/\u0003\u0002w/\t\t2)Y:f)\u0016\fW.T3nE\u0016\u00148*Z=\u0002\u001f\u0011,G.\u001a;fI6+WNY3sg\u0002\n1\u0002[1oI2,WI^3oiR\u0011!0 \t\u0003MmL!\u0001`\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006}N\u0001\ra`\u0001\u0006KZ,g\u000e\u001e\u0019\u0005\u0003\u0003\tI\u0002\u0005\u0004\u0002\u0004\u0005E\u0011QC\u0007\u0003\u0003\u000bQ1\u0001GA\u0004\u0015\rq\u0018\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0005bGR|'/\u00199j\u0015\r\tyaH\u0001\u0005G6lg.\u0003\u0003\u0002\u0014\u0005\u0015!aE\"bg\u0016$V-Y7NK6\u0014WM]#wK:$\b\u0003BA\f\u00033a\u0001\u0001B\u0006\u0002\u001cu\f\t\u0011!A\u0003\u0002\u0005u!aA0%cE!\u0011qDA\u0013!\r1\u0013\u0011E\u0005\u0004\u0003G9#a\u0002(pi\"Lgn\u001a\t\u0004M\u0005\u001d\u0012bAA\u0015O\t\u0019\u0011I\\=\u0002!!\fg\u000e\u001a7f\u000fJ|W\u000f]#wK:$Hc\u0001>\u00020!1a\u0010\u0006a\u0001\u0003c\u0001D!a\r\u00028A1\u00111AA\t\u0003k\u0001B!a\u0006\u00028\u0011a\u0011\u0011HA\u0018\u0003\u0003\u0005\tQ!\u0001\u0002\u001e\t\u0019q\fJ\u001a\u0002\u001bA\u0014X\r]1sK\u000e{W.\\5u)\u0005Q\b")
public class CaseTeamMemberProjection
implements LazyLogging {
    private final RecordsPersistence persistence;
    private final ExecutionContext executionContext;
    private final ListBuffer<CaseTeamUserRecord> newCaseTeamUserRoles;
    private final ListBuffer<CaseTeamUserRecord> removedCaseTeamUserRoles;
    private final ListBuffer<CaseTeamTenantRoleRecord> newCaseTeamTenantRoleRoles;
    private final ListBuffer<CaseTeamTenantRoleRecord> removedCaseTeamTenantRoleRoles;
    private final ListBuffer<CaseTeamGroupRecord> newCaseTeamGroupMappings;
    private final ListBuffer<CaseTeamGroupRecord> removedGroupMappings;
    private final Set<CaseTeamMemberKey> deletedMembers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        CaseTeamMemberProjection caseTeamMemberProjection = this;
        synchronized (caseTeamMemberProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private ListBuffer<CaseTeamUserRecord> newCaseTeamUserRoles() {
        return this.newCaseTeamUserRoles;
    }

    private ListBuffer<CaseTeamUserRecord> removedCaseTeamUserRoles() {
        return this.removedCaseTeamUserRoles;
    }

    private ListBuffer<CaseTeamTenantRoleRecord> newCaseTeamTenantRoleRoles() {
        return this.newCaseTeamTenantRoleRoles;
    }

    private ListBuffer<CaseTeamTenantRoleRecord> removedCaseTeamTenantRoleRoles() {
        return this.removedCaseTeamTenantRoleRoles;
    }

    private ListBuffer<CaseTeamGroupRecord> newCaseTeamGroupMappings() {
        return this.newCaseTeamGroupMappings;
    }

    private ListBuffer<CaseTeamGroupRecord> removedGroupMappings() {
        return this.removedGroupMappings;
    }

    private Set<CaseTeamMemberKey> deletedMembers() {
        return this.deletedMembers;
    }

    public void handleEvent(CaseTeamMemberEvent<?> event) {
        Object member = event.member;
        if (event instanceof CaseTeamMemberRemoved) {
            this.deletedMembers().$plus$eq((Object)new CaseTeamMemberKey(event.getActorId(), member.memberId(), member.memberType()));
        } else if (event.member instanceof CaseTeamGroup) {
            this.handleGroupEvent(event);
        } else {
            String caseInstanceId = event.getActorId();
            String memberId = member.memberId();
            boolean isOwner = member.isOwner();
            scala.collection.immutable.Set caseRoles = (scala.collection.immutable.Set)member.caseRoles().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})));
            scala.collection.immutable.Set removedRoles = CollectionConverters$.MODULE$.SetHasAsScala(event.getRolesRemoved()).asScala().toSet();
            MemberType memberType = member.memberType();
            if (((Object)((Object)MemberType.User)).equals((Object)memberType)) {
                String origin = ((CaseTeamUser)member).origin().toString();
                this.newCaseTeamUserRoles().addAll((IterableOnce)caseRoles.map((Function1 & Serializable)caseRole -> new CaseTeamUserRecord(caseInstanceId, event$1.tenant, memberId, origin, (String)caseRole, isOwner)));
                this.removedCaseTeamUserRoles().addAll((IterableOnce)removedRoles.map((Function1 & Serializable)caseRole -> new CaseTeamUserRecord(caseInstanceId, event$1.tenant, memberId, origin, (String)caseRole, isOwner)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)MemberType.TenantRole)).equals((Object)memberType)) {
                this.newCaseTeamTenantRoleRoles().addAll((IterableOnce)caseRoles.map((Function1 & Serializable)caseRole -> {
                    String x$1 = caseInstanceId;
                    String x$2 = memberId;
                    String x$3 = event$1.tenant;
                    String x$4 = caseRole;
                    boolean x$5 = isOwner;
                    return new CaseTeamTenantRoleRecord(x$1, x$3, x$2, x$4, x$5);
                }));
                this.removedCaseTeamTenantRoleRoles().addAll((IterableOnce)removedRoles.map((Function1 & Serializable)caseRole -> {
                    String x$6 = caseInstanceId;
                    String x$7 = memberId;
                    String x$8 = event$1.tenant;
                    String x$9 = caseRole;
                    boolean x$10 = isOwner;
                    return new CaseTeamTenantRoleRecord(x$6, x$8, x$7, x$9, x$10);
                }));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void handleGroupEvent(CaseTeamMemberEvent<?> event) {
        CaseTeamGroup group = (CaseTeamGroup)event.member;
        CaseTeamMemberEvent<?> caseTeamMemberEvent = event;
        if (caseTeamMemberEvent instanceof CaseTeamGroupAdded) {
            this.newCaseTeamGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecord$1(mapping, event, group)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (caseTeamMemberEvent instanceof CaseTeamGroupChanged) {
            CaseTeamGroupChanged caseTeamGroupChanged = (CaseTeamGroupChanged)caseTeamMemberEvent;
            this.newCaseTeamGroupMappings().addAll((IterableOnce)group.mappings().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecord$1(mapping, event, group)));
            this.removedGroupMappings().addAll((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(caseTeamGroupChanged.removedMappings).asScala().flatMap((Function1 & Serializable)mapping -> CaseTeamMemberProjection.asRecord$1(mapping, event, group)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void prepareCommit() {
        this.newCaseTeamUserRoles().foreach((Function1 & Serializable)roleUpdate -> {
            this.persistence.upsert(roleUpdate);
            return BoxedUnit.UNIT;
        });
        this.removedCaseTeamUserRoles().foreach((Function1 & Serializable)roleRemoved -> {
            this.persistence.delete(roleRemoved);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamTenantRoleRoles().foreach((Function1 & Serializable)roleUpdate -> {
            this.persistence.upsert(roleUpdate);
            return BoxedUnit.UNIT;
        });
        this.removedCaseTeamTenantRoleRoles().foreach((Function1 & Serializable)roleRemoval -> {
            this.persistence.delete(roleRemoval);
            return BoxedUnit.UNIT;
        });
        this.newCaseTeamGroupMappings().foreach((Function1 & Serializable)groupMapping -> {
            this.persistence.upsert(groupMapping);
            return BoxedUnit.UNIT;
        });
        this.removedGroupMappings().foreach((Function1 & Serializable)groupMapping -> {
            this.persistence.delete(groupMapping);
            return BoxedUnit.UNIT;
        });
        this.deletedMembers().foreach((Function1 & Serializable)key -> {
            this.persistence.deleteCaseTeamMember(key);
            return BoxedUnit.UNIT;
        });
    }

    private static final scala.collection.immutable.Set asRecord$1(GroupRoleMapping mapping, CaseTeamMemberEvent event$2, CaseTeamGroup group$1) {
        return (scala.collection.immutable.Set)mapping.caseRoles().map((Function1 & Serializable)caseRole -> {
            String x$1 = event$2.getActorId();
            String x$2 = event$2.tenant;
            String x$3 = group$1.groupId();
            String x$4 = caseRole;
            String x$5 = mapping.groupRole();
            boolean x$6 = mapping.isOwner();
            return new CaseTeamGroupRecord(x$1, x$2, x$3, x$5, x$4, x$6);
        });
    }

    public CaseTeamMemberProjection(RecordsPersistence persistence, ExecutionContext executionContext) {
        this.persistence = persistence;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.newCaseTeamUserRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedCaseTeamUserRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newCaseTeamTenantRoleRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedCaseTeamTenantRoleRoles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newCaseTeamGroupMappings = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.removedGroupMappings = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deletedMembers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

