/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.tenant;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.infrastructure.akkahttp.authentication.IdentityProvider;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.OffsetRecord;
import org.cafienne.infrastructure.cqrs.OffsetRecord$;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.materializer.slick.SlickTransaction;
import org.cafienne.querydb.materializer.tenant.TenantEventSink$;
import org.cafienne.querydb.materializer.tenant.TenantProjection;
import org.cafienne.querydb.materializer.tenant.TenantReader$;
import org.cafienne.querydb.materializer.tenant.TenantTransaction$;
import org.cafienne.querydb.materializer.tenant.TenantUserProjection;
import org.cafienne.tenant.actorapi.event.TenantAppliedPlatformUpdate;
import org.cafienne.tenant.actorapi.event.TenantModified;
import org.cafienne.tenant.actorapi.event.deprecated.DeprecatedTenantUserEvent;
import org.cafienne.tenant.actorapi.event.platform.PlatformEvent;
import org.cafienne.tenant.actorapi.event.user.TenantMemberEvent;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\b\u0010\u0001iA\u0001\u0002\u0005\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003M\u0001\u0011\u0005Q\nC\u0004T\u0001\t\u0007I\u0011\u0002+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u001dI\u0006A1A\u0005\niCaA\u0018\u0001!\u0002\u0013Y\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u0002:\u0001\t\u0003\u001a\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\tY\u0004\u0001C\u0005\u0003{\u0011\u0011\u0003V3oC:$HK]1og\u0006\u001cG/[8o\u0015\t\u0001\u0012#\u0001\u0004uK:\fg\u000e\u001e\u0006\u0003%M\tA\"\\1uKJL\u0017\r\\5{KJT!\u0001F\u000b\u0002\u000fE,XM]=eE*\u0011acF\u0001\tG\u00064\u0017.\u001a8oK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00017\u0005:\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#K5\t1E\u0003\u0002%#\u0005)1\u000f\\5dW&\u0011ae\t\u0002\u0011'2L7m\u001b+sC:\u001c\u0018m\u0019;j_:\u0004\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00051j\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u00039\n1aY8n\u0013\t\u0001\u0014FA\u0006MCjLHj\\4hS:<\u0007C\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025;5\tQG\u0003\u000273\u00051AH]8pizJ!\u0001O\u000f\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qu\t1\u0002]3sg&\u001cH/\u001a8dKB\u0011ahP\u0007\u0002#%\u0011\u0001)\u0005\u0002\u0013%\u0016\u001cwN\u001d3t!\u0016\u00148/[:uK:\u001cW-A\u0005vg\u0016\u00148)Y2iKB\u00111IS\u0007\u0002\t*\u0011QIR\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\t9\u0005*\u0001\u0005bW.\f\u0007\u000e\u001e;q\u0015\tIU#\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005-#%\u0001E%eK:$\u0018\u000e^=Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q!a\nU)S!\ty\u0005!D\u0001\u0010\u0011\u0015\u0001B\u00011\u00012\u0011\u0015aD\u00011\u0001>\u0011\u0015\tE\u00011\u0001C\u0003A!XM\\1oiB\u0013xN[3di&|g.F\u0001V!\tye+\u0003\u0002X\u001f\t\u0001B+\u001a8b]R\u0004&o\u001c6fGRLwN\\\u0001\u0012i\u0016t\u0017M\u001c;Qe>TWm\u0019;j_:\u0004\u0013AD;tKJ\u0004&o\u001c6fGRLwN\\\u000b\u00027B\u0011q\nX\u0005\u0003;>\u0011A\u0003V3oC:$Xk]3s!J|'.Z2uS>t\u0017aD;tKJ\u0004&o\u001c6fGRLwN\u001c\u0011\u0002%\r\u0014X-\u0019;f\u001f\u001a47/\u001a;SK\u000e|'\u000f\u001a\u000b\u0003C\u001e\u0004\"AY3\u000e\u0003\rT!\u0001\u001a%\u0002\t\r\f(o]\u0005\u0003M\u000e\u0014Ab\u00144gg\u0016$(+Z2pe\u0012DQ\u0001[\u0005A\u0002%\faa\u001c4gg\u0016$\bC\u00016q\u001b\u0005Y'B\u00017n\u0003\u0015\tX/\u001a:z\u0015\tadNC\u0001p\u0003\u0011\t7n[1\n\u0005E\\'AB(gMN,G/A\u0006iC:$G.Z#wK:$HC\u0001;\u007f!\r)\bP_\u0007\u0002m*\u0011q/H\u0001\u000bG>t7-\u001e:sK:$\u0018BA=w\u0005\u00191U\u000f^;sKB\u00111\u0010`\u0007\u0002]&\u0011QP\u001c\u0002\u0005\t>tW\r\u0003\u0004\u0000\u0015\u0001\u0007\u0011\u0011A\u0001\tK:4X\r\\8qKB\u0019!-a\u0001\n\u0007\u0005\u00151M\u0001\nN_\u0012,G.\u0012<f]R,eN^3m_B,\u0017AB2p[6LG\u000fF\u0003u\u0003\u0017\ti\u0001\u0003\u0004\u0000\u0017\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u001fY\u0001\u0019AA\t\u0003A!(/\u00198tC\u000e$\u0018n\u001c8Fm\u0016tG\u000f\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u000b\u00154XM\u001c;\u000b\u0007\u0005mQ#\u0001\u0006bGR|'/\\8eK2LA!a\b\u0002\u0016\tY1i\\7nSR,e/\u001a8u\u0003M\u0019w.\\7jiR+g.\u00198u%\u0016\u001cwN\u001d3t)\u0015!\u0018QEA\u0014\u0011\u0019yH\u00021\u0001\u0002\u0002!9\u0011\u0011\u0006\u0007A\u0002\u0005-\u0012A\u0004;f]\u0006tG/T8eS\u001aLW\r\u001a\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011qCA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0011\u0005\u001cGo\u001c:ba&T!\u0001E\u000b\n\t\u0005e\u0012q\u0006\u0002\u000f)\u0016t\u0017M\u001c;N_\u0012Lg-[3e\u00035)\b\u000fZ1uKV\u001bXM]%egR)A/a\u0010\u0002H!9\u0011qC\u0007A\u0002\u0005\u0005\u0003\u0003BA\u0017\u0003\u0007JA!!\u0012\u00020\tYB+\u001a8b]R\f\u0005\u000f\u001d7jK\u0012\u0004F.\u0019;g_JlW\u000b\u001d3bi\u0016DQ\u0001[\u0007A\u0002%\u0004")
public class TenantTransaction
implements SlickTransaction {
    private final String tenant;
    private final RecordsPersistence persistence;
    public final IdentityProvider org$cafienne$querydb$materializer$tenant$TenantTransaction$$userCache;
    private final TenantProjection tenantProjection;
    private final TenantUserProjection org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TenantTransaction tenantTransaction = this;
        synchronized (tenantTransaction) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private TenantProjection tenantProjection() {
        return this.tenantProjection;
    }

    public TenantUserProjection org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection() {
        return this.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection;
    }

    public OffsetRecord createOffsetRecord(Offset offset) {
        return OffsetRecord$.MODULE$.apply(TenantEventSink$.MODULE$.offsetName(), offset);
    }

    @Override
    public Future<Done> handleEvent(ModelEventEnvelope envelope) {
        Future<Done> future;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Handling event of type " + envelope.event().getClass().getSimpleName() + " on tenant " + this.tenant);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ModelEvent modelEvent = envelope.event();
        if (modelEvent instanceof PlatformEvent) {
            PlatformEvent platformEvent = (PlatformEvent)modelEvent;
            future = this.tenantProjection().handlePlatformEvent(platformEvent);
        } else if (modelEvent instanceof TenantMemberEvent) {
            TenantMemberEvent tenantMemberEvent = (TenantMemberEvent)modelEvent;
            future = this.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection().handleUserEvent(tenantMemberEvent);
        } else if (modelEvent instanceof DeprecatedTenantUserEvent) {
            DeprecatedTenantUserEvent deprecatedTenantUserEvent = (DeprecatedTenantUserEvent)modelEvent;
            future = this.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection().handleDeprecatedUserEvent(deprecatedTenantUserEvent);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    @Override
    public Future<Done> commit(ModelEventEnvelope envelope, CommitEvent transactionEvent) {
        Future future;
        CommitEvent commitEvent = transactionEvent;
        if (commitEvent instanceof TenantModified) {
            TenantModified tenantModified = (TenantModified)commitEvent;
            future = this.commitTenantRecords(envelope, tenantModified);
        } else if (commitEvent instanceof TenantAppliedPlatformUpdate) {
            TenantAppliedPlatformUpdate tenantAppliedPlatformUpdate = (TenantAppliedPlatformUpdate)commitEvent;
            future = this.updateUserIds(tenantAppliedPlatformUpdate, envelope.offset());
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("TenantTransaction unexpectedly receives a commit event of type {}. This event is ignored.", (Object)transactionEvent.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> commitTenantRecords(ModelEventEnvelope envelope, TenantModified tenantModified) {
        this.tenantProjection().prepareCommit();
        this.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection().prepareCommit();
        this.persistence.upsert(this.createOffsetRecord(envelope.offset()));
        return this.persistence.commit().andThen((PartialFunction)new Serializable(this, tenantModified){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TenantTransaction $outer;
            private final TenantModified tenantModified$1;

            public final <A1 extends Try<Done>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                A1 A1 = x$1;
                this.$outer.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection().affectedUserIds().foreach((Function1 & Serializable)userId -> {
                    $anonfun$commitTenantRecords$1.$anonfun$applyOrElse$1(this, userId);
                    return BoxedUnit.UNIT;
                });
                TenantReader$.MODULE$.lastModifiedRegistration().handle(this.tenantModified$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Try<Done> x$1) {
                Try<Done> try_ = x$1;
                boolean bl = true;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$commitTenantRecords$1 $this, String userId) {
                $this.$outer.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userCache.clear(userId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tenantModified$1 = tenantModified$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.cafienne.querydb.materializer.tenant.TenantTransaction$$anonfun$commitTenantRecords$1 java.lang.String )}, serializedLambda);
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Done> updateUserIds(TenantAppliedPlatformUpdate event, Offset offset) {
        return this.persistence.updateTenantUserInformation(event.tenant, event.newUserInformation.info(), this.createOffsetRecord(offset));
    }

    public TenantTransaction(String tenant, RecordsPersistence persistence, IdentityProvider userCache) {
        this.tenant = tenant;
        this.persistence = persistence;
        this.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userCache = userCache;
        LazyLogging.$init$((LazyLogging)this);
        this.tenantProjection = new TenantProjection(persistence, ExecutionContext.Implicits$.MODULE$.global());
        this.org$cafienne$querydb$materializer$tenant$TenantTransaction$$userProjection = new TenantUserProjection(persistence, ExecutionContext.Implicits$.MODULE$.global());
    }
}

