/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.tenant;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.querydb.materializer.RecordsPersistence;
import org.cafienne.querydb.record.UserRoleKey;
import org.cafienne.querydb.record.UserRoleKey$;
import org.cafienne.querydb.record.UserRoleRecord;
import org.cafienne.tenant.actorapi.event.deprecated.DeprecatedTenantUserEvent;
import org.cafienne.tenant.actorapi.event.deprecated.OwnerAdded;
import org.cafienne.tenant.actorapi.event.deprecated.OwnerRemoved;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserCreated;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserDisabled;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserEnabled;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserRoleAdded;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserRoleRemoved;
import org.cafienne.tenant.actorapi.event.deprecated.TenantUserUpdated;
import org.cafienne.tenant.actorapi.event.user.TenantMemberEvent;
import org.cafienne.tenant.actorapi.event.user.TenantUserAdded;
import org.cafienne.tenant.actorapi.event.user.TenantUserChanged;
import org.cafienne.tenant.actorapi.event.user.TenantUserRemoved;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\n\u0014\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011)\u0019!C\u0002k!AA\b\u0001B\u0001B\u0003%a\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004E\u0001\t\u0007I\u0011B#\t\r]\u0003\u0001\u0015!\u0003G\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%I!\u0017\u0005\u0007?\u0002\u0001\u000b\u0011\u0002.\t\u000f\u0001\u0004!\u0019!C\u0005C\"1Q\u000e\u0001Q\u0001\n\tDQA\u001c\u0001\u0005\u0002=Dq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d#\u0001\u0006+f]\u0006tG/V:feB\u0013xN[3di&|gN\u0003\u0002\u0015+\u00051A/\u001a8b]RT!AF\f\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u000b\u0005aI\u0012aB9vKJLHM\u0019\u0006\u00035m\t\u0001bY1gS\u0016tg.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1S&D\u0001(\u0015\tA\u0013&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002+W\u0005AA/\u001f9fg\u00064WMC\u0001-\u0003\r\u0019w.\\\u0005\u0003]\u001d\u00121\u0002T1{s2{wmZ5oO\u0006Y\u0001/\u001a:tSN$XM\\2f!\t\t$'D\u0001\u0016\u0013\t\u0019TC\u0001\nSK\u000e|'\u000fZ:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\"\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003wa\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f\r#\"\u0001\u0011\"\u0011\u0005\u0005\u0003Q\"A\n\t\u000bQ\"\u00019\u0001\u001c\t\u000b=\"\u0001\u0019\u0001\u0019\u00025\u0011,\u0007O]3dCR,G-V:fe\u00163XM\u001c;SK\u000e|'\u000fZ:\u0016\u0003\u0019\u0003Ba\u0012'O)6\t\u0001J\u0003\u0002J\u0015\u00069Q.\u001e;bE2,'BA&\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001b\"\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R/\u00051!/Z2pe\u0012L!a\u0015)\u0003\u0017U\u001bXM\u001d*pY\u0016\\U-\u001f\t\u0003\u001fVK!A\u0016)\u0003\u001dU\u001bXM\u001d*pY\u0016\u0014VmY8sI\u0006YB-\u001a9sK\u000e\fG/\u001a3Vg\u0016\u0014XI^3oiJ+7m\u001c:eg\u0002\na\"^:feJ{G.Z:BI\u0012,G-F\u0001[!\r95\fV\u0005\u00039\"\u0013!\u0002T5ti\n+hMZ3s\u0003=)8/\u001a:S_2,7/\u00113eK\u0012\u0004\u0013\u0001E;tKJ\u0014v\u000e\\3t%\u0016lwN^3e\u0003E)8/\u001a:S_2,7OU3n_Z,G\rI\u0001\rkN,'o\u001d*f[>4X\rZ\u000b\u0002EB\u0019qiY3\n\u0005\u0011D%aA*fiB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\tS\u0012,g\u000e^5us*\u0011!.G\u0001\u000bC\u000e$xN]7pI\u0016d\u0017B\u00017h\u0005)!VM\\1oiV\u001bXM]\u0001\u000ekN,'o\u001d*f[>4X\r\u001a\u0011\u00023!\fg\u000e\u001a7f\t\u0016\u0004(/Z2bi\u0016$Wk]3s\u000bZ,g\u000e\u001e\u000b\u0003af\u00042aN9t\u0013\t\u0011\bH\u0001\u0004GkR,(/\u001a\t\u0003i^l\u0011!\u001e\u0006\u0002m\u0006!\u0011m[6b\u0013\tAXO\u0001\u0003E_:,\u0007\"\u0002>\u000e\u0001\u0004Y\u0018!B3wK:$\bc\u0001?\u0002\b5\tQP\u0003\u0002\u007f\u007f\u0006QA-\u001a9sK\u000e\fG/\u001a3\u000b\u0007i\f\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001C1di>\u0014\u0018\r]5\u000b\u0005QI\u0012bAA\u0005{\nIB)\u001a9sK\u000e\fG/\u001a3UK:\fg\u000e^+tKJ,e/\u001a8u\u0003E9W\r^+tKJ\u0014v\u000e\\3SK\u000e|'\u000f\u001a\u000b\u0005\u0003\u001f\t\t\u0002E\u00028cRCa!a\u0005\u000f\u0001\u0004q\u0015aA6fs\u0006y\u0001.\u00198eY\u0016,6/\u001a:Fm\u0016tG\u000fF\u0002q\u00033AaA_\bA\u0002\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005r0\u0001\u0003vg\u0016\u0014\u0018\u0002BA\u0013\u0003?\u0011\u0011\u0003V3oC:$X*Z7cKJ,e/\u001a8u\u0003=\tgMZ3di\u0016$Wk]3s\u0013\u0012\u001cXCAA\u0016!\u0019\ti#a\u000f\u0002@9!\u0011qFA\u001c!\r\t\t$I\u0007\u0003\u0003gQ1!!\u000e\u001e\u0003\u0019a$o\\8u}%\u0019\u0011\u0011H\u0011\u0002\rA\u0013X\rZ3g\u0013\r!\u0017Q\b\u0006\u0004\u0003s\t\u0003\u0003BA\u0017\u0003\u0003JA!a\u0011\u0002>\t11\u000b\u001e:j]\u001e\fQ\u0002\u001d:fa\u0006\u0014XmQ8n[&$HCAA%!\r\u0001\u00131J\u0005\u0004\u0003\u001b\n#\u0001B+oSR\u0004")
public class TenantUserProjection
implements LazyLogging {
    private final RecordsPersistence persistence;
    private final ExecutionContext executionContext;
    private final HashMap<UserRoleKey, UserRoleRecord> deprecatedUserEventRecords;
    private final ListBuffer<UserRoleRecord> userRolesAdded;
    private final ListBuffer<UserRoleRecord> userRolesRemoved;
    private final Set<TenantUser> usersRemoved;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TenantUserProjection tenantUserProjection = this;
        synchronized (tenantUserProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private HashMap<UserRoleKey, UserRoleRecord> deprecatedUserEventRecords() {
        return this.deprecatedUserEventRecords;
    }

    private ListBuffer<UserRoleRecord> userRolesAdded() {
        return this.userRolesAdded;
    }

    private ListBuffer<UserRoleRecord> userRolesRemoved() {
        return this.userRolesRemoved;
    }

    private Set<TenantUser> usersRemoved() {
        return this.usersRemoved;
    }

    public Future<Done> handleDeprecatedUserEvent(DeprecatedTenantUserEvent event) {
        UserRoleKey key = UserRoleKey$.MODULE$.apply(event);
        return this.getUserRoleRecord(key).map((Function1 & Serializable)user -> {
            BoxedUnit boxedUnit;
            DeprecatedTenantUserEvent deprecatedTenantUserEvent = event;
            if (deprecatedTenantUserEvent instanceof TenantUserCreated) {
                TenantUserCreated tenantUserCreated = (TenantUserCreated)deprecatedTenantUserEvent;
                String x$1 = tenantUserCreated.name;
                String x$2 = tenantUserCreated.email;
                boolean x$3 = true;
                String x$4 = user.copy$default$1();
                String x$5 = user.copy$default$2();
                String x$6 = user.copy$default$3();
                boolean x$7 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$4, x$5, x$6, x$1, x$2, x$7, true));
            } else if (deprecatedTenantUserEvent instanceof TenantUserUpdated) {
                TenantUserUpdated tenantUserUpdated = (TenantUserUpdated)deprecatedTenantUserEvent;
                String x$8 = tenantUserUpdated.name;
                String x$9 = tenantUserUpdated.email;
                boolean x$10 = true;
                String x$11 = user.copy$default$1();
                String x$12 = user.copy$default$2();
                String x$13 = user.copy$default$3();
                boolean x$14 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$11, x$12, x$13, x$8, x$9, x$14, true));
            } else if (deprecatedTenantUserEvent instanceof TenantUserRoleAdded) {
                boolean x$15 = true;
                String x$16 = user.copy$default$1();
                String x$17 = user.copy$default$2();
                String x$18 = user.copy$default$3();
                String x$19 = user.copy$default$4();
                String x$20 = user.copy$default$5();
                boolean x$21 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$16, x$17, x$18, x$19, x$20, x$21, true));
            } else if (deprecatedTenantUserEvent instanceof TenantUserRoleRemoved) {
                boolean x$22 = false;
                String x$23 = user.copy$default$1();
                String x$24 = user.copy$default$2();
                String x$25 = user.copy$default$3();
                String x$26 = user.copy$default$4();
                String x$27 = user.copy$default$5();
                boolean x$28 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$23, x$24, x$25, x$26, x$27, x$28, false));
            } else if (deprecatedTenantUserEvent instanceof OwnerAdded) {
                boolean x$29 = true;
                String x$30 = user.copy$default$1();
                String x$31 = user.copy$default$2();
                String x$32 = user.copy$default$3();
                String x$33 = user.copy$default$4();
                String x$34 = user.copy$default$5();
                boolean x$35 = user.copy$default$7();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$30, x$31, x$32, x$33, x$34, true, x$35));
            } else if (deprecatedTenantUserEvent instanceof OwnerRemoved) {
                boolean x$36 = false;
                String x$37 = user.copy$default$1();
                String x$38 = user.copy$default$2();
                String x$39 = user.copy$default$3();
                String x$40 = user.copy$default$4();
                String x$41 = user.copy$default$5();
                boolean x$42 = user.copy$default$7();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$37, x$38, x$39, x$40, x$41, false, x$42));
            } else if (deprecatedTenantUserEvent instanceof TenantUserDisabled) {
                boolean x$43 = false;
                String x$44 = user.copy$default$1();
                String x$45 = user.copy$default$2();
                String x$46 = user.copy$default$3();
                String x$47 = user.copy$default$4();
                String x$48 = user.copy$default$5();
                boolean x$49 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$44, x$45, x$46, x$47, x$48, x$49, false));
            } else if (deprecatedTenantUserEvent instanceof TenantUserEnabled) {
                boolean x$50 = true;
                String x$51 = user.copy$default$1();
                String x$52 = user.copy$default$2();
                String x$53 = user.copy$default$3();
                String x$54 = user.copy$default$4();
                String x$55 = user.copy$default$5();
                boolean x$56 = user.copy$default$6();
                boxedUnit = this.deprecatedUserEventRecords().put((Object)key, (Object)user.copy(x$51, x$52, x$53, x$54, x$55, x$56, true));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Done$.MODULE$;
        }, this.executionContext());
    }

    private Future<UserRoleRecord> getUserRoleRecord(UserRoleKey key) {
        Future future;
        Option option = this.deprecatedUserEventRecords().get((Object)key);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserRoleRecord value = (UserRoleRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieved user_role[{}] from current transaction cache", (Object)key);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Retrieving user_role[{}] from database", (Object)key);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.persistence.getUserRole(key).map((Function1 & Serializable)x0$1 -> {
                UserRoleRecord userRoleRecord;
                Option option = x0$1;
                if (option instanceof Some) {
                    UserRoleRecord value;
                    Some some = (Some)option;
                    userRoleRecord = value = (UserRoleRecord)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    userRoleRecord = new UserRoleRecord(key.userId(), key.tenant(), key.role_name(), "", "", false, true);
                } else {
                    throw new MatchError((Object)option);
                }
                return userRoleRecord;
            }, this.executionContext());
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public Future<Done> handleUserEvent(TenantMemberEvent event) {
        Growable growable;
        TenantUser user = event.member;
        TenantMemberEvent tenantMemberEvent = event;
        if (tenantMemberEvent instanceof TenantUserRemoved) {
            growable = this.usersRemoved().$plus$eq((Object)user);
        } else {
            this.userRolesAdded().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), "", user.name(), user.email(), user.isOwner(), user.enabled()));
            TenantMemberEvent tenantMemberEvent2 = tenantMemberEvent;
            if (tenantMemberEvent2 instanceof TenantUserAdded) {
                user.roles().foreach((Function1 & Serializable)role -> (ListBuffer)this.userRolesAdded().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), (String)role, "", "", false, true)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (tenantMemberEvent2 instanceof TenantUserChanged) {
                TenantUserChanged tenantUserChanged = (TenantUserChanged)tenantMemberEvent2;
                user.roles().foreach((Function1 & Serializable)role -> (ListBuffer)this.userRolesAdded().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), (String)role, "", "", false, true)));
                tenantUserChanged.rolesRemoved.forEach(role -> this.userRolesRemoved().$plus$eq((Object)new UserRoleRecord(user.id(), user.tenant(), (String)role, "", "", false, true)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            growable = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public scala.collection.immutable.Set<String> affectedUserIds() {
        return (scala.collection.immutable.Set)((IterableOnceOps)((IterableOps)((IterableOps)this.deprecatedUserEventRecords().values().$plus$plus(this.userRolesAdded())).$plus$plus(this.userRolesRemoved())).map((Function1 & Serializable)x$1 -> x$1.userId())).toSet().$plus$plus((IterableOnce)this.usersRemoved().map((Function1 & Serializable)x$2 -> x$2.id()));
    }

    public void prepareCommit() {
        this.deprecatedUserEventRecords().values().foreach((Function1 & Serializable)instance -> {
            this.persistence.upsert(instance);
            return BoxedUnit.UNIT;
        });
        this.userRolesAdded().foreach((Function1 & Serializable)record -> {
            this.persistence.upsert(record);
            return BoxedUnit.UNIT;
        });
        this.userRolesRemoved().foreach((Function1 & Serializable)record -> {
            this.persistence.delete(record);
            return BoxedUnit.UNIT;
        });
        this.usersRemoved().foreach((Function1 & Serializable)user -> {
            this.persistence.deleteTenantUser(user);
            return BoxedUnit.UNIT;
        });
    }

    public TenantUserProjection(RecordsPersistence persistence, ExecutionContext executionContext) {
        this.persistence = persistence;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.deprecatedUserEventRecords = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.userRolesAdded = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.userRolesRemoved = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.usersRemoved = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

