/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.identity.ConsentGroupMembership;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.actormodel.identity.Origin;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.consentgroup.actorapi.ConsentGroup;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember$;
import org.cafienne.infrastructure.jdbc.CafienneJDBCConfig;
import org.cafienne.querydb.query.UserQueries;
import org.cafienne.querydb.query.exception.ConsentGroupMemberSearchFailure;
import org.cafienne.querydb.query.exception.ConsentGroupSearchFailure;
import org.cafienne.querydb.query.exception.TenantSearchFailure;
import org.cafienne.querydb.query.exception.TenantUserSearchFailure;
import org.cafienne.querydb.query.exception.UserSearchFailure;
import org.cafienne.querydb.record.ConsentGroupMemberRecord;
import org.cafienne.querydb.record.ConsentGroupRecord;
import org.cafienne.querydb.record.TenantRecord;
import org.cafienne.querydb.record.UserRoleRecord;
import org.cafienne.querydb.schema.QueryDBSchema;
import org.cafienne.querydb.schema.table.ConsentGroupTables;
import org.cafienne.querydb.schema.table.TenantTables;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.basic.DatabaseConfig;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BaseJoinQuery;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionLift$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.lifted.TableQuery$;
import slick.lifted.Tag;
import slick.migration.api.Dialect;
import slick.migration.api.MigrationSeq;
import slick.sql.SqlAction;

@ScalaSignature(bytes="\u0006\u0005\t5b\u0001\u0002\f\u0018\u0001\u0001BQ\u0001\u0011\u0001\u0005\u0002\u0005Cqa\u0011\u0001C\u0002\u0013\rA\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019Q\u0006\u0001)A\u0005\u001d\")1\f\u0001C!9\")1\u000f\u0001C!i\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005BB:\u0001\t\u0003\n9\nC\u0004\u0002\u001e\u0002!\t%a(\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007b\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0005E!VM\\1oiF+XM]5fg&k\u0007\u000f\u001c\u0006\u00031e\tQ!];fefT!AG\u000e\u0002\u000fE,XM]=eE*\u0011A$H\u0001\tG\u00064\u0017.\u001a8oK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001C\u001dZS'\u0010\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!JS\"A\f\n\u0005):\"aC+tKJ\fV/\u001a:jKN\u0004\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005A\n\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003I\n1aY8n\u0013\t!TFA\u0006MCjLHj\\4hS:<\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0015!\u0018M\u00197f\u0015\tQ\u0014$\u0001\u0004tG\",W.Y\u0005\u0003y]\u0012A\u0002V3oC:$H+\u00192mKN\u0004\"A\u000e \n\u0005}:$AE\"p]N,g\u000e^$s_V\u0004H+\u00192mKN\fa\u0001P5oSRtD#\u0001\"\u0011\u0005!\u0002\u0011AA3d+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%$\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0015\u001e\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%\u0001\u0006s_2,7/U;fef,\u0012A\u0014\t\u0004\u001fR3V\"\u0001)\u000b\u0005E\u0013\u0016A\u00027jMR,GMC\u0001T\u0003\u0015\u0019H.[2l\u0013\t)\u0006K\u0001\u0006UC\ndW-U;fef\u0004\"a\u0016-\u000e\u0003\u0001I!!W\u001e\u0003\u001bU\u001bXM\u001d*pY\u0016$\u0016M\u00197f\u0003-\u0011x\u000e\\3t#V,'/\u001f\u0011\u0002\u0013\u001d,G\u000fV3oC:$HCA/g!\r1e\fY\u0005\u0003?\u001e\u0013aAR;ukJ,\u0007CA1e\u001b\u0005\u0011'BA2\u001a\u0003\u0019\u0011XmY8sI&\u0011QM\u0019\u0002\r)\u0016t\u0017M\u001c;SK\u000e|'\u000f\u001a\u0005\u0006O\u001a\u0001\r\u0001[\u0001\ti\u0016t\u0017M\u001c;JIB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[\u0012\u000e\u00031T!!\\\u0010\u0002\rq\u0012xn\u001c;?\u0013\ty7%\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8$\u000359W\r\u001e+f]\u0006tG/V:feR!QO`A\u0004!\r1eL\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\f\u0001\"\u001b3f]RLG/\u001f\u0006\u0003wn\t!\"Y2u_Jlw\u000eZ3m\u0013\ti\bP\u0001\u0006UK:\fg\u000e^+tKJDaa`\u0004A\u0002\u0005\u0005\u0011\u0001B;tKJ\u00042a^A\u0002\u0013\r\t)\u0001\u001f\u0002\r+N,'/\u00133f]RLG/\u001f\u0005\u0007\u0003\u00139\u0001\u0019\u00015\u0002\rQ,g.\u00198u\u0003=9W\r\u001e)mCR4wN]7Vg\u0016\u0014H\u0003BA\b\u0003/\u0001BA\u00120\u0002\u0012A\u0019q/a\u0005\n\u0007\u0005U\u0001P\u0001\u0007QY\u0006$hm\u001c:n+N,'\u000f\u0003\u0004\u0002\u001a!\u0001\r\u0001[\u0001\u0007kN,'/\u00133\u0002-\u0011,G/\u001a:nS:,wJ]5hS:|e-V:feN$b!a\b\u0002@\u0005\u0015\u0003\u0003\u0002$_\u0003C\u0001b!a\t\u0002.\u0005Mb\u0002BA\u0013\u0003Sq1a[A\u0014\u0013\u0005!\u0013bAA\u0016G\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u00111aU3r\u0015\r\tYc\t\t\u0007E\u0005U\u0002.!\u000f\n\u0007\u0005]2E\u0001\u0004UkBdWM\r\t\u0004o\u0006m\u0012bAA\u001fq\n1qJ]5hS:Dq!!\u0011\n\u0001\u0004\t\u0019%A\u0003vg\u0016\u00148\u000fE\u0003\u0002$\u00055\u0002\u000e\u0003\u0004\u0002\n%\u0001\r\u0001[\u0001\u0011O\u0016$\b\u000b\\1uM>\u0014X.V:feN$B!a\u0013\u0002PA!aIXA'!\u0019\t\u0019#!\f\u0002\u0012!9\u0011\u0011\t\u0006A\u0002\u0005\r\u0013AE2sK\u0006$X\r\u00157bi\u001a|'/\\+tKJ$\u0002\"!\u0005\u0002V\u0005]\u00131\r\u0005\u0007\u00033Y\u0001\u0019\u00015\t\u000f\u0005e3\u00021\u0001\u0002\\\u0005iA/\u001a8b]R\u0014VmY8sIN\u0004b!a\t\u0002.\u0005u\u0003cA1\u0002`%\u0019\u0011\u0011\r2\u0003\u001dU\u001bXM\u001d*pY\u0016\u0014VmY8sI\"9\u0011QM\u0006A\u0002\u0005\u001d\u0014\u0001D4s_V\u0004(+Z2pe\u0012\u001c\bCBA\u0012\u0003[\tI\u0007E\u0002b\u0003WJ1!!\u001cc\u0005a\u0019uN\\:f]R<%o\\;q\u001b\u0016l'-\u001a:SK\u000e|'\u000fZ\u0001\u000fO\u0016$H+\u001a8b]R,6/\u001a:t)\u0011\t\u0019(a\u001e\u0011\t\u0019s\u0016Q\u000f\t\u0006\u0003G\tiC\u001e\u0005\u0006\u007f2\u0001\rA^\u0001\u0013e\u0016\fG-\u00117m)\u0016t\u0017M\u001c;Vg\u0016\u00148\u000f\u0006\u0003\u0002t\u0005u\u0004\"B@\u000e\u0001\u00041\u0018\u0001E2sK\u0006$X\rV3oC:$Xk]3s)\u00151\u00181QAC\u0011\u0019yh\u00021\u0001\u0002^!9\u0011q\u0011\bA\u0002\u0005%\u0015!\u0002:pY\u0016\u001c\b\u0003B5\u0002\f\"L1!!$s\u0005\r\u0019V\r^\u0001\u001eO\u0016$H)[:bE2,G\rV3oC:$Xk]3s\u0003\u000e\u001cw.\u001e8ugR!\u00111OAJ\u0011\u0019\t)j\u0004a\u0001m\u0006QA/\u001a8b]R,6/\u001a:\u0015\u000bU\fI*a'\t\r\u0005U\u0005\u00031\u0001w\u0011\u0019\tI\u0002\u0005a\u0001Q\u0006\u0001r-\u001a;D_:\u001cXM\u001c;He>,\bo\u001d\u000b\u0005\u0003C\u000b)\f\u0005\u0003G=\u0006\r\u0006CBA\u0012\u0003[\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0011\u0005\u001cGo\u001c:ba&T1!a,\u001c\u00031\u0019wN\\:f]R<'o\\;q\u0013\u0011\t\u0019,!+\u0003\u0019\r{gn]3oi\u001e\u0013x.\u001e9\t\u000f\u0005]\u0016\u00031\u0001\u0002D\u0005AqM]8va&#7/A\bhKR\u001cuN\\:f]R<%o\\;q)\u0019\ti,a0\u0002BB!aIXAS\u0011\u0019y(\u00031\u0001\u0002\u0002!1\u00111\u0019\nA\u0002!\fqa\u001a:pkBLE-A\u000ed_:\u001cXM\u001c;He>,\b/T3nE\u0016\u00148\u000f[5q#V,'/\u001f\u000b\u0007\u0003\u0013\u0014\tAa\u0001\u0011\u0015\u0005-\u0017\u0011_A}\u0003S\nyP\u0004\u0003\u0002N\u0006\u0015h\u0002BAh\u00033t1aVAi\u0013\u0011\t\u0019.!6\u0002\u0011\u0011\u00147i\u001c8gS\u001eL1!a6:\u00055\tV/\u001a:z\t\n\u001b6\r[3nC&!\u00111\\Ao\u0003\u001d\u0001(o\u001c4jY\u0016LA!a8\u0002b\nqA)\u0019;bE\u0006\u001cXmQ8oM&<'bAAr%\u0006)!-Y:jG&!\u0011q]Au\u0003\r\t\u0007/[\u0005\u0005\u0003W\fiOA\u0006KI\n\u001c\u0007K]8gS2,'bAAx%\u0006!!\u000e\u001a2d\u0013\u0011\t\u00190!>\u0003\u000bE+XM]=\n\u0007\u0005]\bKA\u0004BY&\f7/Z:\u0011\u0007]\u000bY0C\u0002\u0002~z\u0012qcQ8og\u0016tGo\u0012:pkBlU-\u001c2feR\u000b'\r\\3\u0011\t\u0005\r\u0012Q\u0006\u0005\u0007\u007fN\u0001\r!!\u0001\t\u000f\u0005\r7\u00031\u0001\u0003\u0006A)\u00111\u001aB\u0004Q&!!\u0011BA{\u0005\r\u0011V\r]\u0001\u0016O\u0016$8i\u001c8tK:$xI]8va6+WNY3s)!\u0011yAa\u0006\u0003\u001a\tm\u0001\u0003\u0002$_\u0005#\u0001B!a*\u0003\u0014%!!QCAU\u0005I\u0019uN\\:f]R<%o\\;q\u001b\u0016l'-\u001a:\t\r}$\u0002\u0019AA\u0001\u0011\u0019\t\u0019\r\u0006a\u0001Q\"1\u0011\u0011\u0004\u000bA\u0002!\f1cZ3u\u0007>t7/\u001a8u\u000fJ|W\u000f]+tKJ$bA!\t\u0003*\t-\u0002\u0003\u0002$_\u0005G\u00012a\u001eB\u0013\u0013\r\u00119\u0003\u001f\u0002\u0011\u0007>t7/\u001a8u\u000fJ|W\u000f]+tKJDaa`\u000bA\u0002\u0005\u0005\u0001BBAb+\u0001\u0007\u0001\u000e")
public class TenantQueriesImpl
implements UserQueries,
LazyLogging,
TenantTables,
ConsentGroupTables {
    private final ExecutionContext ec;
    private final TableQuery<TenantTables.UserRoleTable> rolesQuery;
    private DatabaseConfig<JdbcProfile> dbConfig;
    private JdbcBackend.DatabaseDef db;
    private boolean isSQLServer;
    private Dialect<? extends JdbcProfile> dialect;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public <CT extends CafienneJDBCConfig.CafienneTable<?>, E> CafienneJDBCConfig.QueryHelper<CT, E> QueryHelper(Query<CT, E, Seq> query) {
        return CafienneJDBCConfig.QueryHelper$(this, query);
    }

    @Override
    public <CTT extends CafienneJDBCConfig.CafienneTenantTable<?>, E> CafienneJDBCConfig.TenantQueryHelper<CTT, E> TenantQueryHelper(Query<CTT, E, Seq> query) {
        return CafienneJDBCConfig.TenantQueryHelper$(this, query);
    }

    @Override
    public MigrationSeq asSqlMigration(SqlAction<?, ?, ?> action) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, action);
    }

    @Override
    public MigrationSeq asSqlMigration(Seq<String> sql) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, sql);
    }

    private DatabaseConfig<JdbcProfile> dbConfig$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dbConfig = QueryDBSchema.dbConfig$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dbConfig;
    }

    @Override
    public DatabaseConfig<JdbcProfile> dbConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dbConfig$lzycompute() : this.dbConfig;
    }

    private JdbcBackend.DatabaseDef db$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.db = CafienneJDBCConfig.db$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    @Override
    public JdbcBackend.DatabaseDef db() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
    }

    private boolean isSQLServer$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isSQLServer = CafienneJDBCConfig.isSQLServer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isSQLServer;
    }

    @Override
    public boolean isSQLServer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isSQLServer$lzycompute() : this.isSQLServer;
    }

    private Dialect<? extends JdbcProfile> dialect$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dialect = CafienneJDBCConfig.dialect$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dialect;
    }

    @Override
    public Dialect<? extends JdbcProfile> dialect() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dialect$lzycompute() : this.dialect;
    }

    private Logger logger$lzycompute() {
        TenantQueriesImpl tenantQueriesImpl = this;
        synchronized (tenantQueriesImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public TableQuery<TenantTables.UserRoleTable> rolesQuery() {
        return this.rolesQuery;
    }

    @Override
    public Future<TenantRecord> getTenant(String tenantId) {
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.TenantTable(this, (Tag)tag)).filter((Function1 & Serializable)x$1 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$1.name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenantId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$2 -> x$2.enabled(), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            TenantRecord record;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                throw new TenantSearchFailure(tenantId);
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            TenantRecord tenantRecord = record = (TenantRecord)some.value();
            return tenantRecord;
        }, this.ec());
    }

    @Override
    public Future<TenantUser> getTenantUser(UserIdentity user, String tenant) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$3 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$3.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$4 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$4.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            UserRoleRecord userRecord = (UserRoleRecord)records.find((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$5(record))).fold((Function0 & Serializable)() -> {
                throw new TenantUserSearchFailure(tenant, user.id());
            }, (Function1 & Serializable)r -> r);
            Set roles = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$8(record)))).map((Function1 & Serializable)x$5 -> x$5.role_name())).toSet();
            return this.createTenantUser(userRecord, (Set<String>)roles);
        }, this.ec());
    }

    @Override
    public Future<PlatformUser> getPlatformUser(String userId) {
        return this.getPlatformUsers((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{userId})))).map((Function1 & Serializable)x$6 -> (PlatformUser)x$6.head(), this.ec());
    }

    @Override
    public Future<Seq<Tuple2<String, Origin>>> determineOriginOfUsers(Seq<String> users, String tenant) {
        Query tenantMembership = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$7.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$8 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$8.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$9 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$9.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$10 -> x$10.userId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).distinct().take(users.length());
        Query platformRegistration = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$11 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$11.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filterNot((Function1 & Serializable)x$12 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$12.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenant, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$13 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$13.role_name(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$14 -> x$14.userId(), Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).distinct().take(users.length());
        BaseJoinQuery query = tenantMembership.joinFull(platformRegistration, OptionLift$.MODULE$.repOptionLift(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), Shape$.MODULE$.optionShape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionLift$.MODULE$.repOptionLift(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), Shape$.MODULE$.optionShape(Shape$.MODULE$.repColumnShape((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods((Query)query)).result()).map((Function1 & Serializable)records -> {
            Set tenantUserIds = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$determineOriginOfUsers$12(x$15)))).map((Function1 & Serializable)x$16 -> (String)((Option)x$16._1()).get())).toSet();
            Set platformUserIds = ((IterableOnceOps)((IterableOps)records.filter((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$determineOriginOfUsers$14(x$17)))).map((Function1 & Serializable)x$18 -> (String)((Option)x$18._2()).get())).toSet();
            return (Seq)users.map((Function1 & Serializable)user -> new Tuple2(user, (Object)TenantQueriesImpl.determineOrigin$1(user, tenantUserIds, platformUserIds)));
        }, this.ec());
    }

    @Override
    public Future<Seq<PlatformUser>> getPlatformUsers(Seq<String> users) {
        Query tenantUsersQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$19 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$19.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$20 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$20.enabled(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Query consentGroupsQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$21 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$21.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)users, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        Query usersQuery = tenantUsersQuery.joinFull(consentGroupsQuery, OptionLift$.MODULE$.anyOptionLift(Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())), Shape$.MODULE$.anyOptionShape(Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())), OptionLift$.MODULE$.anyOptionLift(Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())), Shape$.MODULE$.anyOptionShape(Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl()))).on((Function2 & Serializable)(left, right) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(left.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(right.userId(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(usersQuery)).result()).map((Function1 & Serializable)records -> (Seq)users.map((Function1 & Serializable)userId -> {
            Seq tenantRecords = (Seq)((IterableOps)((IterableOps)records.filter((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUsers$9(x$22)))).map((Function1 & Serializable)x$23 -> (UserRoleRecord)((Option)x$23._1()).get())).filter((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUsers$11(userId, x$24)));
            Seq groupRecords = (Seq)((IterableOps)((IterableOps)records.filter((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUsers$12(x$25)))).map((Function1 & Serializable)x$26 -> (ConsentGroupMemberRecord)((Option)x$26._2()).get())).filter((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getPlatformUsers$14(userId, x$27)));
            return this.createPlatformUser((String)userId, (Seq<UserRoleRecord>)tenantRecords, (Seq<ConsentGroupMemberRecord>)groupRecords);
        }), this.ec());
    }

    private PlatformUser createPlatformUser(String userId, Seq<UserRoleRecord> tenantRecords, Seq<ConsentGroupMemberRecord> groupRecords) {
        Seq tenantUsers = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOnceOps)tenantRecords.map((Function1 & Serializable)x$28 -> x$28.tenant())).toSet().map((Function1 & Serializable)tenant -> {
            Seq userRecords = (Seq)tenantRecords.filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$createPlatformUser$3(tenant, x$29)));
            Set roles = ((IterableOnceOps)((IterableOps)userRecords.filterNot((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$createPlatformUser$4(x$30)))).map((Function1 & Serializable)x$31 -> x$31.role_name())).toSet();
            Option user = userRecords.find((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$createPlatformUser$6(x$32)));
            return user.isEmpty() ? None$.MODULE$ : new Some((Object)this.createTenantUser((UserRoleRecord)user.get(), (Set<String>)roles));
        })).filter((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.nonEmpty()))).map((Function1 & Serializable)x$34 -> (TenantUser)x$34.get())).toSeq();
        Seq groups = ((IterableOnceOps)((IterableOnceOps)((IterableOps)groupRecords.filter((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$createPlatformUser$9(x$35)))).map((Function1 & Serializable)x$36 -> x$36.group())).toSet().map((Function1 & Serializable)groupId -> {
            Seq groupInfo = (Seq)groupRecords.filter((Function1 & Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$createPlatformUser$12(groupId, x$37)));
            Set roles = ((IterableOnceOps)groupInfo.map((Function1 & Serializable)x$38 -> x$38.role())).toSet();
            boolean isOwner = groupInfo.exists((Function1 & Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)x$39.isOwner()));
            return new ConsentGroupMembership((String)groupId, (Set<String>)roles, isOwner);
        })).toSeq();
        return new PlatformUser(userId, (Seq<TenantUser>)tenantUsers, (Seq<ConsentGroupMembership>)groups);
    }

    @Override
    public Future<Seq<TenantUser>> getTenantUsers(TenantUser user) {
        return this.readAllTenantUsers(user).map((Function1 & Serializable)p -> (Seq)p.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.enabled())), this.ec());
    }

    private Future<Seq<TenantUser>> readAllTenantUsers(TenantUser user) {
        Query users = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$40 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$40.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.tenant(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(users)).result()).map((Function1 & Serializable)records -> {
            Seq userRecords = (Seq)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$4(record)));
            Seq roleRecords = (Seq)records.filter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$5(record)));
            Seq users = (Seq)userRecords.map((Function1 & Serializable)user -> {
                Set roles = ((IterableOnceOps)((IterableOps)roleRecords.filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$readAllTenantUsers$7(user, role)))).map((Function1 & Serializable)x$41 -> x$41.role_name())).toSet();
                return this.createTenantUser((UserRoleRecord)user, (Set<String>)roles);
            });
            return users;
        }, this.ec());
    }

    private TenantUser createTenantUser(UserRoleRecord user, Set<String> roles) {
        return new TenantUser(user.userId(), user.tenant(), roles, user.isOwner(), user.name(), user.email(), user.enabled());
    }

    @Override
    public Future<Seq<TenantUser>> getDisabledTenantUserAccounts(TenantUser tenantUser) {
        return this.readAllTenantUsers(tenantUser).map((Function1 & Serializable)p -> (Seq)p.filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.enabled())), this.ec());
    }

    @Override
    public Future<TenantUser> getTenantUser(TenantUser tenantUser, String userId) {
        Query users = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag)).filter((Function1 & Serializable)x$42 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$42.tenant(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)tenantUser.tenant(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$43 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$43.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(users)).result()).map((Function1 & Serializable)roleRecords -> {
            UserRoleRecord user = (UserRoleRecord)roleRecords.find((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$14(role))).getOrElse((Function0 & Serializable)() -> {
                throw new UserSearchFailure(userId);
            });
            Set roles = ((IterableOnceOps)((IterableOps)((IterableOps)roleRecords.filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)role.enabled()))).filter((Function1 & Serializable)role -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getTenantUser$17(role)))).map((Function1 & Serializable)x$44 -> x$44.role_name())).toSet();
            return this.createTenantUser(user, (Set<String>)roles);
        }, this.ec());
    }

    @Override
    public Future<Seq<ConsentGroup>> getConsentGroups(Seq<String> groupIds) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$45 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$45.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).inSet((Iterable)groupIds, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag))).on((Function2 & Serializable)(x$46, x$47) -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$46.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(x$47.group(), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            Set groups = ((IterableOnceOps)((IterableOps)records.map((Function1 & Serializable)x$48 -> (ConsentGroupRecord)x$48._1())).map((Function1 & Serializable)g -> new Tuple2((Object)g.id(), (Object)g.tenant()))).toSet();
            Seq members = (Seq)((IterableOps)records.map((Function1 & Serializable)x$49 -> (ConsentGroupMemberRecord)x$49._2())).filter((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$9(x$50)));
            Seq roles = (Seq)((IterableOps)records.map((Function1 & Serializable)x$51 -> (ConsentGroupMemberRecord)x$51._2())).filterNot((Function1 & Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$11(x$52)));
            return ((IterableOnceOps)groups.map((Function1 & Serializable)group -> {
                Seq groupUsers = (Seq)members.filter((Function1 & Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$13(group, x$53)));
                Seq groupMembers = (Seq)groupUsers.map((Function1 & Serializable)member -> {
                    Seq memberRoles = (Seq)((IterableOps)((IterableOps)roles.filter((Function1 & Serializable)x$54 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$15(group, x$54)))).filter((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroups$16(member, x$55)))).map((Function1 & Serializable)x$56 -> x$56.role());
                    return new ConsentGroupMember(member.userId(), (Set<String>)memberRoles.toSet(), member.isOwner());
                });
                return new ConsentGroup((String)group._1(), (String)group._2(), (Seq<ConsentGroupMember>)groupMembers);
            })).toSeq();
        }, this.ec());
    }

    @Override
    public Future<ConsentGroup> getConsentGroup(UserIdentity user, String groupId) {
        Query consentGroupQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$57 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$57.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)groupQuery -> this.consentGroupMembershipQuery(user, groupQuery.id()).map((Function1 & Serializable)x$58 -> {
            ConsentGroupTables.ConsentGroupMemberTable consentGroupMemberTable = x$58;
            ConsentGroupTables.ConsentGroupTable consentGroupTable = groupQuery;
            return consentGroupTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        Future queries = this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupQuery)).result()).flatMap((Function1 & Serializable)group -> this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$59 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$59.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result()).map((Function1 & Serializable)members -> new Tuple2(group, members), this.ec()), this.ec());
        return queries.map((Function1 & Serializable)result -> {
            if (((SeqOps)result._1()).isEmpty()) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            ConsentGroupRecord group = (ConsentGroupRecord)((IterableOps)result._1()).head();
            String id = group.id();
            String tenant = group.tenant();
            Seq members = (Seq)result._2();
            Seq users = (Seq)members.filter((Function1 & Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$10(x$60)));
            Seq memberList = (Seq)users.map((Function1 & Serializable)user -> {
                Seq userRoles = (Seq)((IterableOps)((IterableOps)members.filter((Function1 & Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$12(user, x$61)))).filterNot((Function1 & Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroup$13(x$62)))).map((Function1 & Serializable)x$63 -> x$63.role());
                return ConsentGroupMember$.MODULE$.apply(user.userId(), (Seq<String>)userRoles, user.isOwner());
            });
            return new ConsentGroup(id, tenant, (Seq<ConsentGroupMember>)memberList);
        }, this.ec());
    }

    private Query<ConsentGroupTables.ConsentGroupMemberTable, ConsentGroupMemberRecord, Seq> consentGroupMembershipQuery(UserIdentity user, Rep<String> groupId) {
        return TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$64 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$64.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq(groupId, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$65 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$65.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)x$66 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$66.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
    }

    @Override
    public Future<ConsentGroupMember> getConsentGroupMember(UserIdentity user, String groupId, String userId) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupMemberTable(this, (Tag)tag)).filter((Function1 & Serializable)x$67 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$67.group(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).filter((Function1 & Serializable)member -> BooleanColumnExtensionMethods$.MODULE$.$bar$bar$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)userId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(((JdbcProfile)this.dbConfig().profile()).api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.userId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)user.id(), (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()))), new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(member.role(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)"", (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query)).result()).map((Function1 & Serializable)records -> {
            if (!records.exists((Function1 & Serializable)x$68 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$5(user, x$68)))) {
                throw new ConsentGroupSearchFailure(groupId);
            }
            Seq groupMemberRecords = (Seq)records.filter((Function1 & Serializable)x$69 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$6(userId, x$69)));
            Seq userRecords = (Seq)groupMemberRecords.filter((Function1 & Serializable)x$70 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$7(x$70)));
            if (userRecords.isEmpty()) {
                throw new ConsentGroupMemberSearchFailure(userId);
            }
            Seq roles = (Seq)((IterableOps)groupMemberRecords.filterNot((Function1 & Serializable)x$71 -> BoxesRunTime.boxToBoolean((boolean)TenantQueriesImpl.$anonfun$getConsentGroupMember$8(x$71)))).map((Function1 & Serializable)x$72 -> x$72.role());
            return ConsentGroupMember$.MODULE$.apply(((ConsentGroupMemberRecord)userRecords.head()).userId(), (Seq<String>)roles, ((ConsentGroupMemberRecord)userRecords.head()).isOwner());
        }, this.ec());
    }

    @Override
    public Future<ConsentGroupUser> getConsentGroupUser(UserIdentity user, String groupId) {
        Query consentGroupQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new ConsentGroupTables.ConsentGroupTable(this, (Tag)tag)).filter((Function1 & Serializable)x$73 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$73.id(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)groupId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).flatMap((Function1 & Serializable)groupQuery -> this.consentGroupMembershipQuery(user, groupQuery.id()).map((Function1 & Serializable)x$74 -> {
            ConsentGroupTables.ConsentGroupMemberTable consentGroupMemberTable = x$74;
            ConsentGroupTables.ConsentGroupTable consentGroupTable = groupQuery;
            return consentGroupTable;
        }, Shape$.MODULE$.tableShape((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(consentGroupQuery)).result().headOption()).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ConsentGroupSearchFailure(groupId);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            ConsentGroupRecord group = (ConsentGroupRecord)some.value();
            ConsentGroupUser consentGroupUser = new ConsentGroupUser(user.id(), group.id(), group.tenant());
            return consentGroupUser;
        }, this.ec());
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$5(UserRoleRecord record) {
        return record.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$8(UserRoleRecord record) {
        return !record.role_name().isBlank() && record.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$determineOriginOfUsers$12(Tuple2 x$15) {
        return ((Option)x$15._1()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$determineOriginOfUsers$14(Tuple2 x$17) {
        return ((Option)x$17._2()).isDefined();
    }

    private static final Origin determineOrigin$1(String userId, Set tenantUserIds$1, Set platformUserIds$1) {
        return tenantUserIds$1.contains((Object)userId) ? Origin.Tenant : (platformUserIds$1.contains((Object)userId) ? Origin.Platform : Origin.IDP);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUsers$9(Tuple2 x$22) {
        return ((Option)x$22._1()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUsers$11(String userId$1, UserRoleRecord x$24) {
        String string = x$24.userId();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUsers$12(Tuple2 x$25) {
        return ((Option)x$25._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getPlatformUsers$14(String userId$1, ConsentGroupMemberRecord x$27) {
        String string = x$27.userId();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPlatformUser$3(String tenant$3, UserRoleRecord x$29) {
        String string = x$29.tenant();
        String string2 = tenant$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPlatformUser$4(UserRoleRecord x$30) {
        return x$30.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$createPlatformUser$6(UserRoleRecord x$32) {
        return x$32.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$createPlatformUser$9(ConsentGroupMemberRecord x$35) {
        return x$35.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$createPlatformUser$12(String groupId$1, ConsentGroupMemberRecord x$37) {
        String string = x$37.group();
        String string2 = groupId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$4(UserRoleRecord record) {
        return record.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$5(UserRoleRecord record) {
        return !record.role_name().isBlank() && record.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$readAllTenantUsers$7(UserRoleRecord user$3, UserRoleRecord role) {
        String string = role.userId();
        String string2 = user$3.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$14(UserRoleRecord role) {
        return role.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getTenantUser$17(UserRoleRecord role) {
        return !role.role_name().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$9(ConsentGroupMemberRecord x$50) {
        return x$50.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$11(ConsentGroupMemberRecord x$52) {
        return x$52.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$13(Tuple2 group$1, ConsentGroupMemberRecord x$53) {
        String string = x$53.group();
        Object object = group$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$15(Tuple2 group$1, ConsentGroupMemberRecord x$54) {
        String string = x$54.group();
        Object object = group$1._1();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroups$16(ConsentGroupMemberRecord member$1, ConsentGroupMemberRecord x$55) {
        String string = x$55.userId();
        String string2 = member$1.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$10(ConsentGroupMemberRecord x$60) {
        return x$60.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$12(ConsentGroupMemberRecord user$5, ConsentGroupMemberRecord x$61) {
        String string = x$61.userId();
        String string2 = user$5.userId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroup$13(ConsentGroupMemberRecord x$62) {
        return x$62.role().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$5(UserIdentity user$7, ConsentGroupMemberRecord x$68) {
        String string = x$68.userId();
        String string2 = user$7.id();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$6(String userId$3, ConsentGroupMemberRecord x$69) {
        String string = x$69.userId();
        String string2 = userId$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$7(ConsentGroupMemberRecord x$70) {
        return x$70.role().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getConsentGroupMember$8(ConsentGroupMemberRecord x$71) {
        return x$71.role().isEmpty();
    }

    public TenantQueriesImpl() {
        UserQueries.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        CafienneJDBCConfig.$init$(this);
        QueryDBSchema.$init$(this);
        TenantTables.$init$(this);
        ConsentGroupTables.$init$(this);
        this.ec = this.db().ioExecutionContext();
        this.rolesQuery = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TenantTables.UserRoleTable(this, (Tag)tag));
    }
}

