/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.akkahttp.platform;

import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import ch.megard.akka.http.cors.scaladsl.settings.CorsSettings;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.identity.PlatformOwner;
import org.cafienne.actormodel.identity.PlatformUser;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.authentication.AuthenticatedUser;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.akkahttp.authentication.IdentityProvider;
import org.cafienne.infrastructure.akkahttp.route.AuthenticatedRoute;
import org.cafienne.infrastructure.akkahttp.route.AuthenticatedRoute$OIDCAuthentication$;
import org.cafienne.infrastructure.akkahttp.route.CaseServiceRoute;
import org.cafienne.infrastructure.akkahttp.route.CommandRoute;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.Value;
import org.cafienne.service.akkahttp.tenant.model.TenantAPI;
import org.cafienne.service.akkahttp.tenant.model.TenantAPI$;
import org.cafienne.system.CaseSystem;
import org.cafienne.tenant.actorapi.command.platform.CreateTenant;
import org.cafienne.tenant.actorapi.command.platform.DisableTenant;
import org.cafienne.tenant.actorapi.command.platform.EnableTenant;
import org.cafienne.tenant.actorapi.command.platform.PlatformTenantCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SecurityRequirement(name="openId", scopes={"openid"})
@Path(value="/platform")
@ScalaSignature(bytes="\u0006\u0005\t\u0015f\u0001B\u0006\r\u0001]A\u0001b\n\u0001\u0003\u0006\u0004%\t\u0005\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!)\u0001\u0007\u0001C\u0001c!)Q\u0007\u0001C!m!)\u0011\u000b\u0001C\u0001m!1\u0011q\u0012\u0001\u0005\u0002YBa!a9\u0001\t\u00031\u0004B\u0002B\u0002\u0001\u0011\u0005a\u0007C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\t-\u0004\u0001\"\u0001\u0003n\ti\u0001\u000b\\1uM>\u0014XNU8vi\u0016T!!\u0004\b\u0002\u0011Ad\u0017\r\u001e4pe6T!a\u0004\t\u0002\u0011\u0005\\7.\u00195uiBT!!\u0005\n\u0002\u000fM,'O^5dK*\u00111\u0003F\u0001\tG\u00064\u0017.\u001a8oK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010&\u001b\u0005\u0001#BA\u0011#\u0003\u0015\u0011x.\u001e;f\u0015\ty1E\u0003\u0002%%\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017B\u0001\u0014!\u00051\u0019u.\\7b]\u0012\u0014v.\u001e;f\u0003)\u0019\u0017m]3TsN$X-\\\u000b\u0002SA\u0011!&L\u0007\u0002W)\u0011AFE\u0001\u0007gf\u001cH/Z7\n\u00059Z#AC\"bg\u0016\u001c\u0016p\u001d;f[\u0006Y1-Y:f'f\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u0011!\u0007\u000e\t\u0003g\u0001i\u0011\u0001\u0004\u0005\u0006O\r\u0001\r!K\u0001\u0007e>,H/Z:\u0016\u0003]\u0002\"\u0001\u000f(\u000f\u0005eZeB\u0001\u001eI\u001d\tYTI\u0004\u0002=\u0005:\u0011Q\bQ\u0007\u0002})\u0011qHF\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\u000bA!Y6lC&\u00111\tR\u0001\u0005QR$\bOC\u0001B\u0013\t1u)\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t\u0019E)\u0003\u0002J\u0015\u000611/\u001a:wKJT!AR$\n\u00051k\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0013*K!a\u0014)\u0003\u000bI{W\u000f^3\u000b\u00051k\u0015\u0001D2sK\u0006$X\rV3oC:$\b\u0006B\u0003T;z\u0003\"\u0001V.\u000e\u0003US!AV,\u0002\u0005I\u001c(B\u0001-Z\u0003\t98OC\u0001[\u0003\u0015Q\u0017M^1y\u0013\taVK\u0001\u0005D_:\u001cX/\\3t\u0003\u00151\u0018\r\\;fY\u0005y\u0016%\u00011\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007\u0006C\u0003ceN,ho\u001e=\u0011\u0005\r\u0004X\"\u00013\u000b\u0005\u00154\u0017A\u00039be\u0006lW\r^3sg*\u0011q\r[\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002jU\u0006\u0019q.Y:\u000b\u0005-d\u0017A\u0001<4\u0015\tig.A\u0004to\u0006<w-\u001a:\u000b\u0003=\f!![8\n\u0005E$'a\u0003*fcV,7\u000f\u001e\"pIf\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\nA/\u0001\u0004UK:\fg\u000e^\u0001\te\u0016\fX/\u001b:fIf\t\u0011!A\u0004d_:$XM\u001c;-\u0003e\\SA_A\u0001\u0003\u0007\u0001\"a\u001f@\u000e\u0003qT!! 4\u0002\u000b5,G-[1\n\u0005}d(aB\"p]R,g\u000e^\u0001\u0007g\u000eDW-\\1,\r\u0005\u0015\u00111BA\u0007!\rY\u0018qA\u0005\u0004\u0003\u0013a(AB*dQ\u0016l\u0017-\u0001\bj[BdW-\\3oi\u0006$\u0018n\u001c8$\u0005\u0005=\u0001\u0003BA\t\u0003oqA!a\u0005\u000229!\u0011QCA\u0016\u001d\u0011\t9\"a\n\u000f\t\u0005e\u0011Q\u0005\b\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005\u0005bbA\u001f\u0002 %\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI1!!\u000b\u000f\u0003\u0019!XM\\1oi&!\u0011QFA\u0018\u0003\u0015iw\u000eZ3m\u0015\r\tICD\u0005\u0005\u0003g\t)$A\u0005UK:\fg\u000e^!Q\u0013*!\u0011QFA\u0018\u0013\u0011\tI$a\u000f\u0003\u0019Q+g.\u00198u\r>\u0014X.\u0019;\u000b\t\u0005M\u0012Q\u0007\u0015\u0013\u000b\u0005}\u0012qIA%e\u00065\u0013\u0011KA*\u0003/\nI\u0006\u0005\u0003\u0002B\u0005\rS\"\u00014\n\u0007\u0005\u0015cMA\u0005Pa\u0016\u0014\u0018\r^5p]\u000691/^7nCJL\u0018EAA&\u0003U\u0011VmZ5ti\u0016\u0014\b%\u0019\u0011oK^\u0004C/\u001a8b]R\f#!a\u0014\u0002\u0007J+w-[:uKJ\u0004\u0013\r\t8fo\u0002\"XM\\1oi\u0002:\u0018\u000e\u001e5!_:,\u0007e\u001c:![>\u0014X\rI;tKJ\u001c\b%\u00198eA\u0005$\b\u0005\\3bgR\u0004sN\\3!_^tWM]\u0001\u0005i\u0006<7\u000f\f\u0002\u0002V\u0005\nQ\"A\u0005sKN\u0004xN\\:fg2\"\u00111LA9W%\tiF]A4\u0003W\ni\u0007\u0005\u0003\u0002`\u0005\rTBAA1\u0015\r\t9FZ\u0005\u0005\u0003K\n\tGA\u0006Ba&\u0014Vm\u001d9p]N,\u0017EAA5\u0003y!VM\\1oi\u0002\u0012XmZ5ti\u0016\u0014X\r\u001a\u0011tk\u000e\u001cWm]:gk2d\u00170\u0001\u0007sKN\u0004xN\\:f\u0007>$W-\t\u0002\u0002p\u0005\u0019!\u0007\r\u001b,\u0013\u0005u#/a\u001d\u0002l\u0005]\u0014EAA;\u0003u!VM\\1oi\u0002JgNZ8s[\u0006$\u0018n\u001c8!SN\u0004\u0013N\u001c<bY&$\u0017EAA=\u0003\r!\u0004\u0007\r\u0015\u0004\u000b\u0005u\u0004c\u0001+\u0002\u0000%\u0019\u0011\u0011Q+\u0003\tA{5\u000b\u0016\u0015\u0007\u000b\u0005\u0015U,a#\u0011\u0007Q\u000b9)C\u0002\u0002\nV\u0013A\u0001U1uQ\u0006\u0012\u0011QR\u0001\u0002_\u0005iA-[:bE2,G+\u001a8b]RDSCBA \u0003\u000f\n\u0019J]AL\u0003#\nY*ZAO\u0003/\n\u0019.\t\u0002\u0002\u0016\u0006\u0001B)[:bE2,\u0007%\u0019\u0011uK:\fg\u000e^\u0011\u0003\u00033\u000ba\u0007R5tC\nd\u0017N\\4!C\u0002\"XM\\1oi\u0002\u001a\u0017M\u001c\u0011p]2L\bEY3!I>tW\r\t2zAAd\u0017\r\u001e4pe6\u0004sn\u001e8feNd#!!\u0016-\u0005\u0005}5fEAQ\u0003O\u000bIK]AV\u0003_\u000b\t,!\u0001\u0002@V4\b\u0003BA!\u0003GK1!!*g\u0005%\u0001\u0016M]1nKR,'/\u0001\u0003oC6,\u0017EAA\u0015C\t\ti+A\u000bUQ\u0016\u0004C/\u001a8b]R\u0004Co\u001c\u0011eSN\f'\r\\3\u0002\u0005%tGEAAZ\u0013\u0011\t),a.\u0002\tA\u000bE\u000b\u0013\u0006\u0005\u0003s\u000bY,A\u0006QCJ\fW.\u001a;fe&s'bAA_M\u0006)QM\\;ng.2\u0011QAA\u0006\u0003\u0003\u001c#!a1\u0011\t\u0005\u0015\u0017Q\u001a\b\u0005\u0003\u000f\fI\r\u0005\u0002>5%\u0019\u00111\u001a\u000e\u0002\rA\u0013X\rZ3g\u0013\u0011\ty-!5\u0003\rM#(/\u001b8h\u0015\r\tYM\u0007\u0017\u0005\u00037\n\t\bK\u0002\u0007\u0003/\u00042\u0001VAm\u0013\r\tY.\u0016\u0002\u0004!V#\u0006F\u0002\u0004\u0002\u0006v\u000by.\t\u0002\u0002b\u0006\trf\u001f;f]\u0006tG/`\u0018eSN\f'\r\\3\u0002\u0019\u0015t\u0017M\u00197f)\u0016t\u0017M\u001c;)+\u001d\ty$a\u0012\u0002hJ\fY/!\u0015\u0002p\u0016\f\t0a\u0016\u0002z\u0006\u0012\u0011\u0011^\u0001\u0010\u000b:\f'\r\\3!C\u0002\"XM\\1oi\u0006\u0012\u0011Q^\u00016\u000b:\f'\r\\5oO\u0002\n\u0007\u0005^3oC:$\beY1oA=tG.\u001f\u0011cK\u0002\"wN\\3!Ef\u0004\u0003\u000f\\1uM>\u0014X\u000eI8x]\u0016\u00148\u000f\f\u0002\u0002V1\u0012\u00111_\u0016\u0014\u0003C\u000b9+!+s\u0003k\fy+!-\u0002\u0002\u0005}VO^\u0011\u0003\u0003o\fA\u0003\u00165fAQ,g.\u00198uAQ|\u0007%\u001a8bE2,G\u0006BA.\u0003cB3aBAlQ\u00199\u0011QQ/\u0002\u0000\u0006\u0012!\u0011A\u0001\u0011_m$XM\\1oiv|SM\\1cY\u0016\f!cZ3u+N,'/\u00138g_Jl\u0017\r^5p]\"2\u0001Ba\u0002^\u0005\u001b\u00012\u0001\u0016B\u0005\u0013\r\u0011Y!\u0016\u0002\t!J|G-^2fg2\nq\f\u000b\n\t\u0003\u007f\t9E!\u0005s\u0005+\t\tF!\u0007\u0002X\tm\u0011E\u0001B\n\u0003\u0011:U\r\u001e\u0011vg\u0016\u0014\b%\u001b8g_Jl\u0017\r^5p]\u0002zg\rI2veJ,g\u000e\u001e\u0011vg\u0016\u0014\u0018E\u0001B\f\u00039\u0012V\r\u001e:jKZ,7\u000f\t;iK\u0002*8/\u001a:!S:4wN]7bi&|g\u000eI8gA\r,(O]3oi\u0002*8/\u001a:-\u0005\u0005UC\u0006\u0002B\u000f\u0005kYC\"!\u0018\u0002l\t}!Oa\tx\u0005O\t#A!\t\u0002\u0007I\u0002\u0004'\t\u0002\u0003&\u0005q\u0013\t\u001c7!kN,'\u000fI5oM>\u0014X.\u0019;j_:\u00043N\\8x]\u0002:\u0018\u000e\u001e5j]\u0002\"\b.\u001a\u0011qY\u0006$hm\u001c:nY\t\u0011IcK\u0003{\u0003\u0003\u0011Yc\u000b\u0004\u0002\u0006\u0005-!QF\u0012\u0003\u0005_\u0001B!!\u0005\u00032%!!1GA\u001e\u0005I\u0001F.\u0019;g_JlWk]3s\r>\u0014X.\u0019;,\u0013\u0005u\u00131\u000eB\u001ce\nm\u0012E\u0001B\u001d\u0003\r!\u0004'M\u0011\u0003\u0005{\t\u0011&V:fe\u0002J7\u000f\t8pi\u0002\u0012XmZ5ti\u0016\u0014X\r\u001a\u0011j]\u0002\"\b.\u001a\u0011dCN,\u0007e]=ti\u0016l\u0007f\u0001\u0005\u0003BA\u0019AKa\u0011\n\u0007\t\u0015SKA\u0002H\u000bRCc\u0001CAC;\n%\u0013E\u0001B&\u0003\u0015ySo]3s\u00035\u0001H.\u0019;g_Jlwj\u001e8feR\u0019qG!\u0015\t\u000f\tM\u0013\u00021\u0001\u0003V\u0005A1/\u001e2S_V$X\r\u0005\u0004\u001a\u0005/\u0012YfN\u0005\u0004\u00053R\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011iFa\u001a\u000e\u0005\t}#\u0002\u0002B1\u0005G\n\u0001\"\u001b3f]RLG/\u001f\u0006\u0004\u0005K\u0012\u0012AC1di>\u0014Xn\u001c3fY&!!\u0011\u000eB0\u00055\u0001F.\u0019;g_Jlwj\u001e8fe\u0006Y\u0011m]6QY\u0006$hm\u001c:n)\r9$q\u000e\u0005\b\u0005cR\u0001\u0019\u0001B:\u0003\u001d\u0019w.\\7b]\u0012\u0004BA!\u001e\u0003\u00026\u0011!q\u000f\u0006\u0004\u001b\te$\u0002\u0002B9\u0005wRAA! \u0003\u0000\u0005A\u0011m\u0019;pe\u0006\u0004\u0018NC\u0002\u0002*IIAAa!\u0003x\t)\u0002\u000b\\1uM>\u0014X\u000eV3oC:$8i\\7nC:$\u0007F\u0002\u0001\u0002\u0006v\u00139)\t\u0002\u0003\n\u0006Iq\u0006\u001d7bi\u001a|'/\u001c\u0015\f\u0001\t5\u0015q\u0015BM\u0005;\u0013y\n\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\r\u0011\u0019JZ\u0001\tg\u0016\u001cWO]5us&!!q\u0013BI\u0005M\u0019VmY;sSRL(+Z9vSJ,W.\u001a8uC\t\u0011Y*\u0001\u0004pa\u0016t\u0017\nZ\u0001\u0007g\u000e|\u0007/Z:-\u0005\t\u0005\u0016E\u0001BR\u0003\u0019y\u0007/\u001a8jI\u0002")
public class PlatformRoute
implements CommandRoute {
    private final CaseSystem caseSystem;
    private IdentityProvider userCache;
    private IdentityProvider uc;
    private volatile AuthenticatedRoute$OIDCAuthentication$ OIDCAuthentication$module;
    private CorsSettings org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings;
    private RejectionHandler org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler;
    private Directive<BoxedUnit> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors;
    private Function1<RequestContext, Future<RouteResult>> route;
    private Option<Function1<RequestContext, Future<RouteResult>>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes;
    private String prefix;
    private boolean addToSwaggerRoutes;
    private Buffer<Class<?>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Function1<RequestContext, Future<RouteResult>> askModelActor(ModelCommand command) {
        return CommandRoute.askModelActor$(this, command);
    }

    @Override
    public ExceptionHandler exceptionHandler() {
        return AuthenticatedRoute.exceptionHandler$(this);
    }

    @Override
    @Deprecated
    public Function1<RequestContext, Future<RouteResult>> optionalUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.optionalUser$(this, subRoute);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> authenticatedUser(Function1<AuthenticatedUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.authenticatedUser$(this, subRoute);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> validUser(Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return AuthenticatedRoute.validUser$(this, subRoute);
    }

    @Override
    public void caseSystemMustBeHealthy() {
        AuthenticatedRoute.caseSystemMustBeHealthy$(this);
    }

    @Override
    public RejectionHandler requestServiceRejectionHandler() {
        return CaseServiceRoute.requestServiceRejectionHandler$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> defaultExceptionHandler(Throwable t) {
        return CaseServiceRoute.defaultExceptionHandler$(this, t);
    }

    @Override
    public Directive<BoxedUnit> writeLastModifiedHeader(ModelResponse response, String headerName) {
        return CaseServiceRoute.writeLastModifiedHeader$(this, response, headerName);
    }

    @Override
    public String writeLastModifiedHeader$default$2() {
        return CaseServiceRoute.writeLastModifiedHeader$default$2$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> completeCafienneJSONSeq(Seq<CafienneJson> seq) {
        return CaseServiceRoute.completeCafienneJSONSeq$(this, seq);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> completeJsonValue(Value<?> v) {
        return CaseServiceRoute.completeJsonValue$(this, v);
    }

    @Override
    public void addSubRoute(CaseServiceRoute subRoute) {
        CaseServiceRoute.addSubRoute$(this, subRoute);
    }

    @Override
    public Seq<Class<?>> apiClasses() {
        return CaseServiceRoute.apiClasses$(this);
    }

    @Override
    public void registerAPIRoute(CaseServiceRoute route) {
        CaseServiceRoute.registerAPIRoute$(this, route);
    }

    @Override
    public IdentityProvider userCache() {
        return this.userCache;
    }

    @Override
    public IdentityProvider uc() {
        return this.uc;
    }

    @Override
    public AuthenticatedRoute$OIDCAuthentication$ OIDCAuthentication() {
        if (this.OIDCAuthentication$module == null) {
            this.OIDCAuthentication$lzycompute$1();
        }
        return this.OIDCAuthentication$module;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$AuthenticatedRoute$_setter_$userCache_$eq(IdentityProvider x$1) {
        this.userCache = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$AuthenticatedRoute$_setter_$uc_$eq(IdentityProvider x$1) {
        this.uc = x$1;
    }

    @Override
    public CorsSettings org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings;
    }

    @Override
    public RejectionHandler org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler;
    }

    @Override
    public Directive<BoxedUnit> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    @Override
    public Option<Function1<RequestContext, Future<RouteResult>>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes_$eq(Option<Function1<RequestContext, Future<RouteResult>>> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$concatenatedSubRoutes = x$1;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public boolean addToSwaggerRoutes() {
        return this.addToSwaggerRoutes;
    }

    @Override
    public Buffer<Class<?>> org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses() {
        return this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings_$eq(CorsSettings x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$corsSettings = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler_$eq(RejectionHandler x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$rejectionHandler = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors_$eq(Directive<BoxedUnit> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$handleErrors = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$route_$eq(Function1<RequestContext, Future<RouteResult>> x$1) {
        this.route = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$prefix_$eq(String x$1) {
        this.prefix = x$1;
    }

    @Override
    public void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$addToSwaggerRoutes_$eq(boolean x$1) {
        this.addToSwaggerRoutes = x$1;
    }

    @Override
    public final void org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$_setter_$org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses_$eq(Buffer<Class<?>> x$1) {
        this.org$cafienne$infrastructure$akkahttp$route$CaseServiceRoute$$swaggerClasses = x$1;
    }

    private Logger logger$lzycompute() {
        PlatformRoute platformRoute = this;
        synchronized (platformRoute) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> routes() {
        return Directives$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{this.createTenant(), this.disableTenant(), this.enableTenant(), this.getUserInformation()}));
    }

    @Path(value="/")
    @POST
    @Operation(summary="Register a new tenant", description="Register a new tenant with one or more users and at least one owner", tags={"platform"}, responses={@ApiResponse(description="Tenant registered successfully", responseCode="204"), @ApiResponse(description="Tenant information is invalid", responseCode="400")})
    @RequestBody(description="Tenant", required=true, content={@Content(schema=@Schema(implementation=TenantAPI.TenantFormat.class))})
    @Consumes(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> createTenant() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathEndOrSingleSlash()).apply((Function0 & Serializable)() -> this.platformOwner((Function1<PlatformOwner, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)owner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(TenantAPI$.MODULE$.tenantReader()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)newTenant -> {
            String newTenantName = newTenant.name();
            List users = CollectionConverters$.MODULE$.SeqHasAsJava(newTenant.getTenantUsers()).asJava();
            return this.askPlatform(new CreateTenant((PlatformOwner)owner, newTenantName, newTenantName, users));
        }))));
    }

    @Path(value="/{tenant}/disable")
    @PUT
    @Operation(summary="Disable a tenant", description="Disabling a tenant can only be done by platform owners", tags={"platform"}, parameters={@Parameter(name="tenant", description="The tenant to disable", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Tenant registered successfully", responseCode="204"), @ApiResponse(description="Tenant information is invalid", responseCode="400")})
    public Function1<RequestContext, Future<RouteResult>> disableTenant() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.put()).apply((Function0 & Serializable)() -> this.platformOwner((Function1<PlatformOwner, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)owner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path(Directives$.MODULE$.Segment().$div(Directives$.MODULE$._segmentStringToPathMatcher("disable"), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t0()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)tenant -> this.askPlatform(new DisableTenant((PlatformOwner)owner, Directives$.MODULE$._string2NR(tenant).name())))));
    }

    @Path(value="/{tenant}/enable")
    @PUT
    @Operation(summary="Enable a tenant", description="Enabling a tenant can only be done by platform owners", tags={"platform"}, parameters={@Parameter(name="tenant", description="The tenant to enable", in=ParameterIn.PATH, schema=@Schema(implementation=String.class), required=true)}, responses={@ApiResponse(description="Tenant registered successfully", responseCode="204"), @ApiResponse(description="Tenant information is invalid", responseCode="400")})
    public Function1<RequestContext, Future<RouteResult>> enableTenant() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.put()).apply((Function0 & Serializable)() -> this.platformOwner((Function1<PlatformOwner, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)owner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path(Directives$.MODULE$.Segment().$div(Directives$.MODULE$._segmentStringToPathMatcher("enable"), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t0()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)tenant -> this.askPlatform(new EnableTenant((PlatformOwner)owner, Directives$.MODULE$._string2NR(tenant).name())))));
    }

    @Path(value="/user")
    @GET
    @Operation(summary="Get user information of current user", description="Retrieves the user information of current user", tags={"platform"}, responses={@ApiResponse(responseCode="200", description="All user information known within the platform", content={@Content(schema=@Schema(implementation=TenantAPI.PlatformUserFormat.class))}), @ApiResponse(responseCode="401", description="User is not registered in the case system")})
    @Produces(value={"application/json"})
    public Function1<RequestContext, Future<RouteResult>> getUserInformation() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathPrefix(Directives$.MODULE$._segmentStringToPathMatcher("user"))).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathEndOrSingleSlash()).apply((Function0 & Serializable)() -> this.validUser((Function1<PlatformUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)platformUser -> this.completeJsonValue(platformUser.toValue())))));
    }

    public Function1<RequestContext, Future<RouteResult>> platformOwner(Function1<PlatformOwner, Function1<RequestContext, Future<RouteResult>>> subRoute) {
        return this.authenticatedUser((Function1<AuthenticatedUser, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)user -> Cafienne$.MODULE$.isPlatformOwner(user.id()) ? (Function1)subRoute.apply((Object)new PlatformOwner(user.id())) : Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.Unauthorized(), (Function0 & Serializable)() -> "Only platform owners can access this route", Marshaller$.MODULE$.StringMarshaller()));
    }

    public Function1<RequestContext, Future<RouteResult>> askPlatform(PlatformTenantCommand command) {
        return this.askModelActor(command);
    }

    private final void OIDCAuthentication$lzycompute$1() {
        PlatformRoute platformRoute = this;
        synchronized (platformRoute) {
            if (this.OIDCAuthentication$module == null) {
                this.OIDCAuthentication$module = new AuthenticatedRoute$OIDCAuthentication$(this);
            }
        }
    }

    public PlatformRoute(CaseSystem caseSystem) {
        this.caseSystem = caseSystem;
        LazyLogging.$init$((LazyLogging)this);
        CaseServiceRoute.$init$(this);
        AuthenticatedRoute.$init$(this);
        CommandRoute.$init$(this);
        Statics.releaseFence();
    }
}

